/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GuiTools;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.StringTokenizer;

public class GLabel
extends Canvas {
    protected String[] lines;
    protected int lineHeight;
    protected int blockWidth;
    protected int blockHeight;
    protected int fontAscent;
    protected Color colorLeft;
    protected Color colorRight;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int alignment = 0;

    public GLabel(String string) {
        this(string, 0);
    }

    public GLabel(String string, int n) {
        this.alignment = n;
        this.setText(string);
    }

    public void setBackground(Color color, Color color2) {
        this.colorLeft = color;
        this.colorRight = color2;
        this.repaint();
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) == '\t') {
                stringBuffer.append("      ");
                continue;
            }
            stringBuffer.append(string2);
        }
        string = stringBuffer.toString();
        int n = 1;
        int n2 = string.indexOf(10);
        while (n2 != -1) {
            ++n;
            n2 = string.indexOf(10, n2 + 1);
        }
        this.lines = new String[n];
        int n3 = 0;
        n2 = 0;
        int n4 = string.indexOf(10);
        while (n4 != -1) {
            this.lines[n3++] = string.substring(n2, n4);
            n2 = n4 + 1;
            n4 = string.indexOf(10, n2);
        }
        this.lines[n3] = string.substring(n2);
        this.blockWidth = 0;
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.blockWidth != 0 && this.blockHeight != 0) {
            return new Dimension(this.blockWidth, this.blockHeight);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.blockWidth = 0;
        this.blockHeight = 0;
        int n = 0;
        while (n < this.lines.length) {
            int n2 = fontMetrics.stringWidth(this.lines[n]);
            if (n2 > this.blockWidth) {
                this.blockWidth = n2;
            }
            ++n;
        }
        this.fontAscent = fontMetrics.getAscent();
        this.lineHeight = fontMetrics.getHeight();
        this.blockHeight = this.lines.length * this.lineHeight;
        return new Dimension(this.blockWidth, this.blockHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.colorLeft != null && this.colorRight != null) {
            GuiTools.fillRectHorizontal(graphics, dimension, this.colorLeft, this.colorRight);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.isEnabled()) {
            graphics.setColor(SystemColor.controlText);
            this.draw(graphics, 0, 0);
        } else {
            graphics.setColor(SystemColor.controlLtHighlight);
            this.draw(graphics, 1, 1);
            graphics.setColor(SystemColor.controlShadow);
            this.draw(graphics, 0, 0);
        }
    }

    protected void draw(Graphics graphics, int n, int n2) {
        block4: {
            block5: {
                block3: {
                    if (this.alignment != 0) break block3;
                    int n3 = 0;
                    while (n3 < this.lines.length) {
                        graphics.drawString(this.lines[n3], n, n2 + this.fontAscent + n3 * this.lineHeight);
                        ++n3;
                    }
                    break block4;
                }
                if (this.alignment != 2) break block5;
                Dimension dimension = this.getSize();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n4 = 0;
                while (n4 < this.lines.length) {
                    int n5 = fontMetrics.stringWidth(this.lines[n4]);
                    graphics.drawString(this.lines[n4], n + dimension.width - n5, n2 + this.fontAscent + n4 * this.lineHeight);
                    ++n4;
                }
                break block4;
            }
            if (this.alignment != 1) break block4;
            Dimension dimension = this.getSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n6 = 0;
            while (n6 < this.lines.length) {
                int n7 = fontMetrics.stringWidth(this.lines[n6]);
                graphics.drawString(this.lines[n6], n + (dimension.width - n7) / 2, n2 + this.fontAscent + n6 * this.lineHeight);
                ++n6;
            }
        }
    }
}

