/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;

public class GImageCanvas
extends Canvas {
    protected Image image;
    protected int insetWest;
    protected int insetEast;
    protected int insetNorth;
    protected int insetSouth;
    protected double proportion = 1.0;
    protected boolean selected = false;
    protected Dimension minimumSize;

    public GImageCanvas() {
    }

    public GImageCanvas(Image image) {
        this.image = image;
    }

    public GImageCanvas(Image image, Insets insets) {
        this.image = image;
        this.setInsets(insets);
    }

    public GImageCanvas(Image image, int n, int n2, int n3, int n4) {
        this.image = image;
        this.setInsets(n, n2, n3, n4);
    }

    public GImageCanvas(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.insetWest = n2;
        this.insetEast = n4;
        this.insetSouth = n3;
        this.insetNorth = n;
        this.validate();
    }

    public void setProportion(double d) {
        this.proportion = d;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n = this.image.getWidth(this);
            n2 = this.image.getHeight(this);
        }
        if (n < 0 || n2 < 0) {
            n = 0;
            n2 = 0;
        }
        n = (int)(this.proportion * (double)n) + this.insetWest + this.insetEast;
        n2 = n2 + this.insetNorth + this.insetSouth;
        if (this.minimumSize != null && n < this.minimumSize.width) {
            n = this.minimumSize.width;
        }
        if (this.minimumSize != null && n2 < this.minimumSize.height) {
            n2 = this.minimumSize.height;
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize = dimension;
    }

    public void setMinimumSize(int n, int n2) {
        this.minimumSize = new Dimension(n, n2);
    }

    public void setImage(Image image) {
        this.image = image;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void paint(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        int n = (int)(this.proportion * (double)this.image.getWidth(this));
        int n2 = this.image.getHeight(this);
        Dimension dimension = this.getSize();
        int n3 = this.insetWest;
        if (dimension.width - this.insetWest - this.insetEast - n > 0) {
            n3 += (dimension.width - this.insetWest - this.insetEast - n) / 2;
        }
        int n4 = this.insetNorth;
        if (dimension.height - this.insetNorth - this.insetSouth - n2 > 0) {
            n4 += (dimension.height - this.insetNorth - this.insetSouth - n2) / 2;
        }
        graphics.drawImage(this.image, n3, n4, n, n2, this);
        if (this.selected) {
            graphics.setColor(Color.white);
            graphics.setXORMode(SystemColor.textHighlight);
            int n5 = 7;
            int n6 = 9;
            graphics.fillRect(n3 + 1, n4 + 1, n - 2, n6);
            graphics.fillRect(n3 + 1, n4 + n2 - n6 - 1, n - 2, n6);
            graphics.fillRect(n3 + 1, n4 + n6 + 1, n5, n2 - n6 - n6 - 2);
            graphics.fillRect(n3 + n - n5 - 1, n4 + n6 + 1, n5, n2 - n6 - n6 - 2);
        }
    }

    public void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) != 0 || (n & 2) != 0) {
            Dimension dimension = this.getSize();
            if (dimension.width != n4 || dimension.height != n5) {
                this.setSize(n4 + this.insetWest + this.insetEast, n5 + this.insetNorth + this.insetSouth);
                this.invalidate();
                this.validate();
                Container container = this.getParent();
                if (container != null) {
                    container.validate();
                }
            }
            return true;
        }
        if ((n & 0x20) != 0) {
            Dimension dimension = this.getSize();
            if (dimension.width != n4 || dimension.height != n5) {
                this.setSize(n4 + this.insetWest + this.insetEast, n5 + this.insetNorth + this.insetSouth);
                this.invalidate();
                this.validate();
                Container container = this.getParent();
                if (container != null) {
                    container.validate();
                }
            }
            this.repaint();
        }
        return true;
    }
}

