/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGControlRegionTranslation;
import de.jave.figlet.FIGControlRule;
import de.jave.figlet.FIGControlStageSeparator;
import de.jave.figlet.FIGControlTranslation;
import de.jave.figlet.FIGDriver;
import de.jave.io.IOTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public class FIGControlFile {
    public static final String SIGNATURE = "flc2a";
    public static final String BASIC_SIGNATURE = "flc";
    public static final String FILEENDING = ".flc";
    public String name;
    private FIGControlRule[] rules;

    FIGControlFile(String string) {
        this.name = !string.endsWith(FILEENDING) ? string + FILEENDING : string;
    }

    public int map(int n) {
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.rules.length) {
            FIGControlRule fIGControlRule = this.rules[n3];
            if (fIGControlRule instanceof FIGControlStageSeparator) {
                bl = false;
            } else {
                int n4 = fIGControlRule.map(n);
                if (n4 != -1 && !bl) {
                    n2 = n4;
                    bl = true;
                }
            }
            ++n3;
        }
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    private void warning(String string) {
        FIGDriver.warning("figlet control file " + this.name + ", " + string);
    }

    public boolean load() {
        Vector<FIGControlRule> vector = new Vector<FIGControlRule>(10, 10);
        try {
            URL uRL = IOTools.toUrl(this.name);
            BufferedReader bufferedReader = IOTools.openPossiblyZipped(uRL);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() != 0 && string.charAt(0) != '#' && !string.startsWith(BASIC_SIGNATURE)) {
                    switch (string.charAt(0)) {
                        case 't': {
                            int n = 0;
                            if (string.startsWith("\\-")) {
                                n = 2;
                            }
                            if (string.indexOf(45, n) == -1) {
                                vector.addElement(new FIGControlTranslation(string));
                                break;
                            }
                            vector.addElement(new FIGControlRegionTranslation(string));
                            break;
                        }
                        case 'f': {
                            vector.addElement(new FIGControlStageSeparator());
                            break;
                        }
                        case 'h': {
                            this.warning("Option h not yet implemented - ignored.");
                            break;
                        }
                        case 'j': {
                            this.warning("Option j not yet implemented - ignored.");
                            break;
                        }
                        case 'b': {
                            this.warning("Option b not yet implemented - ignored.");
                            break;
                        }
                        case 'u': {
                            this.warning("Option u not yet implemented - ignored.");
                            break;
                        }
                        case 'g': {
                            this.warning("Option g not yet implemented - ignored.");
                            break;
                        }
                        default: {
                            this.warning("'number number' not yet implemented - ignored.");
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.warning("Error loading FIGLet control file: " + iOException);
            return false;
        }
        this.rules = new FIGControlRule[vector.size()];
        int n = 0;
        while (n < this.rules.length) {
            this.rules[n] = (FIGControlRule)vector.elementAt(n);
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FIGLet Font >" + this.name + "< containing rules:\n");
        int n = 0;
        while (n < this.rules.length) {
            stringBuffer.append(" " + n + " " + this.rules[n].toString() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }

    public static void main(String[] stringArray) {
        FIGControlFile fIGControlFile = new FIGControlFile("upper");
        fIGControlFile.load();
        System.out.println((char)fIGControlFile.map(97));
        System.out.println((char)fIGControlFile.map(102));
        System.out.println((char)fIGControlFile.map(82));
    }
}

