//
// TinyPTC by Gaffer
// www.gaffer.org/tinyptc
//

#include "tinyptc.h"

#define width 320
#define height 200
#define size width*height
   
static int noise;
static int carry;
static int index;
static int seed = 0x12345;
static int pixel[size];

int main()
{
    if (!ptc_open("test",width,height))
    {
        ptc_close();
        return 1;
    }
    while (1)
    {
        for (index=0; index<size; index++)
        {
            noise = seed;
            noise >>= 3;
            noise ^= seed;
            carry = noise & 1;
            noise >>= 1;
            seed >>= 1;
            seed |= (carry << 30);
            noise &= 0xFF;
            pixel[index] = (noise<<16) | (noise<<8) | noise;
        }
        ptc_update(pixel);
    }
    return 0;
}
