{ Tricks used with textmode }

Type
  CharType = Array[0..15] of Byte;
  CharSetType = Array[0..255] of CharType;
  TwoCharSet = Array[0..511] of CharType;

Const
  ColorLookup : Array[0..14] of Byte = (0, 1, 2, 3, 4, 20, 6, 56, 57,
                                        58, 59, 60, 61, 62, 63);
  CharOffsets : Array[0..7] of Word = ($0000, $4000, $8000, $C000,
                                       $2000, $6000, $A000, $E000);

Var
  CharSet : TwoCharSet;
  OldCharSet : CharSetType;
  Buffer : Array[0..160*25] of Byte;

Procedure VSync; Assembler;
{ wait for vertical retrace, including thr entire retrace}

Asm
  Mov  dx,$3da
 @NotVSync:
  In   al,dx
  And  al,8
  Jz  @NotVSync
 @VSync:
  In   al,dx
  And  al,8
  Jnz @VSync
End;

Procedure Copy386(Var Source, Dest; Amnt : Word); Assembler;
{ dword copy }

Asm
  Push  ds
  Lds   si,Source
  Les   di,Dest
  Mov   cx,Amnt
  Shr   cx,2
  db 66h; Rep Movsw
  Pop   ds
End;

Procedure SelectCharMap(Map0, Map1 : Byte);
{ Map0 - attribute bit 3 is clear }
{ Map1 - attribute bit 3 is set   }


Begin
  PortW[$3c4] := $03 + ((Map0 And 3) + ((Map0 And 4) Shl 2) +
                ((Map1 And 3) Shl 2 + (Map1 and 4) Shl 3)) Shl 8;
End;

Procedure SetCharWidth(Width : Byte);
{ Sets the character width. Either 8-bit or 9-bit }
{ in: Width - either 8 or 9. 9 is standsrd VGA    }

Var
  Temp : Word;
  x : Word;

Begin
  If Width = 8
    Then Temp := $0001
    Else Temp := $0800;
  x := Port[$3cc] And $F3;
  If Width = 9
    Then x := x Or 4;
  Port[$3c2] := x;
  Inline($Fa);  { Cli }
  PortW[$3c4] := $0100;
  PortW[$3c4] := $01 + Temp Shl 8;
  PortW[$3c4] := $0300;
  Inline($Fb);  { Sti }
  Asm
    Mov  ax,$1000
    Mov  bx,Temp
    Mov  bl,$13
    Int  $10
  End;
End;

Procedure PutPixel(X, Y : Integer);
{ puts a pixel }

Var
  Clx, Cly : Integer;
  Slx, Sly : Integer;
  Index : Integer;
  Temp : Integer;

Begin
  Slx := X Shr 3;               { Position on text screen  }
  Sly := Y Shr 4;               { Y char                   }
  Clx := 7 - (X And $07);       { Position in character    }
  Cly := Y And $0F;             { Y Position in Character  }
  Temp := (Slx Shl 1)+Sly*160;      { Temporary index variable }
  If Buffer[Temp] = 0
    Then Begin
      CharCount := CharCount + 1;
      Buffer[Temp] := CharCount;
      If CharCount > 255
        Then Buffer[Temp+1] := $0B
        Else Buffer[Temp+1] := $03;
      Index := CharCount;
    End
    Else Index := Buffer[Temp];
  CharSet[Index][Cly] := CharSet[Index][Cly] Or (1 Shl Clx);
End;

Procedure Set400Textmode;
{ sets 400 scanline 80x25 textmode }

Begin
  Asm
    Mov  ax,3                      { Set Regular 80x25 text mode }
    Int  10h
  End;
  Port[$3c2] := (Port[$3cc] And 63) or 64;   { Set 400 line mode }
End;

Procedure SetCharSet(Var CSet1, CSet2; Which1, Which2 : Integer); Assembler;
{ sets the characters sets directly in memory }

Asm
  Mov  dx,$03c4
  Mov  ax,$0402;  Out  dx,ax    { Access bit plane 2                  }
  Mov  ax,$0704;  Out  dx,ax    { Restrict access to bit plane 2 only }
  Mov  dx,$03ce
  Mov  ax,$0204;  Out  dx,ax
  Mov  ax,$0005;  Out  dx,ax
  Mov  ax,$0006;  Out  dx,ax

{ First Char Set }

  Push ds

  Mov  bx,Which1
  Shl  bx,1
  Mov  bx,Word Ptr [CharOffsets+bx]

  Lds  si,CSet1
  Mov  ax,$A000
  Mov  es,ax
  Mov  dx,0

 @Looper1:
  Mov  di,dx
  Shl  di,5
  Add  di,bx
  Mov  cx,4
  db 66h; Rep  Movsw   { Rep Movsd }
  Inc  dx
  Cmp  dx,256
  Jnz  @Looper1

  Pop  ds
  Push ds
  Mov  bx,Which2
  Shl  bx,1
  Mov  bx,Word Ptr [CharOffsets+bx]

{ Second CharSet }
  Lds  si,CSet2
  Mov  dx,0
 @Looper2:
  Mov  di,dx
  Shl  di,5
  Add  di,bx
  Mov  cx,4
  db 66h; Rep  Movsw   { Rep Movsd }
  Inc  dx
  Cmp  dx,256
  Jnz  @Looper2
  Pop  ds

  Mov  dx,$03c4
  Mov  ax,$0302;  Out  dx,ax
  Mov  ax,$0304;  Out  dx,ax
  Mov  dx,$03ce
  Mov  ax,$0004;  Out  dx,ax
  Mov  ax,$1005;  Out  dx,ax
  Mov  ax,$0e06;  Out  dx,ax
End;

Procedure SaveOldCharSet;
{ saves the origional character set to be restored when done }

Var
  X : Integer;

Begin
  InLine($fa);   { CLI }
  PortW[$03c4]:=$0402;
  PortW[$03c4]:=$0704;
  PortW[$03ce]:=$0204;
  PortW[$03ce]:=$0005;
  PortW[$03ce]:=$0006;
  For x := 0 to 255 do
    Move(Mem[$A000:x Shl 5], OldCharSet[x], 16);
  PortW[$03c4]:=$0302;
  PortW[$03c4]:=$0304;
  PortW[$03ce]:=$0004;
  PortW[$03ce]:=$1005;
  PortW[$03ce]:=$0e06;
  InLine($fb);   { STI }
End;


Procedure Line(X1, Y1, X2, Y2 : Integer; Var ScBuffer, CSet);

Var
  XDiff, YDiff : Integer;
  XUnit, YUnit : Integer;
  XLoc, YLoc : Integer;
  Count : Integer;
  Error : Integer;
  Slx, Sly : Integer;
  Clx, Cly : Integer;
  Index    : Integer;
  Temp : Word;

Begin
  YDiff := Y2 - Y1;
  If YDiff < 0
    Then Begin
      YDiff := -YDiff;
      YUnit := -1;
    End
    Else YUnit := 1;
  XDiff := X2 - X1;
  If XDiff < 0
    Then Begin
      XDiff := -XDiff;
      XUnit := -1;
    End
    Else XUnit := 1;
  Error := 0;
  XLoc := X1;
  YLoc := Y1;
  If XDiff > YDiff
    Then Begin
     Asm
       Mov  cx,XDiff
            Inc  cx
           @LineLooper:
            Push cx

            Mov  ax,XLoc
            Mov  bx,ax
            Shr  ax,3
            Mov  dx,ax
            And  bx,7
            Mov  cx,7
            Sub  cx,bx
            Mov  Clx,cx
            Add  dx,dx

            Mov  ax,YLoc
            Mov  bx,ax
            Shr  ax,4
            And  bx,$0f
            Mov  Cly,bx
            Mov  bx,ax
            Shl  bx,7
            Shl  ax,5
            Add  dx,bx
            Add  dx,ax

            Les  di,ScBuffer
            Add  di,dx
            Mov  al,es:[di]
            Cmp  al,0
            Jne @GetOldChar
              Inc  Word Ptr [CharCount]
              Mov  si,CharCount
              Mov  dx,si
              Mov  es:[di],dl
              Mov  dl,03h
              Cmp  si,255
              Jle @Skip0B
              Mov  dl,0bh
             @Skip0b:
              Mov  es:[di+1],dl
              Jmp @StoreChar
           @GetOldChar:
              Xor  dh,dh
              Mov  dl,es:[di]
              Mov  al,es:[di+1]
              Cmp  al,03h
              Jle @SkipHiChar
              Mov  dh,1
             @SkipHiChar:
              Mov  si,dx
           @StoreChar:

            Les  di,CSet
            Shl  si,4
            Add  di,si
            Add  di,Cly
            Mov  cx,Clx
            Mov  al,1
            Shl  al,cl
            Mov  bl,es:[di]
            Or   bl,al
            Mov  es:[di],bl

            Mov  ax,XLoc
            Mov  bx,YLoc
            Mov  cx,Error

            Add  ax,XUnit
            Add  cx,YDiff
            Cmp  cx,XDiff
            Jle @StoreNewLocs
            Sub  cx,XDiff
            Add  bx,YUnit
           @StoreNewLocs:
            Mov  XLoc,ax
            Mov  YLoc,bx
            Mov  Error,cx

            Pop  cx
            Dec  cx
            Jnz @LineLooper
        End;
    End
    Else Begin
          Asm
            Mov  ax,ss
            Mov  es,ax
            Mov  cx,YDiff
            Inc  cx
           @LineLooper:
            Push cx

            Mov  ax,XLoc
            Mov  bx,ax
            Shr  ax,3
            Mov  dx,ax
            And  bx,7
            Mov  cx,7
            Sub  cx,bx
            Mov  Clx,cx
            Add  dx,dx

            Mov  ax,YLoc
            Mov  bx,ax
            Shr  ax,4
            And  bx,$0f
            Mov  Cly,bx
            Mov  bx,ax
            Shl  bx,7
            Shl  ax,5
            Add  dx,bx
            Add  dx,ax

            Les  di,ScBuffer
            Add  di,dx
            Mov  al,es:[di]
            Cmp  al,0
            Jne @GetOldChar
              Inc  Word Ptr [CharCount]
              Mov  si,CharCount
              Mov  dx,si
              Mov  es:[di],dl
              Mov  dl,03h
              Cmp  si,255
              Jle @Skip0B
              Mov  dl,0bh
             @Skip0b:
              Mov  es:[di+1],dl
              Jmp @StoreChar
           @GetOldChar:
              Xor  dh,dh
              Mov  dl,es:[di]
              Mov  al,es:[di+1]
              Cmp  al,03h
              Jle @SkipHiChar
              Mov  dh,1
             @SkipHiChar:
              Mov  si,dx
           @StoreChar:

            Les  di,CSet
            Shl  si,4
            Add  di,si
            Add  di,Cly
            Mov  cx,Clx
            Mov  al,1
            Shl  al,cl
            Mov  bl,es:[di]
            Or   bl,al
            Mov  es:[di],bl

            Mov  ax,XLoc
            Mov  bx,YLoc
            Mov  cx,Error
            Add  bx,YUnit
            Add  cx,XDiff
            Cmp  cx,0
            Jle @JumpStore
            Sub  cx,YDiff
            Add  ax,XUnit
           @JumpStore:
            Mov  XLoc,ax
            Mov  YLoc,bx
            Mov  Error,cx

            Pop  cx
            Dec  cx
            Jnz  @LineLooper
        End;
    End;
End;


Procedure SetRGB(Color, R, G, B : Byte);

Begin
  Port[$3c8] := ColorLookUp[Color];
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

