/****************************************************************************
*                pvfiles.c
*
*  This module contains ASCII file data and related code.
*
*  Copyright  POV-Team 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* $Id: //depot/povray/3.5/windows/pvfiles.c#10 $
*
*****************************************************************************/

#define POVWIN_FILE
#define _WIN32_IE COMMONCTRL_VERSION

#include <math.h>
#include <setjmp.h>
#include <string.h>
#include <windows.h>
#include "frame.h"
#include "colour.h"
#include "povray.h"
#include "optout.h"
#pragma hdrstop

#include <io.h>
#include "pvengine.h"
#include "resource.h"

#include "pvlegal.h"
#include "pvdemo.h"
#include "pvtips.h"

extern int              message_ychar ;
extern char             ourPath [] ;
extern char             HomePath [] ;

void fill_listbox (HWND hwnd)
{
  char        *p = povlegal_text ;
  char        str [1024] = "" ;
  char        *s = str ;

  while (*p)
  {
    if (*p == '\n')
    {
      *s = '\0' ;
      SendMessage (hwnd, LB_ADDSTRING, 0, (LPARAM) str) ;
      s = str ;
      p++ ;
      continue ;
    }
    *s++ = *p++ ;
  }
  *s = '\0' ;
  SendMessage (hwnd, LB_ADDSTRING, 0, (LPARAM) str) ;
}

void save_povlegal (void)
{
  char        filename [_MAX_PATH + 64] ;
  FILE        *outF ;

  sprintf (filename, "%sPOVLEGAL.DOC", HomePath) ;
  if ((outF = fopen (filename, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create POVLEGAL.DOC", "Cannot save document") ;
    return ;
  }
  if (fwrite (povlegal_text, 1, sizeof (povlegal_text), outF) != sizeof (povlegal_text))
  {
    PovMessageBox ("Cannot write to POVLEGAL.DOC", "Cannot save document") ;
    fclose (outF) ;
    return ;
  }
  fclose (outF) ;
  sprintf (filename, "The POV-Ray license was written to the file %sPOVLEGAL.DOC\n\n"
                     "This file is in plain text format and may be viewed and printed "
                     "using notepad or any other text editor. Microsoft Word is not "
                     "required.", HomePath) ;
  PovMessageBox (filename, "POVLEGAL.DOC saved") ;
}

INT_PTR CALLBACK PovLegalDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  DRAWITEMSTRUCT        *d ;
  MEASUREITEMSTRUCT     *m ;
  static HBRUSH         hbr ;

  switch (message)
  {
    case WM_INITDIALOG :
         resize_listbox_dialog (hDlg, IDC_LISTBOX, 79) ;
         CenterWindowRelative ((HWND) lParam, hDlg, true) ;
         SetWindowText (hDlg, "POV-Ray Legal Statement [POVLEGAL.DOC]") ;
//       hbr = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
         fill_listbox (GetDlgItem (hDlg, IDC_LISTBOX)) ;
         return (true) ;

    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
    case WM_CTLCOLOREDIT:
    case WM_CTLCOLORLISTBOX:
    case WM_CTLCOLORSCROLLBAR:
    case WM_CTLCOLORSTATIC:
         return (DefWindowProc (hDlg, message, wParam, lParam)) ;

    case WM_COMMAND :
         switch (LOWORD (wParam))
         {
           case IDOK :
//              DeleteObject (hbr) ;
                EndDialog (hDlg, true) ;
                return (true) ;

           default :
                return (true) ;
         }

    case WM_MEASUREITEM :
         if (wParam == IDC_LISTBOX)
         {
           m = (MEASUREITEMSTRUCT *) lParam ;
           m->itemHeight = message_ychar ;
           return (true) ;
         }
         else
           return (false) ;

    case WM_DRAWITEM :
         if (wParam == IDC_LISTBOX)
         {
           d = (DRAWITEMSTRUCT *) lParam ;
           d->itemState &= ~ODS_SELECTED ;
           draw_ordinary_listbox (d, false) ;
           return (true) ;
         }
         else
           return (false) ;
  }
  return (false) ;
}

char *save_demo_file (char *s1, char *s2)
{
  char        **p = povdemo_scene ;
  FILE        *outF ;

  GetTempPath (_MAX_PATH - 16, s1) ;
  if (s1 [strlen (s1) - 1] != '\\')
    strcat (s1, "\\") ;
  strcpy (s2, s1) ;
  strcat (s1, "POVDEMO.$$1") ;
  strcat (s2, "POVDEMO.$$2") ;
  if ((outF = fopen (s1, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create temporary file", "Cannot run demo") ;
    return (NULL) ;
  }
  while (*p)
  {
    if (fprintf (outF, "%s\n", *p++) == EOF)
    {
      PovMessageBox ("Cannot write to temporary file", "Cannot run demo") ;
      fclose (outF) ;
      unlink (s1) ;
      return (NULL) ;
    }
  }
  fclose (outF) ;
  p = povdemo_ini ;
  if ((outF = fopen (s2, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create temporary file", "Cannot run demo") ;
    unlink (s1) ;
    return (NULL) ;
  }
  while (*p)
  {
    if (fprintf (outF, "%s\n", *p++) == EOF)
    {
      PovMessageBox ("Cannot write to temporary file", "Cannot run demo") ;
      fclose (outF) ;
      unlink (s1) ;
      unlink (s2) ;
      return (NULL) ;
    }
  }
  fclose (outF) ;
  return (s1) ;
}


