/****************************************************************************
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-2002 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms
*  other than those supported by the POV-Ray Team. There are strict rules
*  under which you are permitted to use this file. The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the (at the time commercial) CodeMax edit control which the POVWIN
* 3.1 editor is based upon.
*
* $File: //depot/povray/3.5/windows/codemax/PrintOptions.h $
* $Revision: #4 $
* $Change: 1816 $
* $DateTime: 2002/07/27 10:29:18 $
* $Author: chrisc $
* $Log$
*
*****************************************************************************/

#ifndef PrintOptionsH
#define PrintOptionsH
//----------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <Messages.hpp>
#include <Classes.hpp>
#include <Graphics.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include "cspin.h"
#include <Mask.hpp>
//----------------------------------------------------------------------------
class TPrintForm : public TForm
{
  __published:
    TFontDialog *FontDialog;
    TBitBtn *PrintButton;
    TBitBtn *CancelButton;
    TGroupBox *GroupBox1;
    TLabel *FontSampleLabel;
    TBitBtn *ChooseButton;
    TGroupBox *GroupBox2;
    TBitBtn *SetupButton;
    TCheckBox *LineNumbers;
    TCheckBox *Header;
    TCheckBox *WrapLines;
    TLabel *SourceFileLabel;
    TCheckBox *PrintMarkedBlock;
    TGroupBox *GroupBox3;
    TCSpinEdit *LeftMargin;
    TLabel *Label1;
    TLabel *Label2;
    TCSpinEdit *TopMargin;
    TLabel *Label3;
    TCSpinEdit *RightMargin;
    TLabel *Label4;
    TCSpinEdit *BottomMargin;
    TCheckBox *PageBreaks;
    TPrinterSetupDialog *SetupDialog;
    TPanel *MessagePanel;
    TLabel *InfoLabel;
    TLabel *Label5;
    TCheckBox *HighlightComments;
    TCheckBox *TwoUpPrinting;
    void __fastcall ChooseButtonClick(TObject *Sender);

    void __fastcall FormShow(TObject *Sender);

    void __fastcall SetupButtonClick(TObject *Sender);

    void __fastcall CancelButtonClick(TObject *Sender);
    void __fastcall PrintButtonClick(TObject *Sender);
    void __fastcall FormKeyPress(TObject *Sender, char &Key);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall FormHide(TObject *Sender);
    void __fastcall TwoUpPrintingClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
  private:
    bool FPrinting ;
    bool FCancel ;

  public:
    TCodeMax *e ;
    bool PrintCancel ;
	virtual __fastcall TPrintForm(TComponent *Owner);
    void PrintFile (void) ;

  __published:
    __property bool Printing = {read = FPrinting} ;
    __property bool Cancel = {read = FCancel, write = FCancel} ;
};
//----------------------------------------------------------------------------
extern PACKAGE TPrintForm *PrintForm;
//----------------------------------------------------------------------------
#endif
