/****************************************************************************
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-2002 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms
*  other than those supported by the POV-Ray Team. There are strict rules
*  under which you are permitted to use this file. The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the (at the time commercial) CodeMax edit control which the POVWIN
* 3.1 editor is based upon.
*
* $File: //depot/povray/3.5/windows/codemax/InsertChangeThread.cpp $
* $Revision: #7 $
* $Change: 1816 $
* $DateTime: 2002/07/27 10:29:18 $
* $Author: chrisc $
* $Log$
*
*****************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "EditForm.h"
#include "InsertChangeThread.h"
#pragma package(smart_init)

extern TParentForm      *ParentForm ;

void BuildDirList (TMenuItem *Menu, AnsiString Path) ;

__fastcall InsertChangeThread::InsertChangeThread (AnsiString Directory) : TThread (false)
{
  MonitorDir = Directory ;
}

//---------------------------------------------------------------------------
void DeleteInsertItems (TMenuItem *Menu)
{
  TMenuItem             *m ;

  for (int i = Menu->Count - 1 ; i >= 0 ; i--)
  {
    m = Menu->Items [i] ;
    Menu->Remove (m) ;
    if (m->Tag != 0)
      delete (AnsiString *) m->Tag ;
    DeleteInsertItems (m) ;
    delete m ;
  }
}

//---------------------------------------------------------------------------
void __fastcall InsertChangeThread::RebuildDirList (void)
{
  TMenuItem             *m ;

  for (int i = ParentForm->miInsertMenu->Count - 1 ; i > 2 ; i--)
  {
    m = ParentForm->miInsertMenu->Items [i] ;
    ParentForm->miInsertMenu->Remove (m) ;
    if (m->Tag != 0)
      delete (AnsiString *) m->Tag ;
    DeleteInsertItems (m) ;
    delete m ;
  }
  BuildDirList (ParentForm->miInsertMenu, MonitorDir) ;
}

//---------------------------------------------------------------------------
void __fastcall InsertChangeThread::Execute (void)
{
  bool                  finished = false ;
  HANDLE                handle ;

  // The Windows API documentation -claims- that if this function fails it
  // will return INVALID_HANDLE_VALUE. In actual fact, on rare instances,
  // it will return NULL, thus causing all sorts of problems later in this
  // code (because we didn't test for it - as per the documentation and even
  // Microsoft's own sample code).
  
  // We handle this situation now by re-acquiring it below rather than exiting.
  handle = FindFirstChangeNotification (MonitorDir.c_str (),
                                        true,
                                        FILE_NOTIFY_CHANGE_FILE_NAME |
                                        FILE_NOTIFY_CHANGE_DIR_NAME) ;
  while (!finished)
  {
    if (handle == INVALID_HANDLE_VALUE || handle == NULL)
    {
      Sleep (5000) ;
      handle = FindFirstChangeNotification (MonitorDir.c_str (),
                                            true,
                                            FILE_NOTIFY_CHANGE_FILE_NAME |
                                            FILE_NOTIFY_CHANGE_DIR_NAME) ;
      if (handle == INVALID_HANDLE_VALUE || handle == NULL)
        Sleep (60000) ;
    }
    if (WaitForSingleObject (handle, INFINITE) != WAIT_OBJECT_0 || FindNextChangeNotification (handle) == 0)
    {
      FindCloseChangeNotification (handle) ;
      handle = INVALID_HANDLE_VALUE ;
      Sleep (10000) ;
      continue ;
    }
    Synchronize ((TThreadMethod) &RebuildDirList) ;
    Sleep (1000) ;
  }
  FindCloseChangeNotification (handle) ;
}

//---------------------------------------------------------------------------


