/****************************************************************************
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-2002 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms
*  other than those supported by the POV-Ray Team. There are strict rules
*  under which you are permitted to use this file. The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the (at the time commercial) CodeMax edit control which the POVWIN
* 3.1 editor is based upon.
*
* $File: //depot/povray/3.5/windows/codemax/component/TCodeMax.h $
* $Revision: #6 $
* $Change: 1816 $
* $DateTime: 2002/07/27 10:29:18 $
* $Author: chrisc $
* $Log$
*
*****************************************************************************/

#ifndef TCodeMaxH
#define TCodeMaxH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
#include "codemax.h"
//---------------------------------------------------------------------------

enum TLanguage {cmlNone, cmlCCpp, cmlBasic, cmlJava, cmlPascal, cmlSQL, cmlPOVRay, cmlHTML, cmlSGML} ;
enum TAutoIndent {cmiNone=CM_INDENT_OFF, cmiScope=CM_INDENT_SCOPE, cmiPrevLine=CM_INDENT_PREVLINE} ;

class PACKAGE TCodeMax : public TWinControl
{
  private:
    int                FIndex ;
    int                FRMBDownX ;
    int                FRMBDownY ;
    int                FRMBDownLine ;
    int                FRMBDownCol ;
    bool               FOpened ;
    bool               FBackedUp ;
    bool               FLButtonDown ;
    AnsiString         FFileName ;
    AnsiString         FShortName ;
    AnsiString         FLanguage ;

    void __fastcall CreateParams (TCreateParams &Params) ;

  protected:
    void __fastcall SetFileName (const AnsiString Filename) ;
    void __fastcall SetOpened (bool Opened) ;
    void __fastcall SetLanguageName (const AnsiString Language) { CM_SetLanguage (Handle, Language.c_str ()) ; }
    AnsiString __fastcall GetLanguageName (void) ;
    void __fastcall SetLanguage (TLanguage Language) ;
    TLanguage __fastcall GetLanguage (void) ;
    void __fastcall SetAutoIndent (TAutoIndent AutoIndent) { CM_SetAutoIndentMode (Handle, int (AutoIndent)) ; }
    TAutoIndent __fastcall GetAutoIndent (void) { return (TAutoIndent (CM_GetAutoIndentMode (Handle))) ; }
    bool __fastcall GetColourSyntax (void) { return CM_IsColorSyntaxEnabled (Handle) ; }
    void __fastcall SetColourSyntax (bool enabled) { CM_EnableColorSyntax (Handle, enabled) ; }
    void __fastcall SetIntegerValue (int value, int message) ;
    int __fastcall GetIntegerValue (int message) ;
    void __fastcall SetBooleanValue (int message, bool value) ;
    bool __fastcall GetBooleanValue (int message) ;
    int __fastcall GetLineLength (int line) { return (CM_GetLineLength (Handle, line - 1, false)) ; }
    TScrollStyle __fastcall GetScrollBars (void) ;
    void __fastcall SetScrollBars (TScrollStyle style) ;
    int __fastcall GetHSplitterPos (void) { return (CM_GetSplitterPos (Handle, true)) ; }
    int __fastcall GetVSplitterPos (void) { return (CM_GetSplitterPos (Handle, false)) ; }
    void __fastcall SetHSplitterPos (int pos) { CM_SetSplitterPos (Handle, true, pos) ; }
    void __fastcall SetVSplitterPos (int pos) { CM_SetSplitterPos (Handle, false, pos) ; }
    bool __fastcall GetHSplitterEnable (void) { return (CM_IsSplitterEnabled (Handle, 1)) ; }
    void __fastcall SetHSplitterEnable (bool enable) { CM_EnableSplitter (Handle, 1, enable) ; }
    bool __fastcall GetVSplitterEnable (void) { return (CM_IsSplitterEnabled (Handle, 0)) ; }
    void __fastcall SetVSplitterEnable (bool enable) { CM_EnableSplitter (Handle, 0, enable) ; }
    int __fastcall GetLineNo (void) ;
    void __fastcall SetLineNo (int LineNo) ;
    int __fastcall GetColNo (void) ;
    void __fastcall SetColNo (int ColNo) ;
    void __fastcall SetPosition (int LineNo, int ColNo) ;
    int __fastcall GetTopLine (void) { return (CM_GetTopIndex (Handle, 0) + 1) ; }
    void __fastcall SetTopLine (int TopLine) { CM_SetTopIndex (Handle, 0, TopLine - 1) ; }
    virtual void __fastcall WndProc(Messages::TMessage &Message);

  public:
    __fastcall TCodeMax (TComponent* Owner) ;
    AnsiString __fastcall GetLine (int nLine) ;
    CME_CODE GetLine (int nLine, LPTSTR pszBuff) { return (CM_GetLine (Handle, nLine - 1, pszBuff)) ; }
    CME_CODE InsertText (AnsiString Text, const CM_POSITION *pPos = NULL) { return (CM_InsertText (Handle, Text.c_str (), pPos)) ; }
    CME_CODE InsertText (LPCTSTR pszText, const CM_POSITION *pPos = NULL) { return (CM_InsertText (Handle, pszText, pPos)) ; }
    CME_CODE InsertText (AnsiString& Text, const CM_POSITION *pPos = NULL) { return (CM_InsertText (Handle, Text.c_str (), pPos)) ; }
    CME_CODE Copy (void) { return (CM_Copy (Handle)) ; }
    CME_CODE Cut (void) { return (CM_Cut (Handle)) ; }
    CME_CODE Paste (void) { return (CM_Paste (Handle)) ; }
    CME_CODE ClearUndoBuffer (void) { return (CM_ClearUndoBuffer (Handle)) ; }
    CME_CODE InsertFile (AnsiString FileName, const CM_POSITION *pPos = NULL) { return (CM_InsertFile (Handle, FileName.c_str (), pPos )) ; }
    CME_CODE SetColors (const CM_COLORS *pColors) { return (CM_SetColors (Handle, pColors)) ; }
    CME_CODE GetColors (CM_COLORS *pColors) { return (CM_GetColors (Handle, pColors)) ; }
    CME_CODE SetFontStyles (const CM_FONTSTYLES *pFontStyles) { return (CM_SetFontStyles (Handle, pFontStyles)) ; }
    CME_CODE GetFontStyles (CM_FONTSTYLES *pFontStyles) { return (CM_GetFontStyles (Handle, pFontStyles)) ; }
    CME_CODE ReplaceText (LPCTSTR pszText, const CM_RANGE *pRange = NULL) { return (CM_ReplaceText (Handle, pszText, pRange)) ; }
    CME_CODE ReplaceText (AnsiString& Text, const CM_RANGE *pRange = NULL) { return (CM_ReplaceText (Handle, Text.c_str (), pRange)) ; }
    CME_CODE SetText (LPCTSTR pszText) { return (CM_SetText (Handle, pszText)) ; }
    CME_CODE SetText (AnsiString& Text) { return (CM_SetText (Handle, Text.c_str ())) ; }
    CME_CODE GetText (LPTSTR pszBuff, const CM_RANGE *pRange = NULL) { return (CM_GetText (Handle, pszBuff, pRange)) ; }
    bool GetText (AnsiString& Text, const CM_RANGE *pRange = NULL) ;
    int GetTextLength (const CM_RANGE *pRange = NULL) { return (CM_GetTextLength (Handle, pRange, false)) ; }
    CME_CODE SaveFile (LPCTSTR pszFileName, BOOL bClearUndo = TRUE) { return (CM_SaveFile (Handle, pszFileName, bClearUndo)) ; }
    CME_CODE SaveFile (AnsiString& File, BOOL bClearUndo = TRUE) { return (CM_SaveFile (Handle, File.c_str (), bClearUndo)) ; }
    CME_CODE OpenFile (char *File) { return (CM_OpenFile (Handle, File)) ; }
    CME_CODE OpenFile (AnsiString& File) { return (CM_OpenFile (Handle, File.c_str ())) ; }
    CME_CODE GetWord (LPTSTR pszBuff, CM_POSITION *pPos) { return (CM_GetWord (Handle, pszBuff, pPos)) ; }
    int GetWordLength (CM_POSITION *pPos) { return (CM_GetWordLength (Handle, pPos, false)) ; }
    AnsiString GetWord (CM_POSITION *pPos = NULL) ;
    AnsiString __fastcall GetCurrentWord (void) { return (GetWord (NULL)) ; }
    CME_CODE AddText (LPCTSTR pszText) { return (CM_AddText (Handle, pszText )) ; }
    CME_CODE AddText (AnsiString& Text) { return (CM_AddText (Handle, Text.c_str ())) ; }
    CME_CODE DeleteLine (int nLine) { return (CM_DeleteLine (Handle, nLine - 1)) ; }
    CME_CODE InsertLine (int nLine, LPCTSTR pszText) { return (CM_InsertLine (Handle, nLine - 1, pszText)) ; }
    CME_CODE InsertLine (int nLine, AnsiString& Text) { return (CM_InsertLine (Handle, nLine - 1, Text.c_str ())) ; }
    CME_CODE GetSel (CM_RANGE *pRange, BOOL bNormalized = TRUE) { return (CM_GetSel (Handle, pRange, bNormalized)) ; }
    CME_CODE SetSel (const CM_RANGE *pRange, BOOL bMakeVisible = TRUE) { return (CM_SetSel (Handle, pRange, bMakeVisible)) ; }
    CME_CODE DeleteSel (void) { return (CM_DeleteSel (Handle)) ; }
    CME_CODE ReplaceSel (LPCTSTR pszText) { return (CM_ReplaceSel (Handle, pszText)) ; }
    CME_CODE ExecuteCmd (WORD wCmd, DWORD dwCmdData = 0) { return (CM_ExecuteCmd (Handle, wCmd, dwCmdData )) ; }
    CME_CODE SetSplitterPos (BOOL bHorz, int nPos) { return (CM_SetSplitterPos (Handle, bHorz, nPos)) ; }
    int GetSplitterPos (BOOL bHorz) { return (CM_GetSplitterPos (Handle, bHorz)) ; }
    CME_CODE SetTopIndex (int nView, int nLine) { return (CM_SetTopIndex (Handle, nView, nLine - 1)) ; }
    int GetTopIndex (int nView) { return (CM_GetTopIndex (Handle, nView)) ; }
    int GetVisibleLineCount (int nView, BOOL bFullyVisible = TRUE) { return (CM_GetVisibleLineCount (Handle, nView, bFullyVisible)) ; }
    CME_CODE SetFontOwnership (BOOL bEnable) { return (CM_SetFontOwnership (Handle, bEnable)) ; }
    bool GetFontOwnership (void) { return (CM_GetFontOwnership (Handle)) ; }
    int GetCurrentView (void) { return (CM_GetCurrentView (Handle)) ; }
    int GetViewCount (void) { return (CM_GetViewCount (Handle)) ; }
    CME_CODE GetSelFromPoint (int xClient, int yClient, CM_POSITION *pPos) { return (CM_GetSelFromPoint (Handle, xClient, yClient, pPos)) ; }
    CME_CODE SelectLine (int nLine, BOOL bMakeVisible = TRUE) { return (CM_SelectLine (Handle, nLine - 1, bMakeVisible)) ; }
    int __fastcall GetErrorLine (void) { return (CM_GetHighlightedLine (Handle) + 1) ; }
    void __fastcall SetErrorLine (int LineNo) { CM_SetHighlightedLine (Handle, --LineNo) ; }
    void __fastcall ClearErrorLine (void) { CM_ClearHighlightedLines (Handle) ; }

    int HitTest (int xClient, int yClient) { return (CM_HitTest (Handle, xClient, yClient)) ; }
    static CME_CODE SetHotKeys (char *HotKeys) ;
    static CME_CODE SetMacro (int Index, char *Macro) ;
    static void SetFindReplaceMRUList (AnsiString List, bool IsFind) ;
    static int GetHotKeys (char *HotKeys) ;
    static int GetMacro (int Index, char *Macro) ;
    static void GetFindReplaceMRUList (AnsiString& List, bool IsFind) ;
    static CME_CODE RegisterLanguage (char *LangName, CM_LANGUAGE *LangDef) { return (CMRegisterLanguage (LangName, LangDef)) ; }
    static AnsiString GetHotKeyString (CM_HOTKEY &cmHotKey) ;
    static int GetHotKeysForCmd (WORD Command, CM_HOTKEY *HotKeys) { return (CMGetHotKeysForCmd (Command, HotKeys)) ; }
    static CME_CODE RegisterHotKey (CM_HOTKEY *HotKey, WORD Command) { return (CMRegisterHotKey (HotKey, Command)) ; }
    CME_CODE SetDlgParent (TWinControl *Control) { return (CM_SetDlgParent (Handle, Control->Handle)) ; }
    HFONT GetFont (void) { return ((HFONT) SendMessage (Handle, WM_GETFONT, 0, 0)) ; }
    void SetFont (HFONT font) { SendMessage (Handle, WM_SETFONT, (WPARAM) font, MAKELPARAM (true, 0)) ; }
    void ShowProperties (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_PROPERTIES, 0) ; }
    void Undo (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_UNDO, 0) ; }
    void Redo (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_REDO, 0) ; }
    void Find (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_FIND, 0) ; }
    void FindNext (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_FINDNEXT, 0) ; }
    void Replace (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_FINDREPLACE, 0) ; }
    void ReplaceNext (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_REPLACE, 0) ; }
    void Record (void) { SendMessage (Handle, CMM_EXECUTECMD, CMD_RECORDMACRO, 0) ; }
    void GoToLine (int Line) { SendMessage (Handle, CMM_EXECUTECMD, CMD_GOTOLINE, Line - 1)  ; }
    void GetPosition (CM_POSITION *Position) ;
    void SetPosition (const CM_POSITION *Position) ;
    void GetLineNumbering (CM_LINENUMBERING *LineNumbering) { CM_GetLineNumbering (Handle, LineNumbering) ; }
    void SetLineNumbering (const CM_LINENUMBERING *LineNumbering) { CM_SetLineNumbering (Handle, LineNumbering) ; }
    void SetCaretPos (int Col, int Line) { CM_SetCaretPos (Handle, Line - 1, Col - 1) ; }
    DWORD ExecuteCommand (WORD Command, int Param) { return (SendMessage (Handle, CMM_EXECUTECMD, Command, Param)) ; }
    static CME_CODE RegisterCommand (WORD wCmd, LPCTSTR pszName, LPCTSTR pszDesc) { return (CMRegisterCommand (wCmd, pszName, pszDesc)) ; }
    static CME_CODE RegisterCommand (WORD wCmd, AnsiString& Name, AnsiString& Desc) { return (CMRegisterCommand (wCmd, Name.c_str (), Desc.c_str ())) ; }
    static CME_CODE UnregisterCommand (WORD wCmd) { return (CMUnregisterCommand (wCmd)) ; }

  __published:
    __property Align ;
    __property Enabled ;
    __property Cursor ;
    __property ParentShowHint ;
    __property PopupMenu ;
    __property ShowHint ;
    __property TabOrder ;
    __property TabStop ;
    __property Visible ;
    __property OnClick ;
    __property OnDblClick ;
    __property OnEnter ;
    __property OnExit ;
    __property OnKeyDown ;
    __property OnKeyPress ;
    __property OnKeyUp ;
    __property OnMouseDown ;
    __property OnMouseMove ;
    __property OnMouseUp ;

    __property int RMBDownX = {read = FRMBDownX} ;
    __property int RMBDownY = {read = FRMBDownY} ;
    __property int RMBDownLine = {read = FRMBDownLine} ;
    __property int RMBDownCol = {read = FRMBDownCol} ;
    __property int Line = {read = GetLineNo, write = SetLineNo} ;
    __property int Col = {read = GetColNo, write = SetColNo} ;
    __property int TopLine = {read = GetTopLine, write = SetTopLine} ;
    __property AnsiString CurrentWord = {read = GetCurrentWord} ;
    __property int Index = {read = FIndex, write = FIndex} ;
    __property bool BackedUp = {read = FBackedUp, write = FBackedUp} ;
    __property bool Opened = {read = FOpened, write = SetOpened} ;
    __property bool LButtonDown = {read = FLButtonDown} ;
    __property AnsiString ShortName = {read = FShortName, write = FShortName} ;
    __property AnsiString FileName = {read = FFileName, write = SetFileName} ;
    __property AnsiString LanguageName = {read = GetLanguageName, write = SetLanguageName} ;
    __property TLanguage Language = {read = GetLanguage, write = SetLanguage} ;
    __property TAutoIndent AutoIndent = {read = GetAutoIndent, write = SetAutoIndent} ;
    __property bool SyntaxHighlighting = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLECOLORSYNTAX} ;
    __property bool WhiteSpaceDisplay = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEWHITESPACEDISPLAY} ;
    __property bool TabExpand = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLETABEXPAND} ;
    __property bool SmoothScrolling = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLESMOOTHSCROLLING} ;
    __property bool ReadOnly = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_SETREADONLY} ;
    __property bool LineToolTips = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLELINETOOLTIPS} ;
    __property bool LeftMarginVisible = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLELEFTMARGIN} ;
    __property bool Modified = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_SETMODIFIED} ;
    __property bool OvertypeMode = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEOVERTYPE} ;
    __property bool CaseSensitive = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLECASESENSITIVE} ;
    __property bool PreserveCase = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEPRESERVECASE} ;
    __property bool WholeWordEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEWHOLEWORD} ;
    __property bool DragDropEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEDRAGDROP} ;
    __property bool HSplitterEnabled = {read = GetHSplitterEnable, write = SetHSplitterEnable} ;
    __property bool VSplitterEnabled = {read = GetVSplitterEnable, write = SetVSplitterEnable} ;
    __property bool ColumnSelEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLECOLUMNSEL} ;
    __property bool GlobalPropsEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEGLOBALPROPS} ;
    __property bool CRLF = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLECRLF} ;
    __property bool RegexpEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEREGEXP} ;
    __property bool OvertypeCaret = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLEOVERTYPECARET} ;
    __property bool SelBoundsEnabled = {read = GetBooleanValue, write = SetBooleanValue, index=CMM_ENABLESELBOUNDS} ;

    __property bool CanCopy = {read = GetBooleanValue, index=CMM_CANCOPY} ;
    __property bool CanCut = {read = GetBooleanValue, index=CMM_CANCUT} ;
    __property bool CanPaste = {read = GetBooleanValue, index=CMM_CANPASTE} ;
    __property bool CanUndo = {read = GetBooleanValue, index=CMM_CANUNDO} ;
    __property bool CanRedo = {read = GetBooleanValue, index=CMM_CANREDO} ;
    __property bool RecordingMacro = {read = GetBooleanValue, index=CMM_ISRECORDINGMACRO} ;

    __property TScrollStyle ScrollBars = {read = GetScrollBars, write = SetScrollBars, default=ssVertical} ;

    __property int TabSize = {read = GetIntegerValue, write = SetIntegerValue, index=CMM_SETTABSIZE} ;
    __property int UndoLimit = {read = GetIntegerValue, write = SetIntegerValue, index=CMM_SETUNDOLIMIT} ;
    __property int ErrorLine = {read = GetErrorLine, write = SetErrorLine} ;

    __property int LineCount = {read = GetIntegerValue, index=CMM_GETLINECOUNT} ;
    __property AnsiString Lines [int number] = {read = GetLine} ;
    __property int LineLength [int line] = {read = GetLineLength} ;

    __property int HSplitterPos = {read = GetHSplitterPos, write = SetHSplitterPos} ;
    __property int VSplitterPos = {read = GetVSplitterPos, write = SetVSplitterPos} ;

} ;
//---------------------------------------------------------------------------
#endif

