// Options.h: interface for the cOptions class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPTIONS_H__DCE102C6_F297_4B23_9505_600442BB6947__INCLUDED_)
#define AFX_OPTIONS_H__DCE102C6_F297_4B23_9505_600442BB6947__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


typedef LONG   tOpVar;


const tOpVar OP_ON                      = 1;
const tOpVar OP_OFF                     = 0;
const tOpVar OP_YES                     = 1;
const tOpVar OP_NO                      = 0;
const tOpVar OP_ASK                     = -1;
const tOpVar OP_AUTO                    = -2;


const tOpVar OP_ANSI_WIDTH_SCREEN       = -3;
const tOpVar OP_ANSI_WIDTH_CANVAS       = -4;

#define CHARSET_MAX_CHARS			12
#define CHARSET_MAX					20

typedef UCHAR			tCharSet[CHARSET_MAX_CHARS];
typedef tCharSet		tCharSetArray[CHARSET_MAX];

class cOptions  
{
public:
	cOptions();
	virtual ~cOptions();

	void LoadDefaults();
	void SaveDefaults();

    inline CSize GetDefaultSize() { return m_DefaultSize; }

	inline LPCTSTR GetDefaultAlias() { return m_strDefaultAlias; }
    inline tOpVar GetDefaultBinaryWidth() const { return m_default_binary_width; }
    inline BOOL SetDefaultBinaryWidth(tOpVar p_DefBinWidth) { m_default_binary_width = p_DefBinWidth; return TRUE; }

	inline UCHAR		GetCharSetChar(int p_iCharSet, int p_iChar)
	{
		ASSERT(p_iChar < CHARSET_MAX_CHARS && p_iCharSet < CHARSET_MAX);
		return m_charsets[p_iCharSet][p_iChar]; 
	}
	
	inline void			SetCharSetChar(int p_iCharSet, int p_iChar, char p_cChar)		
	{
		ASSERT(p_iChar < CHARSET_MAX_CHARS && p_iCharSet < CHARSET_MAX);  
		m_charsets[p_iCharSet][p_iChar] = p_cChar; 
	}
    
	inline void			SetBackground8(BOOL p_bUseBackground8) { m_bUseBackground8 = p_bUseBackground8; }
	inline BOOL			GetBackground8() { return m_bUseBackground8; }
	inline BOOL			GetCursorFromZero() { return m_bCursorFromZero; }
	
	inline void			SetInsertMode(BOOL p_bInsertMode) { m_bInsertMode = p_bInsertMode; }
	inline BOOL			GetInsertMode() { return m_bInsertMode; }
	inline void			SetDefaultAlias(LPCTSTR p_tszDefaultAlias) { m_strDefaultAlias = p_tszDefaultAlias; }

protected:
    CSize				m_DefaultSize;
    CSize				m_CharSize;
    CSize				m_ViewCharSize;
    CSize				m_EditCharSize;
	CString				m_strDefaultAlias;
	BOOL				m_bUseBackground8;
	BOOL				m_bCursorFromZero;
	BOOL				m_bInsertMode;

	tCharSetArray		m_charsets;

    tOpVar  			m_ansi_width;
    tOpVar  			m_default_binary_width;
};

#endif // !defined(AFX_OPTIONS_H__DCE102C6_F297_4B23_9505_600442BB6947__INCLUDED_)
