// Options.cpp: implementation of the cOptions class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "cOptions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cOptions::cOptions()
{
    m_DefaultSize = CSize(80,5000);
    m_CharSize = CSize(8,16);
    m_ViewCharSize = CSize(2,4);
    m_EditCharSize = CSize(8,16);
    m_ansi_width = 80;
    m_default_binary_width = OP_ASK;
	m_bCursorFromZero = FALSE;
	m_bUseBackground8 = TRUE;
	m_bInsertMode = FALSE;
	tCharSetArray cs = {
		{0xda,0xbf,0xc0,0xd9,0xc4,0xb3,0xc3,0xb4,0xc1,0xc2,0x20,0x20},
		{0xc9,0xbb,0xc8,0xbc,0xcd,0xba,0xcc,0xb9,0xca,0xcb,0x20,0x20},
		{0xd5,0xb8,0xd4,0xbe,0xcd,0xb3,0xc6,0xb5,0xcf,0xd1,0x20,0x20},
		{0xd6,0xb7,0xd3,0xbd,0xc4,0xba,0xc7,0xb6,0xd0,0xd2,0x20,0x20},
		{0xc5,0xce,0xd8,0xd7,0xe8,0xe8,0x9b,0x9c,0x99,0xef,0x20,0x20},
		{0xb0,0xb1,0xb2,0xdb,0xdf,0xdc,0xdd,0xde,0xfe,0xfa,0x20,0x20},	   
		{0x01,0x02,0x03,0x04,0x05,0x06,0xf0,0x0e,0x0f,0x20,0x20,0x20},
		{0x18,0x19,0x1e,0x1f,0x10,0x11,0x12,0x1d,0x14,0x15,0x20,0x20},
		{0xae,0xaf,0xf2,0xf3,0xa9,0xaa,0xfd,0xf6,0xab,0xac,0x20,0x20},
		{0xe3,0xf1,0xf4,0xf5,0xea,0x9d,0xe4,0xf8,0xfb,0xfc,0x20,0x20},
		{0xe0,0xe1,0xe2,0xe5,0xe6,0xe7,0xeb,0xec,0xed,0xee,0x20,0x20},
		{0x80,0x87,0xa5,0xa4,0x98,0x9f,0xf7,0xf9,0xad,0xa8,0x20,0x20},
		{0x83,0x84,0x85,0xa0,0xa6,0x86,0x8e,0x8f,0x91,0x92,0x20,0x20},
		{0x88,0x89,0x8a,0x82,0x90,0x8c,0x8b,0x8d,0xa1,0x9e,0x20,0x20},
		{0x93,0x94,0x95,0xa2,0xa7,0x96,0x81,0x97,0xa3,0x9a,0x20,0x20},
		{0x2f,0x5c,0x28,0x29,0x7b,0x7d,0x5b,0x5d,0x60,0x27,0x20,0x20},
		{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},
		{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},
		{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},
		{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},
	};
	for (int i=0; i<CHARSET_MAX; i++)
	{
		memcpy(m_charsets[i], cs[i], sizeof(tCharSet));
	}
	//memcpy(m_charsets, cs, sizeof(tCharSetArray));
}

cOptions::~cOptions()
{
}

void cOptions::LoadDefaults()
{
	m_strDefaultAlias = AfxGetApp()->GetProfileString(_T("defaults"), _T("Alias"), _T("no name"));
	m_bUseBackground8 = AfxGetApp()->GetProfileInt(_T("defaults"), _T("UseBackground8"), 1);
}

void cOptions::SaveDefaults()
{
	AfxGetApp()->WriteProfileString(_T("defaults"), _T("Alias"), m_strDefaultAlias);
	AfxGetApp()->WriteProfileInt(_T("defaults"), _T("UseBackground8"), (int)m_bUseBackground8);
}
