// cArchive.cpp: implementation of the cArchive class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "cArchive.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#ifndef USE_MFC_ARCHIVE
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cArchive::cArchive(CSocketFile* p_pFile, TLONG p_lSize, LONG p_lBufSize)
{

    m_pFile = p_pFile;

    m_lBufStart = 0;
    m_lBufPos = 0;
    m_lCurBufSize = 0;
    m_lBufSize = p_lBufSize;
    ASSERT(m_lBufSize>0);

	m_bIsSocket = TRUE;
	m_lStart = (m_bIsSocket) ? 0 : m_pFile->GetPosition();
    m_lEnd = (p_lSize == 0 && !m_bIsSocket) ? m_pFile->GetLength() - m_lStart : p_lSize;
    m_mode = M_NONE;
    m_pBuf = new UCHAR[m_lBufSize];
    m_bEOF = FALSE;
}

cArchive::cArchive(CFile* p_pFile, TLONG p_lSize, LONG p_lBufSize)
{

    m_pFile = p_pFile;

    m_lBufStart = 0;
    m_lBufPos = 0;
    m_lCurBufSize = 0;
    m_lBufSize = p_lBufSize;
    ASSERT(m_lBufSize>0);

	m_bIsSocket = FALSE;
    m_lStart = (m_bIsSocket) ? 0 : m_pFile->GetPosition();
    m_lEnd = (p_lSize == 0 && !m_bIsSocket) ? m_pFile->GetLength() - m_lStart : p_lSize;
    m_mode = M_NONE;
    m_pBuf = new UCHAR[m_lBufSize];
    m_bEOF = FALSE;
	
}

cArchive::~cArchive()
{
    Flush();
    if (m_pBuf)
    {
        delete [] m_pBuf;
    }
}


BOOL cArchive::Flush()
{
    BOOL    bRetVal = TRUE;
    switch (m_mode)
    {
    case M_WRITE:
        if (m_lBufPos>0)
        {
            m_pFile->Write(m_pBuf,m_lBufPos);
        }
        break;
    case M_READ:
        if (m_lBufPos>0 && !m_bIsSocket)
        {
            m_pFile->Seek(m_lBufStart+m_lBufPos,CFile::begin);
        }
        break;
    }
    m_lBufPos = 0;
    m_lCurBufSize = 0;
    m_lBufStart = (m_bIsSocket) ? 0 : m_pFile->GetPosition();
    m_mode = M_NONE;
    if (m_bIsSocket) m_bEOF = FALSE;  // can never reach end of file on sockets

    return bRetVal;
}

BOOL cArchive::Read(void* p_pBuf, TLONG p_lBufSize)
{
    UCHAR* pData = (UCHAR*)p_pBuf;

    while (p_lBufSize > 0)
    {
        *pData = ReadByte();
        p_lBufSize--;
        if (!m_bIsSocket && IsEOF() && p_lBufSize > 0)
        {
            return FALSE;
        }
        pData++;
    }
    return TRUE;
}



UCHAR cArchive::ReadByte()
{
    UCHAR ucRetVal;
    if (m_mode != M_READ)
    {
        Flush();
        m_mode = M_READ;
    }
	if (m_bIsSocket)
	{
		do
		{
			ReadRefreshBuffer();
		} while (m_lCurBufSize == 0);
	}
	else ReadRefreshBuffer();
    ucRetVal = m_pBuf[m_lBufPos];
    m_lBufPos++;
    if (m_bIsSocket)
	{
		m_bEOF = (m_lBufPos >= m_lCurBufSize);
	}
	else
	{
		ReadRefreshBuffer();  // make EOF after this call
	}
    return ucRetVal;
}


BOOL cArchive::ReadRefreshBuffer()
{
    try
    {
        if (m_lBufPos >= m_lCurBufSize)
        {
            if (m_bIsSocket) // && (m_lCurBufSize == m_lBufSize || m_lCurBufSize == 0))
            {
                m_lBufStart = 0;
                m_lCurBufSize = m_pFile->Read(m_pBuf,m_lBufSize);
                m_lBufPos = 0;
                m_bEOF = (m_lCurBufSize == 0);
            }
            else if (!m_bIsSocket && m_lBufStart+m_lBufPos < m_lEnd)
            {
                m_lBufStart = (m_bIsSocket) ? 0 : m_pFile->GetPosition();
                m_lCurBufSize = m_pFile->Read(m_pBuf,m_lBufSize);
                if (m_lBufStart+m_lCurBufSize>m_lEnd)
                {
                    m_lCurBufSize = (m_lEnd > m_lBufStart) ? m_lEnd - m_lBufStart : 0;
                }
                m_lBufPos = 0;
                m_bEOF = (m_lCurBufSize == 0);
            }
            else
            {
                m_bEOF = TRUE;
                m_lCurBufSize = 0;
                m_lBufPos = 0;
            }
        }
    }
    catch (CFileException*)
    {
        return FALSE; // something went wrong
    }
    return TRUE;
}


BOOL cArchive::WriteString(LPCSTR p_szString)
{
    UCHAR* pcCur = (UCHAR*)p_szString;
    while (*pcCur)
    {
        if (!Writeuc(*pcCur)) return FALSE;
        pcCur++;
    }
    return TRUE;
}

BOOL cArchive::Write(void* p_pBuf, TLONG p_lBufSize)
{
    UCHAR* pData = (UCHAR*)p_pBuf;

    while (p_lBufSize > 0)
    {
        if (!WriteByte(*pData)) return FALSE;
        pData++;
        p_lBufSize--;
    }
    return TRUE;
}

BOOL cArchive::WriteByte(UCHAR p_ucVal)
{
    if (m_mode != M_WRITE)
    {
        Flush();
        m_mode = M_WRITE;
    }

    if (!WriteRefreshBuffer()) return FALSE;
    m_pBuf[m_lBufPos] = p_ucVal;
    m_lBufPos++;
    m_lCurBufSize++;
    return TRUE;
}


BOOL cArchive::WriteRefreshBuffer()
{
    try
    {
        if (m_lBufPos >= m_lBufSize)
        {
            m_pFile->Write(m_pBuf,m_lBufSize);
            m_lBufStart = (m_bIsSocket) ? 0 : m_pFile->GetPosition();

            m_lCurBufSize = 0;
            m_lBufPos = 0;
        }
    }
    catch (CFileException*)
    {
        return FALSE;
    }
    return TRUE;
}
#endif