// ServingSocketThread.cpp : implementation file
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "ServingSocketThread.h"
#include "PabloDrawDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CServingSocketThread

IMPLEMENT_DYNCREATE(CServingSocketThread, CWinThread)

CServingSocketThread::CServingSocketThread()
{
	m_pListeningSocket = NULL;
	m_pServingSocketThread = NULL;
	m_hSocket = NULL;
}

CServingSocketThread::~CServingSocketThread()
{
}

BOOL CServingSocketThread::Initialize(CServingSocketThread* p_pThread, CListeningSocket* p_pListeningSocket, SOCKET p_hsocket)
{
	m_pServingSocketThread = p_pThread;
    m_pListeningSocket = p_pListeningSocket;
    m_hSocket = p_hsocket;
    return TRUE;
}


BOOL CServingSocketThread::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox("Socket initialization failed!");
		return FALSE;
	}
	m_pSocket = new CServingSocket;
    if (m_pListeningSocket) m_pSocket->SetListeningSocket(m_pListeningSocket);
    m_pSocket->m_pThread = m_pServingSocketThread;
	m_pSocket->m_pCriticalSection = m_pListeningSocket->GetDocument()->GetCriticalSection();
	m_pSocket->Attach(m_hSocket);
	m_pSocket->Init();
	m_pListeningSocket->AddSocket(this);
	return TRUE;
}

int CServingSocketThread::ExitInstance()
{
	if (m_pListeningSocket) m_pListeningSocket->RemoveSocket(this);
	if (m_pSocket)
	{
		delete m_pSocket;
		m_pSocket = NULL;
	}
	return CWinThread::ExitInstance();
}

void CServingSocketThread::OnDisconnect(WPARAM wParam, LPARAM lParam)
{
	ASSERT(this);

	if (m_pListeningSocket) 
	{
		m_pListeningSocket->RemoveSocket(this);
		m_pListeningSocket = NULL;
	}
	if (m_pSocket)
	{
		delete m_pSocket;
		m_pSocket = NULL;
	}

    PostThreadMessage(WM_QUIT, 0, 0);
}


BEGIN_MESSAGE_MAP(CServingSocketThread, CWinThread)
	ON_THREAD_MESSAGE(WM_USER_DISCONNECT, OnDisconnect)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CServingSocketThread message handlers
