#pragma once

#include "cCanvas.h"

class CPabloDrawDoc;


enum eMessageType
{
    MT_CLOSE        = 0,
    MT_INIT         = 1,
	MT_VERSION		= 2,
	MT_USER_JOIN	= 10,
	MT_USER_PART	= 11,
	MT_MESSAGE		= 20,
	MT_OPTIONS		= 21,

	
	MT_CLEAR		= 100,
	MT_SENDPART     = 101,
    MT_GETPART      = 102,
	MT_INSERTLINE   = 103,
	MT_DELETELINE	= 104,
	MT_INSERTCOL	= 105,
	MT_DELETECOL	= 106,
    MT_DELETECHAR   = 107,
    MT_INSERTCHAR   = 108,
	MT_FILL_CHAR	= 109,
	MT_FILL_ATTR	= 110,
	MT_FILL_FORE	= 111,
	MT_FILL_BACK	= 112,
	MT_DELETE_RECT  = 113,
	MT_ERASE_RECT   = 114,

	MT_UNDO			= 115,
	MT_REDO			= 116,
	MT_UNDOSTATE	= 117,
	MT_UNDOCOMBINE	= 118
};

class CClientSocket : public CSocket
{
	DECLARE_DYNAMIC(CClientSocket);

public:
    CClientSocket(CPabloDrawDoc* pDoc, LPCTSTR p_tszAlias = NULL);
	virtual ~CClientSocket();

    void Init();
	void Remove();

    void Clear(cCanvas* pCanvas);
    void DeleteChar(cCanvas* pCanvas, CPoint p_point, BOOL p_bInsert);
    void InsertChar(cCanvas* pCanvas, CPoint p_point, sCanvasElement p_ce, BOOL p_bInsert);
    void DeleteColumn(cCanvas* pCanvas, int p_iColumn);
    void InsertColumn(cCanvas* pCanvas, int p_iColumn);
    void DeleteLine(cCanvas* pCanvas, int p_iLine);
    void InsertLine(cCanvas* pCanvas, int p_iLine);
    void Delete(cCanvas* pCanvas, CRect rect);
    void Erase(cCanvas* pCanvas, CRect rect);
	void FillChar(cCanvas* pCanvas, CRect rect, UCHAR p_ucChar);
	void FillAttr(cCanvas* pCanvas, CRect rect, UCHAR p_ucAttr);
	void FillFore(cCanvas* pCanvas, CRect rect, UCHAR p_ucFore);
	void FillBack(cCanvas* pCanvas, CRect rect, UCHAR p_ucBack);

    void SendPart(cCanvas* pCanvas, CRect rect, CPoint ptDest);
	void SendPart(cCanvas* pCanvas, CRect rect);

	static void SendPart(CSocketFile* p_pFile, cCanvas* pCanvas, CRect rect, CPoint ptDest, cOptions* p_pOptions);

	void Undo(cCanvas* pCanvas);
	void Redo(cCanvas* pCanvas);
	void UndoCombine(ULONG ulUndoCombine = 1);

	void Message(LPCTSTR p_tszMessage);

    void OnReceive(int nErrorCode);

private:
	CString			m_strAlias;
    CPabloDrawDoc*	m_pDoc;
	CSocketFile*	m_pFile;
	CCriticalSection* m_pCriticalSection;
	BOOL			m_bUndoState;
	ULONG			m_ulUndoCombine;
public:
	virtual void OnClose(int nErrorCode);
};
