// ClientSocket.cpp: implementation of the CClientSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "ClientSocket.h"
#include "PabloDrawdoc.h"
#include "pablo_ver.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CClientSocket::CClientSocket(CPabloDrawDoc* pDoc, LPCTSTR p_tszAlias)
{
	if (p_tszAlias) m_strAlias = p_tszAlias;
	m_pDoc = pDoc;
    m_pFile = NULL;
	m_pCriticalSection = pDoc->GetCriticalSection();
	m_bUndoState = false;
	m_ulUndoCombine = 0;
}

CClientSocket::~CClientSocket()
{
	if (m_pFile) delete m_pFile;
}


void CClientSocket::Remove()
{
	m_pDoc = NULL;
/*
	if (m_pFile != NULL)
    {
		cArchive_store(ar, m_pFile);
		ar.Writeul(MT_USER_PART);
		ar.Writeul(m_strAlias.GetLength());
		ar.WriteString(m_strAlias);
		ar.Writeul(MT_CLOSE);  // send close message to server
		ar.Flush();
    }
	*/
}

void CClientSocket::Init()
{
	m_pFile = new CSocketFile(this, TRUE);

	cArchive_store(ar, m_pFile);
	
    ar.Writeul(MT_USER_JOIN);
	ar.Writeul(m_strAlias.GetLength());
	ar.WriteString(m_strAlias);

    ar.Flush();
}

void CClientSocket::DeleteChar(cCanvas* pCanvas, CPoint p_point, BOOL p_bInsert)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_DELETECHAR);
	ar.Writeuc((p_bInsert) ? 1 : 0);
	ar.WritePt(p_point);
    ar.Flush();
}

void CClientSocket::InsertChar(cCanvas* pCanvas, CPoint p_point, sCanvasElement p_ce, BOOL p_bInsert)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_INSERTCHAR);
	ar.Writeuc((p_bInsert) ? 1 : 0);
	ar.WritePt(p_point);
	ar.Writeus(p_ce.value);
    ar.Flush();
}

void CClientSocket::Clear(cCanvas* pCanvas)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_CLEAR);
	ar.WriteSz(pCanvas->GetSize());
    ar.Flush();
}

void CClientSocket::DeleteColumn(cCanvas* pCanvas, int p_iColumn)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_DELETECOL);
	ar.Writeul(p_iColumn);
    ar.Flush();
}
void CClientSocket::InsertColumn(cCanvas* pCanvas, int p_iColumn)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_INSERTCOL);
	ar.Writeul(p_iColumn);
    ar.Flush();
}
void CClientSocket::DeleteLine(cCanvas* pCanvas, int p_iLine)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_DELETELINE);
	ar.Writeul(p_iLine);
    ar.Flush();
}
void CClientSocket::InsertLine(cCanvas* pCanvas, int p_iLine)
{
	cArchive_store(ar, m_pFile);
    ar.Writeul(MT_INSERTLINE);
	ar.Writeul(p_iLine);
    ar.Flush();
}
void CClientSocket::FillChar(cCanvas* pCanvas, CRect rect, UCHAR p_ucChar)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_FILL_CHAR);
    ar.WriteRc(rect);
	ar.Writeuc(p_ucChar);
	ar.Flush();
}

void CClientSocket::FillAttr(cCanvas* pCanvas, CRect rect, UCHAR p_ucAttr)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_FILL_ATTR);
    ar.WriteRc(rect);
	ar.Writeuc(p_ucAttr);
	ar.Flush();
}

void CClientSocket::FillFore(cCanvas* pCanvas, CRect rect, UCHAR p_ucFore)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_FILL_FORE);
    ar.WriteRc(rect);
	ar.Writeuc(p_ucFore);
	ar.Flush();
}

void CClientSocket::FillBack(cCanvas* pCanvas, CRect rect, UCHAR p_ucBack)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_FILL_BACK);
    ar.WriteRc(rect);
	ar.Writeuc(p_ucBack);
	ar.Flush();
}

void CClientSocket::Delete(cCanvas* pCanvas, CRect rect)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_DELETE_RECT);
    ar.WriteRc(rect);
	ar.Flush();
}

void CClientSocket::Erase(cCanvas* pCanvas, CRect rect)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_ERASE_RECT);
    ar.WriteRc(rect);
	ar.Flush();
}

void CClientSocket::Undo(cCanvas* pCanvas)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_UNDO);
	ar.Flush();
}

void CClientSocket::Redo(cCanvas* pCanvas)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_REDO);
	ar.Flush();
}
void CClientSocket::UndoCombine(ULONG ulUndoCombine)
{
	cArchive_store(ar, m_pFile);
	ar.Writeul(MT_UNDOCOMBINE);
	ar.Writeul(ulUndoCombine);
	ar.Flush();
}


void CClientSocket::Message(LPCTSTR p_tszMessage)
{
	cArchive_store(ar, m_pFile);
	ASSERT(p_tszMessage);
	CString strMessage;
	strMessage.Format(_T("<%s> %s"), (LPCTSTR)m_strAlias, p_tszMessage);
    ar.Writeul(MT_MESSAGE);
	ar.Writeul(strMessage.GetLength());
	ar.WriteString(strMessage);
    ar.Flush();
}

void CClientSocket::SendPart(cCanvas* pCanvas, CRect rect, CPoint ptDest)
{
	SendPart(m_pFile, pCanvas, rect, ptDest, m_pDoc->GetApp()->GetOptions());
}

void CClientSocket::SendPart(cCanvas* pCanvas, CRect rect)
{
	SendPart(m_pFile, pCanvas, rect, rect.TopLeft(), m_pDoc->GetApp()->GetOptions());
}

void CClientSocket::SendPart(CSocketFile* p_pFile, cCanvas* pCanvas, CRect rect, CPoint ptDest, cOptions* p_pOptions)
{
	cArchive_store(ar, p_pFile);
    rect.NormalizeRect();
	// validate rect to send
	if (rect.left > pCanvas->GetSize().cx || rect.top > pCanvas->GetSize().cy ||
		rect.bottom < 0 || rect.right < 0) 
		return;  // nothing to send
	if (rect.top < 0) rect.top = 0;
	if (rect.left < 0) rect.left = 0;
	if (rect.right > pCanvas->GetSize().cx) rect.right = pCanvas->GetSize().cx;
	if (rect.bottom > pCanvas->GetSize().cy) rect.bottom = pCanvas->GetSize().cy;
	// send to server
	ar.Writeul(MT_SENDPART);
	CRect rectDest(ptDest, rect.Size());
	CMemFile f;
	cFormatAnsi fa;

	fa.Save(&f, pCanvas, rect, p_pOptions);

	f.SeekToBegin();

    ar.WriteRc(rectDest);
	ar.Writeul((ULONG)f.GetLength());
	const ULONG ulBufSize = 1024;
	char buf[ulBufSize];

	ULONG ulNumRead = ulBufSize;
	while (ulNumRead == ulBufSize)
	{
		ulNumRead = f.Read(buf, ulBufSize);
		ar.Write(buf, ulNumRead);
	}


	/*
    CPoint pt;
    for (pt.y=rect.top; pt.y<rect.bottom; pt.y++)
    {
        for (pt.x=rect.left; pt.x<rect.right; pt.x++)
        {
            ar.Writeus(pCanvas->Get(pt).value);
        }
    }
	*/
    ar.Flush();
}

void CClientSocket::OnReceive(int nErrorCode)
{
    CSocket::OnReceive(nErrorCode);

    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)m_pDoc;
    cPage* pPage = pDoc->GetCurrentPage();

	cCanvas* pCanvas = (pPage) ? pPage->GetCanvas() : NULL; 

	CString str;
	ULONG ulCount;
	ULONG ulProtocolVersion;
	BOOL bInsert;

    eMessageType mt;
    CRect rect;
    CSize size;
	UCHAR ucValue;
	ULONG ulLine;
    CPoint pt;
    sCanvasElement ce;
	cArchive_load(ar, m_pFile);
	cArchive_store(ars, m_pFile);
//	ar.Flush();
	do
	{
		//CSingleLock(m_pCriticalSection, TRUE);

        mt = (eMessageType)ar.Readul();

        switch (mt)
        {
        case MT_INIT:
			str.Empty();
			ulProtocolVersion = ar.Readul();
			ulCount = ar.Readul();
			while (ulCount-- > 0) str += ar.Readc();
			if (str == PABLO_BUILD && ulProtocolVersion == PABLO_SOCKET_VERSION)
			{
				size.cx = ar.Readul();
				size.cy = ar.Readul();
				if (pCanvas) pCanvas->Fill(7, 32);
				if (pCanvas) pCanvas->Resize(size);
				if (pCanvas) pDoc->SendMessage(WM_USER_UPDATE_CANVAS);
				if (pCanvas) pDoc->UpdateRegion(CRect(CPoint(0,0),pCanvas->GetSize()));
			}
			else
			{
				pDoc->DeleteClient();
				CString strTemp;
				strTemp.Format(_T("Incompatible versions!\n  You are running v.%s protocol v.%u\n  Server is running v.%s protocol v.%u"), PABLO_BUILD, PABLO_SOCKET_VERSION, (LPCTSTR)str, ulProtocolVersion);
				AfxMessageBox(strTemp);
				return;
			}
            break;
		case MT_UNDOSTATE:
			m_bUndoState = (BOOL)ar.Readuc();
			break;
		case MT_UNDOCOMBINE:
			m_ulUndoCombine = ar.Readul();
			break;

        case MT_CLEAR:
			size = ar.ReadSz();
			if (m_bUndoState) pPage->SaveCanvas(CRect(0,0,0,0), CPoint(), UT_CLEAR, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->Fill(7, 32);
			if (pCanvas) pCanvas->Resize(size);
			if (pCanvas) pDoc->SendMessage(WM_USER_UPDATE_CANVAS);
			if (pCanvas) pDoc->UpdateRegion(CRect(CPoint(0,0),pCanvas->GetSize()));
			break;
		case MT_DELETECHAR:
			bInsert = (ar.Readuc() == 1) ? TRUE : FALSE;
            pt = ar.ReadPt();
			if (m_bUndoState) pPage->SaveCanvas(CRect(pt, CSize(1,1)), pt, bInsert ? UT_DELETECHAR : UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
            if (pCanvas) pCanvas->DeleteChar(pt);            
            if (pCanvas) pDoc->UpdateRegion(CRect(pt,CSize(pCanvas->GetSize().cx-pt.x, 1)));
            break;
		case MT_INSERTCHAR:
			bInsert = (ar.Readuc() == 1) ? TRUE : FALSE;
            pt = ar.ReadPt();

			if (bInsert)
			{
				if (m_bUndoState) pPage->SaveCanvas(CRect(CPoint(pCanvas->GetSize().cx-1, pt.y), CSize(1,1)), pt, UT_BLOCK, FALSE);
				if (m_bUndoState) pPage->SaveCanvas(CRect(pt, CSize(1,1)), pt, UT_INSERTCHAR, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			}
			else
				if (m_bUndoState) pPage->SaveCanvas(CRect(pt, CSize(1,1)), pt, UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);

			ce.value = ar.Readus();
            if (pCanvas) pCanvas->InsertChar(pt, ce, bInsert);
            if (pCanvas) pDoc->UpdateRegion(CRect(pt,CSize(pCanvas->GetSize().cx-pt.x, 1)));
            break;
		case MT_DELETECOL:
			ulLine = ar.Readul();
			if (m_bUndoState) pPage->SaveCanvas(CRect(0,0,0,0), CPoint(ulLine, 0), UT_DELETECOL, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->DeleteColumn(ulLine);
			if (pCanvas) pDoc->UpdateRegion(CRect(ulLine, 0, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
			break;
		case MT_INSERTCOL:
			ulLine = ar.Readul();
			int iEndY;
			iEndY = pCanvas->FindEndY();
			if (m_bUndoState) pPage->SaveCanvas(CRect(CPoint(pCanvas->GetSize().cx-1, 0), CSize(1, iEndY)), CPoint(ulLine, 0), UT_BLOCK, FALSE);
			if (m_bUndoState) pPage->SaveCanvas(CRect(0,0,0,0), CPoint(ulLine, 0), UT_INSERTCOL, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->InsertColumn(ulLine);
			if (pCanvas) pDoc->UpdateRegion(CRect(ulLine, 0, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
			break;
        case MT_DELETELINE:
			ulLine = ar.Readul();
			if (m_bUndoState) pPage->SaveCanvas(CRect(0,0,0,0), CPoint(0, ulLine), UT_DELETELINE, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->DeleteLine(ulLine);
			if (pCanvas) pDoc->UpdateRegion(CRect(0, ulLine, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
			break;
        case MT_INSERTLINE:
			ulLine = ar.Readul();
			//pPage->UpdateUndoBuffer(CPoint(0,ulLine), UT_INSERTLINE);
			if (m_bUndoState) pPage->SaveCanvas(CRect(CPoint(0,pCanvas->GetSize().cy-1), CSize(pCanvas->GetSize().cx, 1)), CPoint(0, ulLine), UT_BLOCK, FALSE);
			if (m_bUndoState) pPage->SaveCanvas(CRect(0,0,0,0), CPoint(0, ulLine), UT_INSERTLINE, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->InsertLine(ulLine);
			if (pCanvas) pDoc->UpdateRegion(CRect(0, ulLine, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
			break;
		case MT_FILL_CHAR:
            rect = ar.ReadRc();
			ucValue = ar.Readuc();
			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->FillChar(ucValue, rect);
			pDoc->UpdateRegion(rect);
			break;
		case MT_FILL_ATTR:
            rect = ar.ReadRc();
			ucValue = ar.Readuc();
			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->FillAttr(ucValue, rect);
			pDoc->UpdateRegion(rect);
			break;
		case MT_FILL_FORE:
            rect = ar.ReadRc();
			ucValue = ar.Readuc();
			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->FillFore(ucValue, rect);
			pDoc->UpdateRegion(rect);
			break;
		case MT_FILL_BACK:
            rect = ar.ReadRc();
			ucValue = ar.Readuc();
			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->FillBack(ucValue, rect);
			pDoc->UpdateRegion(rect);
			break;
		case MT_DELETE_RECT:
            rect = ar.ReadRc();
			if (pCanvas)
			{
				if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
				pCanvas->Delete(rect);
				rect.left = 0;
				rect.right = pCanvas->GetSize().cx;
				pDoc->UpdateRegion(rect);
			}
			break;
		case MT_ERASE_RECT:
            rect = ar.ReadRc();
			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);
			if (pCanvas) pCanvas->Fill(7,32, rect);
			if (pCanvas) pDoc->UpdateRegion(rect);
			break;
        case MT_SENDPART:
            rect = ar.ReadRc();

			if (m_bUndoState) pPage->SaveCanvas(rect, CPoint(0,0), UT_BLOCK, (m_ulUndoCombine > 0) ? (m_ulUndoCombine-- == 0) : TRUE);


			{
				CMemFile mf;
				ULONG ulBytesLeft = ar.Readul();

				const ULONG ulBufSize = 1024;
				char buf[ulBufSize];
				while (ulBytesLeft > 0)
				{
					ULONG ulBytesToRead = (ulBytesLeft > ulBufSize) ? ulBufSize : ulBytesLeft;
					ar.Read(buf, ulBytesToRead);
					ulBytesLeft -= ulBytesToRead;
					mf.Write(buf, ulBytesToRead);
				}

				mf.SeekToBegin();

				pCanvas->Fill(0x07, 32, rect);
				cFormatAnsi fa;
				fa.Load(&mf, pCanvas, rect, pDoc->GetApp()->GetOptions());
			}

			/*
			for (pt.y=rect.top; pt.y<rect.bottom; pt.y++)
            {
                for (pt.x=rect.left; pt.x<rect.right; pt.x++)
                {
                    ce.value = ar.Readus();
                    if (pCanvas) pCanvas->Set(pt,ce);
                }
            }
			*/
			pDoc->UpdateRegion(rect);
            break;
		case MT_USER_JOIN:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
			pDoc->SendMessage(WM_USER_JOINED, (WPARAM)(LPCTSTR)str);
			break;

		case MT_USER_PART:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
			pDoc->SendMessage(WM_USER_PARTED, (WPARAM)(LPCTSTR)str);
			break;
		
		case MT_MESSAGE:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
			pDoc->SendMessage(WM_USER_ADD_MESSAGE, (WPARAM)(LPCTSTR)str);
			//AfxMessageBox(str);
			break;
        }
    }
	while (!ar.IsBufferEmpty());
//	ar.Flush();
}


IMPLEMENT_DYNAMIC(CClientSocket, CSocket);

void CClientSocket::OnClose(int nErrorCode)
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)m_pDoc;
	if (nErrorCode == 0 && m_pDoc)
	{
		AfxMessageBox(_T("The server closed the connection"));
		pDoc->DeleteClient(FALSE);
	}
	else
	{
		AfxMessageBox(_T("The server closed the connection unexpectedly"));
		pDoc->DeleteClient(FALSE);
	}
	CSocket::OnClose(nErrorCode);
}
