// ChildFrm.cpp : implementation of the CChildFrame class
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "ChildFrm.h"
#include "MainFrm.h"

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	ON_WM_CREATE()
	ON_WM_MOVE()
    ON_MESSAGE(WM_USER_UPDATE_COLOUR, OnUpdateColour)
	ON_MESSAGE(WM_USER_UPDATE_CHARSET, OnUpdateCharSet)
	ON_MESSAGE(WM_USER_ADD_MESSAGE, OnAddMessage)
	ON_MESSAGE(WM_USER_JOINED, OnUserJoined)
	ON_MESSAGE(WM_USER_PARTED, OnUserParted)
	ON_MESSAGE(WM_USER_FULLSCREEN_SWITCH, OnFullScreenSwitch)
	ON_COMMAND(ID_SWITCHCHATEDIT, OnSwitchChatEdit)
	ON_COMMAND(ID_SHOW_CHAT_WINDOW, OnShowChatWindow)
	ON_UPDATE_COMMAND_UI(ID_SHOW_CHAT_WINDOW, OnUpdateShowChatWindow)
	ON_COMMAND(ID_VIEW_SHOW_PREVIEW, OnShowPreview)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOW_PREVIEW, OnUpdateShowPreview)

	ON_COMMAND(ID_CANVAS_BREAKCONNECTION, OnCanvasBreakconnection)
	ON_COMMAND(ID_CANVAS_CONNECTTOSERVER, OnCanvasConnecttoserver)
	ON_COMMAND(ID_CANVAS_STARTSERVER, OnCanvasStartserver)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_BREAKCONNECTION, OnUpdateCanvasBreakconnection)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_CONNECTTOSERVER, OnUpdateCanvasConnecttoserver)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_STARTSERVER, OnUpdateCanvasStartserver)
	ON_COMMAND(ID_VIEW_CHARACTER_SET, OnViewCharacterSet)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CHARACTER_SET, OnUpdateViewCharacterSet)
	ON_COMMAND(ID_VIEW_COLOURBAR, OnViewColourbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COLOURBAR, OnUpdateViewColourbar)
	ON_WM_SIZE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
	// TODO: add member initialization code here

}

CChildFrame::~CChildFrame()
{
}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	if( !CMDIChildWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}


void CChildFrame::ActivateFrame(int nCmdShow)
{
    BOOL bMaximized;
    CMDIChildWnd* pChild = GetMDIFrame()->MDIGetActive(&bMaximized);
    if (nCmdShow == -1 && (bMaximized || !pChild))
        nCmdShow = SW_SHOWMAXIMIZED;
	m_wndPreview.SetParentFrame(this);

    CMDIChildWnd::ActivateFrame(nCmdShow);
} 

/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers
static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
    ID_INDICATOR_POS,
//	ID_INDICATOR_INS,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

int CChildFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	ACCEL mainAccels[] = 
	{
		{ FVIRTKEY | FNOINVERT				, VK_TAB			, ID_SWITCHCHATEDIT			},
		{ FVIRTKEY | FALT | FNOINVERT		, 'V'			, ID_VIEW_SHOW_PREVIEW			},
	};

	m_hAccelTable = ::CreateAcceleratorTable(mainAccels, (sizeof(mainAccels) / sizeof(ACCEL)));


	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
    m_wndStatusBar.SetPaneInfo(1,ID_INDICATOR_POS,0,100);

	EnableDocking(CBRS_ALIGN_ANY);

    if (!m_wndPreview.Create("Preview", this, CSize(200,200), TRUE, 1, WS_CHILD|WS_VISIBLE|CBRS_GRIPPER|CBRS_RIGHT| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndPreview.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBar(&m_wndPreview);

	if (!m_wndChat.Create("Chat", this, CSize(300,100), TRUE, 2, WS_VISIBLE|WS_CHILD|CBRS_BOTTOM|CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndChat.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndChat);

	if (!m_wndUserList.Create("User List", this, CSize(90, 100), TRUE, 3, WS_VISIBLE|WS_CHILD|CBRS_BOTTOM|CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndUserList.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBarLeftOf(&m_wndUserList, &m_wndChat);



    if (!m_wndColour.Create("Colour", this, CSize(200,200), TRUE, 4, WS_CHILD|WS_VISIBLE | CBRS_BOTTOM| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndColour.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBar(&m_wndColour);

    if (!m_wndCharSet.Create("Character Set", this, CSize(200,200), TRUE, 5, WS_CHILD|WS_VISIBLE | CBRS_BOTTOM| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndCharSet.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBarLeftOf(&m_wndCharSet, &m_wndColour);


	m_wndChat.SetParentFrame(this);
	m_wndColour.SetParentFrame(this);
	m_wndCharSet.SetParentFrame(this);

	m_wndUserList.ShowWindow(SW_HIDE);
	m_wndChat.ShowWindow(SW_HIDE);

	return 0;
}

void CChildFrame::OnMove(int x, int y)
{
	CMDIChildWnd::OnMove(x, y);
    AfxGetMainWnd()->Invalidate();

}


LRESULT CChildFrame::OnUpdateColour(WPARAM wparam, LPARAM lparam)
{
    m_wndColour.Update();
    return 0;
}

LRESULT CChildFrame::OnUpdateCharSet(WPARAM wparam, LPARAM lparam)
{
    m_wndCharSet.Update();
    return 0;
}

LRESULT CChildFrame::OnAddMessage(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszMessage = (LPCTSTR)wparam;
	ASSERT(tszMessage);
    m_wndChat.AddMessage(tszMessage);
    return 0;
}

LRESULT CChildFrame::OnUserJoined(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszUser = (LPCTSTR)wparam;
	ASSERT(tszUser);
    m_wndUserList.AddUser(tszUser);
    return 0;
}

LRESULT CChildFrame::OnUserParted(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszUser = (LPCTSTR)wparam;
	if (tszUser)
	{
		m_wndUserList.RemoveUser(tszUser);
	}
	else
	{
		m_wndUserList.RemoveAllUsers();
		m_wndChat.AddMessage(_T("*** Disconnected"));
	}

    return 0;
}

LRESULT CChildFrame::OnFullScreenSwitch(WPARAM wparam, LPARAM lparam)
{
	BOOL bFullScreen = (BOOL)wparam;
	if (bFullScreen)
	{
		ModifyStyle(WS_CAPTION|WS_THICKFRAME, 0, SWP_FRAMECHANGED);
		
		m_wndPreview.ShowWindow(SW_HIDE);
		m_wndStatusBar.ShowWindow(SW_HIDE);
	}
	else
	{
		ModifyStyle(0, WS_CAPTION|WS_THICKFRAME, SWP_FRAMECHANGED);
		m_wndPreview.ShowWindow(SW_SHOW);
		m_wndStatusBar.ShowWindow(SW_SHOW);
	}
	DelayRecalcLayout();
    return 0;
}

void CChildFrame::OnSwitchChatEdit()
{
	if (GetFocus())
	{
		if (GetActiveView() && (GetActiveView()->IsChild(GetFocus()) || GetActiveView() == GetFocus()))
		{
			if (g_bFullScreen && (!m_wndChat.IsVisible() || !m_wndUserList.IsVisible()))
			{
				m_wndChat.ShowWindow(SW_SHOW);
				m_wndUserList.ShowWindow(SW_SHOW);
				DelayRecalcLayout();
			}
			if (m_wndChat.IsVisible() && m_wndChat.m_pChatView)
			{
				m_wndChat.m_pChatView->SetFocus();
			}
		}
		else
		{
			if (g_bFullScreen && (m_wndChat.IsVisible() || m_wndUserList.IsVisible()))
			{
				m_wndChat.ShowWindow(SW_HIDE);
				m_wndUserList.ShowWindow(SW_HIDE);
				DelayRecalcLayout();
			}
			GetActiveView()->SetFocus();
		}
	}
}

void CChildFrame::DockControlBarLeftOf(CControlBar* Bar, CControlBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;
	
	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout(TRUE);
	
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;
	
	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line. By calculating a rectangle, we
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}


void CChildFrame::OnShowChatWindow()
{
	if (m_wndChat.IsVisible() || m_wndUserList.IsVisible())
	{
		m_wndChat.ShowWindow(SW_HIDE);
		m_wndUserList.ShowWindow(SW_HIDE);
	}
	else
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
	}
	DelayRecalcLayout();
}

void CChildFrame::OnUpdateShowChatWindow(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndChat.IsVisible() || m_wndUserList.IsVisible()) ? TRUE : FALSE);
}

void CChildFrame::OnShowPreview()
{
	m_wndPreview.ShowWindow((m_wndPreview.IsVisible()) ? SW_HIDE : SW_SHOW); 
	DelayRecalcLayout();
}

void CChildFrame::OnUpdateShowPreview(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_wndPreview.IsVisible() ? TRUE : FALSE);
}
void CChildFrame::OnCanvasBreakconnection()
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnCanvasBreakconnection();
}
void CChildFrame::OnCanvasConnecttoserver()
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnCanvasConnecttoserver();
	if (pDoc->GetClientSocket())
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
		DelayRecalcLayout();
	}
}
void CChildFrame::OnCanvasStartserver()
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnCanvasStartserver();
	if (pDoc->GetClientSocket())
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
		DelayRecalcLayout();
	}
}
void CChildFrame::OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI)
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnUpdateCanvasBreakconnection(pCmdUI);
}
void CChildFrame::OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI)
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnUpdateCanvasConnecttoserver(pCmdUI);
}
void CChildFrame::OnUpdateCanvasStartserver(CCmdUI* pCmdUI)
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetActiveDocument();
	pDoc->OnUpdateCanvasStartserver(pCmdUI);
}


void CChildFrame::OnViewCharacterSet()
{
	m_wndCharSet.ShowWindow((m_wndCharSet.IsVisible()) ? SW_HIDE : SW_SHOW); 
	DelayRecalcLayout();
}

void CChildFrame::OnUpdateViewCharacterSet(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndCharSet.IsVisible()) ? TRUE : FALSE);
}

void CChildFrame::OnViewColourbar()
{
	m_wndColour.ShowWindow((m_wndColour.IsVisible()) ? SW_HIDE : SW_SHOW); 
	DelayRecalcLayout();
}

void CChildFrame::OnUpdateViewColourbar(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndColour.IsVisible()) ? TRUE : FALSE);
}

void CChildFrame::OnSize(UINT nType, int cx, int cy)
{
	CMDIChildWnd::OnSize(nType, cx, cy);

	if (g_bFullScreen)
	{
		if (nType == SIZE_MAXIMIZED)
			ModifyStyle(WS_CAPTION|WS_THICKFRAME, 0, SWP_FRAMECHANGED);
		else
			ModifyStyle(0, WS_CAPTION|WS_THICKFRAME, SWP_FRAMECHANGED);
	}

	// TODO: Add your message handler code here
}
