// CanvasView.cpp : implementation file
//

#include "stdafx.h"
#include "MainFrm.h"
#include "PabloDraw.h"
#include "PabloDrawDoc.h"
#include "CanvasView.h"
#include "CharSelectDialog.h"
#include "cFileDialog.h"
#include "cFormatAnsi.h"
#include "sAccel.h"

#include "ChatView.h"

#define ID_BLINK_TIMER	1
#define BLINK_TIMER_SPEED 200

#define ID_TYPE_TIMER	2

IMPLEMENT_DYNCREATE(CCanvasView, CScrollView)

CCanvasView::CCanvasView(BOOL p_bSimpleMode)
{
    m_curpoint = CPoint(0,0);
	m_rectSelected.SetRectEmpty();
	m_hBlockAccel = NULL;
	m_hPasteAccel = NULL;
	m_hMainAccel = NULL;
	m_hNormalAccel = NULL;
	m_bIsPreview = FALSE;
	m_bBlinkOn = TRUE;
	m_bBlockSelectMode = FALSE;
	m_bBlockPasteMode = FALSE;
	m_bSimpleMode = p_bSimpleMode;
	m_bCaptureMouse = FALSE;
	m_bIsTyping = FALSE;
	m_ptMouseLast = CPoint(LONG_MAX,LONG_MAX);
}

CCanvasView::~CCanvasView()
{
}


BEGIN_MESSAGE_MAP(CCanvasView, CScrollView)
	ON_COMMAND(ID_MOVE_CANVAS_END, OnMoveCanvasEnd)
	ON_COMMAND(ID_MOVE_CANVAS_HOME, OnMoveCanvasHome)
	ON_COMMAND(ID_MOVE_LINE_END, OnMoveLineEnd)
	ON_COMMAND(ID_MOVE_LINE_HOME, OnMoveLineHome)
	ON_COMMAND(ID_MOVE_DOWN, OnMoveDown)
	ON_COMMAND(ID_MOVE_LEFT, OnMoveLeft)
	ON_COMMAND(ID_MOVE_RIGHT, OnMoveRight)
	ON_COMMAND(ID_MOVE_UP, OnMoveUp)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_MOVE_PGDN, OnMovePgdn)
	ON_COMMAND(ID_MOVE_PGUP, OnMovePgup)
	ON_WM_CHAR()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
    ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_CHAR_BACKSPACE, OnCharBackspace)
	ON_COMMAND(ID_CHAR_DELETE, OnCharDelete)
	ON_COMMAND_RANGE(ID_DRAW_CHAR1, ID_DRAW_CHAR12, OnDrawChar)
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_COMMAND(ID_MOVE_LINE_NEXT, OnMoveLineNext)
	ON_COMMAND(ID_TOGGLE_INSERT, OnToggleInsert)
	ON_COMMAND(ID_ATTR_BACK_NEXT, OnAttrBackNext)
	ON_COMMAND(ID_ATTR_BACK_PREV, OnAttrBackPrev)
	ON_COMMAND(ID_ATTR_FORE_NEXT, OnAttrForeNext)
	ON_COMMAND(ID_ATTR_FORE_PREV, OnAttrForePrev)
    ON_COMMAND(ID_SWITCH_FONT, OnSwitchFont)

    ON_COMMAND(ID_COLUMN_DELETE, OnColumnDelete)
    ON_COMMAND(ID_COLUMN_INSERT, OnColumnInsert)
    ON_COMMAND(ID_LINE_DELETE, OnLineDelete)
	ON_COMMAND(ID_LINE_INSERT, OnLineInsert)
	ON_COMMAND(ID_GET_COLOUR, OnGetColour)
	ON_MESSAGE(WM_DOREALIZE, OnDoRealize)

	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)

    ON_UPDATE_COMMAND_UI(ID_INDICATOR_POS, OnUpdatePos)

	ON_COMMAND_RANGE(ID_SET_CHARSET1, ID_SET_CHARSET20, OnSetCharset)
	ON_WM_KEYDOWN()
	ON_WM_SYSKEYDOWN()
	ON_MESSAGE(WM_USER_ADD_MESSAGE, OnAddMessage)
	ON_MESSAGE(WM_USER_JOINED, OnUserJoined)
	ON_MESSAGE(WM_USER_PARTED, OnUserParted)
	ON_MESSAGE(WM_USER_UPDATE_CANVAS, OnUpdateCanvas)
	ON_WM_SYSCHAR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
    ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateCutCopy)
    ON_COMMAND(ID_EDIT_CUT, OnEditCut)
    ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateCutCopy)
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_MESSAGE(WM_USER_FULLSCREEN_SWITCH, OnFullScreenSwitch)
	ON_WM_TIMER()

	ON_COMMAND(ID_BLOCK_SELECT, OnBlockSelect)
	ON_COMMAND(ID_FILL, OnFill)
	ON_COMMAND(ID_FILL_ATTRIBUTE, OnFillAttribute)
	ON_COMMAND(ID_FILL_BACKGROUND, OnFillBacgroundonly)
	ON_COMMAND(ID_FILL_BOTH, OnFillBothcharacterattribute)
	ON_COMMAND(ID_FILL_CHARACTER, OnFillCharacter)
	ON_COMMAND(ID_FILL_FOREGROUND, OnFillForeground)
	ON_COMMAND(ID_TOOLS_STARTTYPING, OnToolsStarttyping)
    ON_UPDATE_COMMAND_UI(ID_FILL, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_FILL_ATTRIBUTE, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_FILL_BACKGROUND, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_FILL_BOTH, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_FILL_CHARACTER, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_FILL_FOREGROUND, OnUpdateCutCopy)
	ON_WM_GETDLGCODE()

	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_COMMAND(ID_EDIT_ERASE, OnEditErase)
    ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_EDIT_ERASE, OnUpdateCutCopy)

	ON_COMMAND(ID_BLOCK_EXIT, OnBlockExit)

	ON_COMMAND(ID_BLOCK, OnBlock)
	ON_COMMAND_EX(ID_BLOCK_MOVE, OnProcessCommand)
	ON_COMMAND_EX(ID_BLOCK_COPY, OnProcessCommand)
    ON_COMMAND(ID_BLOCK_PASTE, OnEditPaste)
	ON_COMMAND(ID_BLOCK_ROTATE, OnBlockRotate)
	ON_COMMAND(ID_BLOCK_FLIPX, OnBlockFlipx)
	ON_COMMAND(ID_BLOCK_FLIPY, OnBlockFlipy)
    ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_BLOCK_TRANSPARENT, OnBlockTransparent)
	ON_COMMAND(ID_BLOCK_UNDER, OnBlockUnder)
    ON_UPDATE_COMMAND_UI(ID_BLOCK_MOVE, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_BLOCK_COPY, OnUpdateCutCopy)
    ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateBlockPaste)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_PASTE, OnUpdateBlockPaste)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_ROTATE, OnUpdateBlockPaste)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_FLIPX, OnUpdateBlockPaste)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_FLIPY, OnUpdateBlockPaste)
    ON_UPDATE_COMMAND_UI(ID_BLOCK_TRANSPARENT, OnUpdateBlockPaste)
    ON_UPDATE_COMMAND_UI(ID_BLOCK_UNDER, OnUpdateBlockPaste)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND_EX(ID_EDIT_UNDO, OnProcessCommand)
	ON_COMMAND_EX(ID_EDIT_REDO, OnProcessCommand)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateCommand)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REDO, OnUpdateCommand)
	END_MESSAGE_MAP()


BOOL CCanvasView::PreCreateWindow( CREATESTRUCT& cs )
{
    if (!CScrollView::PreCreateWindow(cs)) return FALSE;

	CBrush br;
	br.CreateSolidBrush(RGB(0,0,0));
	cs.lpszClass = ::AfxRegisterWndClass(CS_DBLCLKS, ::LoadCursor(NULL, IDC_IBEAM), (HBRUSH)br.Detach(), NULL);
	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	//cs.style &= ~(WS_VSCROLL|WS_HSCROLL);
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CCanvasView drawing

void CCanvasView::OnDraw(CDC* pDC)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

    CDC bufDC;

    CPoint pt;
    CRect brect;
    CSize sizeTotal = GetTotalSize();

    pDC->GetClipBox(brect);
    if (brect.right>sizeTotal.cx) brect.right = sizeTotal.cx;
    if (brect.bottom>sizeTotal.cy) brect.bottom = sizeTotal.cy;
    CRect rect = brect - GetScrollPosition();

	if (!pPage)
	{
		CBrush br(RGB(0,0,0));
		pDC->FillRect(brect, &br);	
		return;
	}

	cCanvas* pCanvas = pPage->GetCanvas();
    cFont* pFont = &m_font; //pPage->GetFont();
    cPalette* pPal = pPage->GetPalette();

//    BOOL bUseScale = m_fScale < 1;
//#define FULLSCALE
//#define SCALED
//#define STRETCHED

#ifdef STRETCHED
    rect.left = rect.left * pFont->GetSize().cx / m_cursorSize.cx;
    rect.right = rect.right * pFont->GetSize().cx / m_cursorSize.cx;
    rect.top = rect.top * pFont->GetSize().cy / m_cursorSize.cy;
    rect.bottom = rect.bottom * pFont->GetSize().cy / m_cursorSize.cy;
#endif

    CPoint ptCanvas;
    CPoint ptFont;

    BITMAPINFO* pBI = new BITMAPINFO;
    int iBitmapWidth = rect.Width() + (4-(rect.Width()%4));

    pBI->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    pBI->bmiHeader.biWidth = iBitmapWidth;
    pBI->bmiHeader.biHeight = -rect.Height();
    pBI->bmiHeader.biPlanes = 1;
    pBI->bmiHeader.biBitCount = 24;
    pBI->bmiHeader.biCompression = BI_RGB;
    pBI->bmiHeader.biSizeImage = 0;//iBitmapWidth*(rect.Height()+1);
    pBI->bmiHeader.biXPelsPerMeter = 1;
    pBI->bmiHeader.biXPelsPerMeter = 1;
    pBI->bmiHeader.biClrUsed = 0; //16;
    pBI->bmiHeader.biClrImportant = 0; //16;

    UCHAR* pData = new UCHAR[iBitmapWidth*rect.Height()*3];
const int iScale = 16;

#ifdef FULLSCALE
    ULONG incrementX = (pFont->GetSize().cx << iScale)/m_cursorSize.cx;; //(ULONG)(((1 << iScale)+1)/m_fScaleX);
    ULONG incrementY = (pFont->GetSize().cy << iScale)/m_cursorSize.cy;
    int xfont = (pFont->GetSize().cx << iScale)-(incrementX/2);
    int yfont = (pFont->GetSize().cy << iScale)-(incrementY/2);
	ptCanvas.y = (brect.top)/m_cursorSize.cy;
	ptFont.y = ((brect.top)%m_cursorSize.cy)*incrementY;
	CPoint ptRealFont;

    int startfontx = ((int)((brect.left)%m_cursorSize.cx))*incrementX;

#elif defined(SCALED)
    ULONG increment = (ULONG)((1 << iScale)/m_fScale);
    int xfont = (pFont->GetSize().cx << iScale)-(increment/2);
    int yfont = (pFont->GetSize().cy << iScale)-(increment/2);
	ptCanvas.y = (brect.top)/m_cursorSize.cy;
	ptFont.y = ((brect.top)%m_cursorSize.cy)*increment;
	CPoint ptRealFont;

    int startfontx = ((brect.left)%m_cursorSize.cx)*increment;
#elif defined(STRETCHED)
    ULONG incrementX = (pFont->GetSize().cx << iScale)/m_cursorSize.cx;; //(ULONG)(((1 << iScale)+1)/m_fScaleX);
    ULONG incrementY = (pFont->GetSize().cy << iScale)/m_cursorSize.cy;

    int xfont = pFont->GetSize().cx; 
    int yfont = pFont->GetSize().cy; 
	ptCanvas.y = (brect.top)/m_cursorSize.cy;
	ptFont.y = (LONG)(((brect.top)%m_cursorSize.cy)/m_fScaleY);
	CPoint ptRealFont;
    int startfontx = (int)(((brect.left)%m_cursorSize.cx)/m_fScaleX);
#else
    int xfont = pFont->GetSize().cx; 
    int yfont = pFont->GetSize().cy; 
	ptCanvas.y = (brect.top)/m_cursorSize.cy;
	ptFont.y = ((brect.top)%m_cursorSize.cy);
	CPoint ptRealFont;
    int startfontx = ((brect.left)%m_cursorSize.cx);
#endif

	RGBQUAD rgbFore;
	RGBQUAD rgbBack;


	BOOL bInSelection = FALSE;
	cCanvas*	pBufferCanvas = pApp->GetBuffer();

    for (pt.y=0; pt.y<rect.Height(); pt.y++)
    {
		ptCanvas.x = (brect.left)/m_cursorSize.cx;
		if (ptCanvas.x>=pCanvas->GetSize().cx) break;
		ptFont.x = startfontx;
		BOOL* pFontLine = NULL;

		LONG lDatapos = pt.y*iBitmapWidth*3;
        for (pt.x=0; pt.x<rect.Width(); pt.x++)
        {
            if ((int)ptFont.x >= (int)xfont || pt.x == 0)
            {
				if (pt.x != 0)
				{
					ptFont.x = 0;
					ptCanvas.x++;
	                if (ptCanvas.x>=pCanvas->GetSize().cx) break;
				}
				bInSelection = m_rectSelected.PtInRect(ptCanvas);

				sCanvasElement ce;
				if (m_bBlockPasteMode)
				{
					ASSERT(pBufferCanvas);
					CRect rectPaste(m_curpoint, pBufferCanvas->GetSize());
					if (m_rectClear.PtInRect(ptCanvas))
						ce.Set(32, 7, 0);
					else
						ce = pCanvas->Get(ptCanvas);
					
					if (rectPaste.PtInRect(ptCanvas))
					{
						sCanvasElement ceBuf = pBufferCanvas->Get(ptCanvas - m_curpoint);
						BOOL bPaste = TRUE;
						if (m_bPasteUnder)
							bPaste &= (ce.character == 32 && (ce.GetBack() == 0 || (ce.GetBack() == 8 && pApp->GetOptions()->GetBackground8())));
						if (m_bPasteTransparent)
							bPaste &= !(ceBuf.character == 32 && (ceBuf.GetBack() == 0 || (ceBuf.GetBack() == 8 && pApp->GetOptions()->GetBackground8())));

                        if (bPaste) ce = ceBuf;
					}
				}
				else
					ce = pCanvas->Get(ptCanvas);

				rgbBack = pPal->GetRGBQuad((ce.GetBack() >= 8 && pApp->GetOptions()->GetBackground8()) ? ce.GetBack()-8 : ce.GetBack());
				rgbFore = (ce.GetBack() < 8 || m_bBlinkOn || m_bIsPreview || !pApp->GetOptions()->GetBackground8()) ? pPal->GetRGBQuad(ce.GetFore()) : rgbBack;

#ifdef SCALED
				pFontLine = pFont->GetFontLine(ce.character, ptFont.y >> iScale);
#else
				pFontLine = pFont->GetFontLine(ce.character, ptFont.y);
#endif
            }
			ASSERT(pFontLine);

#ifdef SCALED
			RGBQUAD rgb = (pFontLine[ptFont.x >> iScale]) ? rgbFore : rgbBack;
#else
			RGBQUAD rgb = (pFontLine[ptFont.x]) ? rgbFore : rgbBack;
#endif
			if (bInSelection)
			{
				pData[lDatapos++] = 255-rgb.rgbBlue;
				pData[lDatapos++] = 255-rgb.rgbGreen;
				pData[lDatapos++] = 255-rgb.rgbRed;
			}
			else
			{
				pData[lDatapos++] = rgb.rgbBlue;
				pData[lDatapos++] = rgb.rgbGreen;
				pData[lDatapos++] = rgb.rgbRed;
			}

#ifdef SCALED
            ptFont.x+=incrementX;
#else
            ptFont.x++;
#endif
        }

#ifdef SCALED
        ptFont.y+=incrementY;
#else
        ptFont.y++;
#endif        
        if ((int)ptFont.y >= (int)yfont)
        {
            ptFont.y = 0;
            ptCanvas.y++;
            if (ptCanvas.y>=pCanvas->GetSize().cy) break;
        }

    }

#ifdef STRETCHED
    ::StretchDIBits(pDC->GetSafeHdc(), brect.left, brect.top, brect.Width(), brect.Height(), 0,0, rect.Width(), rect.Height(), pData, pBI, DIB_RGB_COLORS, SRCCOPY);
#else
    ::SetDIBitsToDevice(pDC->GetSafeHdc(),brect.left,brect.top,brect.Width(),brect.Height(),0,0,0,rect.Height(),pData,pBI,DIB_RGB_COLORS);
#endif

    delete pBI;
    delete [] pData;

    if (!BlockSelectMode() && !m_bBlinkOn && GetFocus() == this)
    {
        pDC->InvertRect
		    (
			    CRect
				    (
					    CPoint(m_curpoint.x*m_cursorSize.cx,m_curpoint.y*m_cursorSize.cy),
					    CSize(m_cursorSize.cx, m_cursorSize.cy)
				    )
		    );
    }
	if (m_bBlockPasteMode)
	{
		CRect rectPaste(m_rectPaste.left*m_cursorSize.cx, m_rectPaste.top*m_cursorSize.cy,
						m_rectPaste.right*m_cursorSize.cx, m_rectPaste.bottom*m_cursorSize.cy);
		/*CPen pen(PS_SOLID, 0, RGB(100,100,100));
		CPen* pOldPen = pDC->SelectObject(&pen);
		*/
		pDC->DrawFocusRect(rectPaste);
		//pDC->SelectObject(pOldPen);
	}
}

void CCanvasView::UpdateRegion(CRect& rect)
{
    InvalidateRect(CRect(rect.left*m_cursorSize.cx,rect.top*m_cursorSize.cy,
                         rect.right*m_cursorSize.cx,rect.bottom*m_cursorSize.cy) - GetScrollPosition());
}

/////////////////////////////////////////////////////////////////////////////
// CCanvasView diagnostics

#ifdef _DEBUG
void CCanvasView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CCanvasView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCanvasView message handlers

void CCanvasView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
	if (pPage)
	{
		cCanvas* pCanvas = pPage->GetCanvas();
		cFont* pFont = pPage->GetFont();
		cPalette* pPal = pPage->GetPalette();


		m_font.Set(*pFont); 
		//m_font.Scale(CSize((int)(m_font.GetSize().cx*m_dScale),(int)(m_font.GetSize().cy*m_dScale)));
		//m_font.Scale(CSize(9,18));
		m_cursorSize = m_font.GetSize();

		CSize size = pCanvas->GetSize();
		size.cx *= m_cursorSize.cx;
		size.cy *= m_cursorSize.cy;

		SetScrollSizes(MM_TEXT, size, CSize(m_cursorSize.cx*80, m_cursorSize.cy*25), m_cursorSize);
		if (g_bFullScreen) ShowScrollBar(SB_BOTH, FALSE);
			//EnableScrollBar(EnableScrollBarCtrl(SB_BOTH, FALSE);

		SetTimer(ID_BLINK_TIMER, BLINK_TIMER_SPEED, NULL);

	//    SetScrollSizes(MM_TEXT, size, CSize(m_cursorSize.cx*80,m_cursorSize.cy*25), m_cursorSize);

		/*
		LOGPALETTE* plp;

		plp = (LOGPALETTE*)GlobalAlloc(GMEM_FIXED, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * 16);
		plp->palVersion = 0x300;
		plp->palNumEntries = 16;

		for (int i = 0; i<16; i++)
		{
			plp->palPalEntry[i] = pPal->GetPaletteEntry(i);
		}

		m_pal.CreatePalette(plp);
		GlobalFree(plp);
		*/
	}
/*
    m_pBI = (BITMAPINFO*)GlobalAlloc(GMEM_FIXED,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*16);

    m_pBI->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    m_pBI->bmiHeader.biWidth = rect.Width()+1 + (4-((rect.Width()+1)%4));
    m_pBI->bmiHeader.biPlanes = 1;
    m_pBI->bmiHeader.biBitCount = 8;
    m_pBI->bmiHeader.biCompression = BI_RGB;
    m_pBI->bmiHeader.biSizeImage = 0;
    m_pBI->bmiHeader.biXPelsPerMeter = 1;
    m_pBI->bmiHeader.biXPelsPerMeter = 1;
    m_pBI->bmiHeader.biClrUsed = 16;
    m_pBI->bmiHeader.biClrImportant = 16;

    m_pData = (UCHAR*)GlobalAlloc(GMEM_FIXED, (rect.Width()+1)*(rect.Height()+1));
*/
}


void CCanvasView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
    // TODO: Add your specialized code here and/or call the base class


}

void CCanvasView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: Add your specialized code here and/or call the base class

}

BOOL CCanvasView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// TODO: call DoPreparePrinting to invoke the Print dialog box

	return DoPreparePrinting(pInfo);
}

void CCanvasView::OnMoveDown()
{
	CheckShiftSelect();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    if (m_curpoint.y< pCanvas->GetSize().cy-1)
    {
        m_curpoint.y++;
        ScrollToCursor();
		UpdateRegion(CRect(CPoint(m_curpoint.x, m_curpoint.y-1), CSize(1,2)));
		UpdateBlockSelection();
    }
}

void CCanvasView::OnMoveLeft()
{
	CheckShiftSelect();
	// TODO: Add your command handler code here
    if (m_curpoint.x>0)
    {
        m_curpoint.x--;
        ScrollToCursor();
		UpdateRegion(CRect(m_curpoint, CSize(2,1)));
		UpdateBlockSelection();
    }
}

void CCanvasView::OnMoveRight()
{
	CheckShiftSelect();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    if (m_curpoint.x< pCanvas->GetSize().cx-1)
    {
        m_curpoint.x++;
        ScrollToCursor();
		UpdateRegion(CRect(CPoint(m_curpoint.x-1, m_curpoint.y), CSize(2,1)));
		UpdateBlockSelection();
    }
}

void CCanvasView::OnMoveUp()
{
	CheckShiftSelect();
    if (m_curpoint.y>0)
    {
        m_curpoint.y--;
        ScrollToCursor();
		UpdateRegion(CRect(m_curpoint, CSize(1,2)));
		UpdateBlockSelection();
    }
}

void CCanvasView::OnUpdatePos(CCmdUI* pCmdUI)
{
    CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	pCmdUI->Enable();
    CString strPos;
	CPoint pt = m_curpoint;
	if (!pApp->GetOptions()->GetCursorFromZero())
	{
		pt.x++;
		pt.y++;
	}
    strPos.Format( "%d,%d", pt.x, pt.y );
    pCmdUI->SetText( strPos );
}


void CCanvasView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: Add your specialized code here and/or call the base class

	CScrollView::OnPrint(pDC, pInfo);
}

int CCanvasView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
//    if (!m_bufDC.CreateCompatibleDC(GetDC())) return -1;
	CArray<ACCEL> accels;
	accels.Add(sAccel( FVIRTKEY | FSHIFT|FCONTROL|FALT|FNOINVERT, VK_F12		, ID_TOOLS_STARTTYPING		));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_NEXT			, ID_MOVE_CANVAS_END		));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_PRIOR			, ID_MOVE_CANVAS_HOME		));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_UP				, ID_MOVE_UP				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_DOWN			, ID_MOVE_DOWN				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_LEFT			, ID_MOVE_LEFT				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_RIGHT			, ID_MOVE_RIGHT				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_END			, ID_MOVE_LINE_END			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_HOME			, ID_MOVE_LINE_HOME			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_NEXT			, ID_MOVE_PGDN				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_PRIOR			, ID_MOVE_PGUP				));

	// shift versions so that people can be happy!
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_UP				, ID_MOVE_UP				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_DOWN			, ID_MOVE_DOWN				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_LEFT			, ID_MOVE_LEFT				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_RIGHT			, ID_MOVE_RIGHT				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_END			, ID_MOVE_LINE_END			));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_HOME			, ID_MOVE_LINE_HOME			));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_NEXT			, ID_MOVE_PGDN				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_PRIOR			, ID_MOVE_PGUP				));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_BACK			, ID_CHAR_BACKSPACE			));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_RETURN			, ID_MOVE_LINE_NEXT			));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_DELETE			, ID_CHAR_DELETE			));


	if (!m_bSimpleMode)
	{
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, 'M'				, ID_SWITCH_FONT			));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'C'    			, ID_EDIT_COPY      		));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'X'    			, ID_EDIT_CUT           	));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'V'    			, ID_EDIT_PASTE     		));
		accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_INSERT			, ID_EDIT_PASTE     		));
		accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_DELETE			, ID_EDIT_CUT        		));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_INSERT			, ID_EDIT_COPY          	));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'F'				, ID_FILL					));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'B'				, ID_BLOCK					));
	}

	m_hMainAccel = ::CreateAcceleratorTable(accels.GetData(), accels.GetCount());

	accels.RemoveAll();
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'Z'				, ID_EDIT_UNDO				));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, 'Y'				, ID_EDIT_REDO				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F1				, ID_DRAW_CHAR1				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F2				, ID_DRAW_CHAR2				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F3				, ID_DRAW_CHAR3				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F4				, ID_DRAW_CHAR4				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F5				, ID_DRAW_CHAR5				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F6				, ID_DRAW_CHAR6				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F7				, ID_DRAW_CHAR7				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F8				, ID_DRAW_CHAR8				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F9				, ID_DRAW_CHAR9				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F10			, ID_DRAW_CHAR10			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F11			, ID_DRAW_CHAR11			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_F12			, ID_DRAW_CHAR12			));

	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F1				, ID_SET_CHARSET1			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F2				, ID_SET_CHARSET2			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F3				, ID_SET_CHARSET3			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F4				, ID_SET_CHARSET4			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F5				, ID_SET_CHARSET5			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F6				, ID_SET_CHARSET6			));
	accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_F6				, ID_SET_CHARSET6			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F7				, ID_SET_CHARSET7			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F8				, ID_SET_CHARSET8			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F9				, ID_SET_CHARSET9			));
	accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_F10			, ID_SET_CHARSET10			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F1				, ID_SET_CHARSET11			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F2				, ID_SET_CHARSET12			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F3				, ID_SET_CHARSET13			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F4				, ID_SET_CHARSET14			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F5				, ID_SET_CHARSET15			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F6				, ID_SET_CHARSET16			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F7				, ID_SET_CHARSET17			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F8				, ID_SET_CHARSET18			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F9				, ID_SET_CHARSET19			));
	accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_F10			, ID_SET_CHARSET20			));

	if (!m_bSimpleMode)
	{
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_RIGHT			, ID_ATTR_BACK_NEXT			));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_LEFT			, ID_ATTR_BACK_PREV			));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_UP				, ID_ATTR_FORE_NEXT			));
		accels.Add(sAccel( FVIRTKEY | FCONTROL | FNOINVERT		, VK_DOWN			, ID_ATTR_FORE_PREV			));

		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT	 		, 'U'    			, ID_GET_COLOUR    			));
		accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_INSERT			, ID_TOGGLE_INSERT			));
		accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_BACK			, ID_CHAR_BACKSPACE			));
		accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_DELETE			, ID_CHAR_DELETE			));
		accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_RETURN			, ID_MOVE_LINE_NEXT			));

		accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_BACK			, ID_CHAR_BACKSPACE			));
		accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_DELETE			, ID_CHAR_DELETE			));
		accels.Add(sAccel( FVIRTKEY | FSHIFT | FNOINVERT		, VK_RETURN			, ID_MOVE_LINE_NEXT			));

		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_LEFT 			, ID_COLUMN_DELETE 			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_RIGHT			, ID_COLUMN_INSERT 			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_UP				, ID_LINE_DELETE   			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, 'Y'				, ID_LINE_DELETE   			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, VK_DOWN			, ID_LINE_INSERT   			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, 'I'				, ID_LINE_INSERT   			));

		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, 'B'				, ID_BLOCK_SELECT			));
		accels.Add(sAccel( FVIRTKEY | FALT | FNOINVERT			, 'C'				, ID_EDIT_CLEAR				));
	}


	m_hNormalAccel = ::CreateAcceleratorTable(accels.GetData(), accels.GetCount());

	accels.RemoveAll();
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'B'				, ID_BLOCK					));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'D'				, ID_EDIT_DELETE			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'E'				, ID_EDIT_ERASE				));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'F'				, ID_FILL					));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'C'    			, ID_BLOCK_COPY     		));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'M'    			, ID_BLOCK_MOVE     		));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, VK_ESCAPE			, ID_BLOCK_EXIT      		));

	m_hBlockAccel = ::CreateAcceleratorTable(accels.GetData(), accels.GetCount());

	accels.RemoveAll();
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'B'				, ID_BLOCK					));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'T'				, ID_BLOCK_TRANSPARENT		));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'U'				, ID_BLOCK_UNDER			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'O'				, ID_BLOCK_UNDER			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'X'				, ID_BLOCK_FLIPX			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'Y'				, ID_BLOCK_FLIPY			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'R'				, ID_BLOCK_ROTATE			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'B'				, ID_BLOCK					));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'S'				, ID_BLOCK_PASTE			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, 'P'				, ID_BLOCK_PASTE			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, VK_RETURN			, ID_BLOCK_PASTE			));
	accels.Add(sAccel(FVIRTKEY | FNOINVERT		, VK_ESCAPE			, ID_BLOCK_EXIT      		));

	m_hPasteAccel = ::CreateAcceleratorTable(accels.GetData(), accels.GetCount());


	return 0;
}


void CCanvasView::GetEditMenu(cCommandList& p_cl, cMenuItemList& p_items, BOOL p_bBlockPasteMode, BOOL p_bBlockSelectMode)
{
	p_cl.AddTail(cCommand(ID_EDIT_UNDO, 0, 0, 0, FALSE, _T("&Undo")));
	p_cl.AddTail(cCommand(ID_EDIT_REDO, 0, 0, 0, FALSE, _T("&Redo")));
	p_cl.AddTail(cCommand(ID_EDIT_CUT, 0, 0, 0, FALSE, _T("Cu&t to Clipboard")));
	p_cl.AddTail(cCommand(ID_EDIT_COPY, 0, 0, 0, FALSE, _T("&Copy to Clipboard")));
	p_cl.AddTail(cCommand(ID_EDIT_PASTE, 0, 0, 0, FALSE, _T("&Paste from Clipboard")));
	p_cl.AddTail(cCommand(ID_BLOCK_MOVE, 0, 0, 0, FALSE, _T("&Move")));
	p_cl.AddTail(cCommand(ID_BLOCK_COPY, 0, 0, 0, FALSE, _T("C&opy")));
	p_cl.AddTail(cCommand(ID_BLOCK_PASTE, 0, 0, 0, FALSE, _T("P&aste")));

	p_cl.AddTail(cCommand(ID_EDIT_CLEAR, 0, 0, 0, FALSE, _T("C&lear")));


	cMenuItemList sub(&p_cl);
	
	if (!p_bBlockPasteMode && !p_bBlockSelectMode)
	{
		p_items.AddTail(cMenuItem(ID_EDIT_UNDO));
		p_items.AddTail(cMenuItem(ID_EDIT_REDO));
		p_items.AddTail(cMenuItem(MENUID_SEPARATOR));
	}
	p_items.AddTail(cMenuItem(ID_EDIT_CUT));
	p_items.AddTail(cMenuItem(ID_EDIT_COPY));
	if (!p_bBlockPasteMode && !p_bBlockSelectMode) p_items.AddTail(cMenuItem(ID_EDIT_PASTE));
	p_items.AddTail(cMenuItem(MENUID_SEPARATOR));
	p_items.AddTail(cMenuItem(ID_BLOCK_MOVE));
	p_items.AddTail(cMenuItem(ID_BLOCK_COPY));
	if (!p_bBlockPasteMode && !p_bBlockSelectMode) p_items.AddTail(cMenuItem(ID_BLOCK_PASTE));
	p_items.AddTail(cMenuItem(MENUID_SEPARATOR));

	if (p_bBlockPasteMode || p_bBlockSelectMode)
	{
		GetBlockMenu(p_cl, p_items, p_bBlockPasteMode, p_bBlockSelectMode);
	}
	else
	{
		GetBlockMenu(p_cl, sub);
		p_items.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Block\tCtrl+B or B"), &sub));
		p_items.AddTail(cMenuItem(MENUID_SEPARATOR));
		p_items.AddTail(cMenuItem(ID_EDIT_CLEAR));
	}

	p_cl.SetAccelerators(m_hMainAccel, TRUE, TRUE);
	p_cl.SetAccelerators(m_hNormalAccel, TRUE, TRUE);
}



void CCanvasView::GetBlockMenu(cCommandList& p_cl, cMenuItemList& p_items, BOOL p_bBlockPasteMode, BOOL p_bBlockSelectMode)
{
	p_cl.AddTail(cCommand(ID_EDIT_ERASE, 0, 0, 0, FALSE, _T("&Erase")));
	p_cl.AddTail(cCommand(ID_EDIT_DELETE, 0, 0, 0, FALSE, _T("&Delete")));
	p_cl.AddTail(cCommand(ID_BLOCK_ROTATE, 0, 0, 0, FALSE, _T("&Rotate")));
	p_cl.AddTail(cCommand(ID_BLOCK_FLIPX, 0, 0, 0, FALSE, _T("Flip &X")));
	p_cl.AddTail(cCommand(ID_BLOCK_FLIPY, 0, 0, 0, FALSE, _T("Flip &Y")));
	p_cl.AddTail(cCommand(ID_BLOCK_UNDER, 0, 0, 0, FALSE, _T("&Under")));
	p_cl.AddTail(cCommand(ID_BLOCK_TRANSPARENT, 0, 0, 0, FALSE, _T("&Transparent")));
	
	if (!p_bBlockPasteMode)
	{
		cMenuItemList sub(&p_cl);
		GetFillMenu(p_cl, sub);
		p_items.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Fill\tCtrl+F or F"), &sub));

		p_items.AddTail(cMenuItem(ID_EDIT_ERASE));
		p_items.AddTail(cMenuItem(ID_EDIT_DELETE));
	}
	p_items.AddTail(cMenuItem(ID_BLOCK_ROTATE));
	p_items.AddTail(cMenuItem(ID_BLOCK_FLIPX));
	p_items.AddTail(cMenuItem(ID_BLOCK_FLIPY));
	if (!p_bBlockSelectMode)
	{
		p_items.AddTail(cMenuItem(MENUID_SEPARATOR));
		p_items.AddTail(cMenuItem(ID_BLOCK_UNDER));
		p_items.AddTail(cMenuItem(ID_BLOCK_TRANSPARENT));
	}

	p_cl.SetAccelerators(m_hBlockAccel, TRUE, TRUE);
	p_cl.SetAccelerators(m_hPasteAccel, TRUE, TRUE);
}

void CCanvasView::GetFillMenu(cCommandList& p_cl, cMenuItemList& p_items)
{
	p_cl.AddTail(cCommand(ID_FILL_CHARACTER, 0, 0, 0, FALSE, _T("&Character")));
	p_cl.AddTail(cCommand(ID_FILL_ATTRIBUTE, 0, 0, 0, FALSE, _T("&Attribute")));
	p_cl.AddTail(cCommand(ID_FILL_BACKGROUND, 0, 0, 0, FALSE, _T("Bac&kground")));
	p_cl.AddTail(cCommand(ID_FILL_FOREGROUND, 0, 0, 0, FALSE, _T("&Foreground")));
	p_cl.AddTail(cCommand(ID_FILL_BOTH, 0, 0, 0, FALSE, _T("&Both Character && Attribute")));
	
	p_items.AddTail(cMenuItem(ID_FILL_CHARACTER));
	p_items.AddTail(cMenuItem(ID_FILL_ATTRIBUTE));
	p_items.AddTail(cMenuItem(ID_FILL_BACKGROUND));
	p_items.AddTail(cMenuItem(ID_FILL_FOREGROUND));
	p_items.AddTail(cMenuItem(ID_FILL_BOTH));
}

void CCanvasView::OnDestroy()
{
	CScrollView::OnDestroy();

	if (m_hMainAccel != NULL) ::DestroyAcceleratorTable(m_hMainAccel);
	if (m_hNormalAccel != NULL) ::DestroyAcceleratorTable(m_hNormalAccel);
	if (m_hBlockAccel != NULL) ::DestroyAcceleratorTable(m_hBlockAccel);
	if (m_hPasteAccel != NULL) ::DestroyAcceleratorTable(m_hPasteAccel);
}

void CCanvasView::OnSize(UINT nType, int cx, int cy)
{
    CScrollView::OnSize(nType, cx, cy);
	if (g_bFullScreen) ShowScrollBar(SB_BOTH, FALSE);
}

BOOL CCanvasView::OnEraseBkgnd(CDC* pDC)
{
    CBrush br(RGB(0,0,0));
    //CBrush br(GetSysColor(COLOR_WINDOW));
    FillOutsideRect( pDC, &br );
    return TRUE;                   // Erased
}

void CCanvasView::ScrollToCursor()
{
    CRect rect;
    CRect rectCursor = CRect(CPoint(m_curpoint.x*m_cursorSize.cx,m_curpoint.y*m_cursorSize.cy),m_cursorSize);
    GetClientRect(rect);
    CPoint ptScroll = GetScrollPosition();
    rect += ptScroll;
    if (rect.top>rectCursor.top)
    {
        ScrollToPosition(CPoint(ptScroll.x,rectCursor.top));
    }
    else if (rect.bottom<rectCursor.bottom)
    {
        ScrollToPosition(CPoint(ptScroll.x,rectCursor.bottom-rect.Height()));
    }

    if (rect.left>rectCursor.left)
    {
        ScrollToPosition(CPoint(rectCursor.left,ptScroll.y));
    }
    else if (rect.right<rectCursor.right)
    {
        ScrollToPosition(CPoint(rectCursor.right-rect.Width(),ptScroll.y));
    }
	if (g_bFullScreen)
	{
		// update cursor position in full-screen mode
		CMainFrame* pAppFrame = (CMainFrame*) AfxGetApp()->m_pMainWnd;
		pAppFrame->m_wndColour.Update();
	}
	if (m_bCaptureMouse)
	{
		CRect rect;
		GetClientRect(&rect);
		CPoint ptMouse;
		CPoint ptOldMouse;
		GetCursorPos(&ptMouse);
		ScreenToClient(&ptMouse);
		ptOldMouse = ptMouse;
		if (m_ptMouseLast.x != LONG_MAX && m_ptMouseLast.y != LONG_MAX)
		{
			m_bCaptureMouse = FALSE; // prevent endless loop
			BOOL bSetMousePos = FALSE;
			if (ptMouse.y <= rect.top)
			{
				ptMouse.y = rect.top;
				int iDiff = max(ptMouse.y, m_ptMouseLast.y) - min(ptMouse.y, m_ptMouseLast.y);
				ptMouse.y += m_cursorSize.cy-1;
				for (int i=0; i<=iDiff/4; i++)
					OnMoveUp();
				bSetMousePos = TRUE;
			}
			else if (ptMouse.y >= rect.bottom-1)
			{
				ptMouse.y = rect.bottom;
				int iDiff = max(ptMouse.y, m_ptMouseLast.y) - min(ptMouse.y, m_ptMouseLast.y);
				ptMouse.y -= m_cursorSize.cy-1;
				for (int i=0; i<=iDiff/4; i++)
					OnMoveDown();
				bSetMousePos = TRUE;
			}
			if (ptMouse.x <= rect.left)
			{
				ptMouse.x = rect.left;
				int iDiff = max(ptMouse.x, m_ptMouseLast.x) - min(ptMouse.x, m_ptMouseLast.x);
				ptMouse.x += m_cursorSize.cx-1;
				for (int i=0; i<=iDiff/2; i++)
					OnMoveLeft();
				bSetMousePos = TRUE;
			}
			else if (ptMouse.x >= rect.right-1)
			{
				ptMouse.x = rect.right;
				int iDiff = max(ptMouse.x, m_ptMouseLast.x) - min(ptMouse.x, m_ptMouseLast.x);
				ptMouse.x -= m_cursorSize.cx-1;
				for (int i=0; i<=iDiff/2; i++)
					OnMoveRight();
				bSetMousePos = TRUE;
			}
			if (bSetMousePos)
			{
				ClientToScreen(&ptMouse);
				SetCursorPos(ptMouse.x, ptMouse.y);
			}
			m_bCaptureMouse = TRUE;
		}
		m_ptMouseLast = ptOldMouse;

		/*
		
		ptMouse.x = m_curpoint.x*m_cursorSize.cx;
		ptMouse.y = m_curpoint.y*m_cursorSize.cy;
		ptMouse -= GetScrollPosition();
		ClientToScreen(&ptMouse);
		if (m_curpoint.y == rect.top)
		{
			ptMouse.y += m_cursorSize.cy-1;
			if (ptOldMouse != ptMouse) SetCursorPos(ptMouse.x, ptMouse.y);
		}
		if (m_curpoint.y == rect.bottom)
		{
			if (ptOldMouse != ptMouse) SetCursorPos(ptMouse.x, ptMouse.y);
		}
		*/

	}
}

void CCanvasView::OnMovePgdn()
{
	CheckShiftSelect();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CRect rect;
    CPoint pt;
    int iVertSize;
    GetClientRect(rect);
    CPoint ptScroll = GetScrollPosition();

    iVertSize = rect.Height()/m_cursorSize.cy+1;
    if (m_curpoint.y< pCanvas->GetSize().cy-iVertSize-1)
    {
        m_curpoint.y+=iVertSize;
        ScrollToPosition(ptScroll+CSize(0,iVertSize*m_cursorSize.cy));
        ScrollToCursor();
    }
    else
    {
        pt = m_curpoint;
        m_curpoint.y = pCanvas->GetSize().cy-1;
        ScrollToCursor();
		UpdateRegion(CRect(pt, CSize(1,1)));
		UpdateRegion(CRect(m_curpoint, CSize(1,1)));
    }
	UpdateBlockSelection();
}

void CCanvasView::OnMovePgup()
{
	CheckShiftSelect();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CRect rect;
    CPoint pt;
    int iVertSize;
    GetClientRect(rect);

    iVertSize = rect.Height()/m_cursorSize.cy+1;
    if (m_curpoint.y > iVertSize)
    {
        m_curpoint.y-=iVertSize;
        ScrollToPosition(GetScrollPosition()-CSize(0,iVertSize*m_cursorSize.cy));
        ScrollToCursor();
    }
    else
    {
        pt = m_curpoint;
        m_curpoint.y = 0;
        ScrollToCursor();
		UpdateRegion(CRect(pt, CSize(1,1)));
		UpdateRegion(CRect(m_curpoint, CSize(1,1)));
    }
	UpdateBlockSelection();
}

void CCanvasView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	CRect rect;

	if (!m_bBlockSelectMode && !m_bBlockPasteMode)
	{
		pDoc->SetModifiedFlag();
		sCanvasElement ce;
		ce.character = nChar;
		ce.attribute = (UCHAR)pCanvas->GetAttribute();
		BOOL bInsertMode = pApp->GetOptions()->GetInsertMode();


		if (pSocket) pSocket->InsertChar(pCanvas, m_curpoint, ce, bInsertMode);
		else
		{
			if (bInsertMode)
			{
				pPage->SaveCanvas(CRect(CPoint(pCanvas->GetSize().cx-1, m_curpoint.y), CSize(1,1)), m_curpoint, UT_BLOCK, FALSE);
				pPage->SaveCanvas(CRect(m_curpoint, CSize(1,1)), m_curpoint, UT_INSERTCHAR);
			}
			else
				pPage->SaveCanvas(CRect(m_curpoint, CSize(1,1)), m_curpoint, UT_BLOCK);
			if (!bInsertMode || !pSocket) pCanvas->InsertChar(m_curpoint,ce, bInsertMode);
		}

		CRect rectUpdate = (bInsertMode) ? CRect(m_curpoint, CSize(pCanvas->GetSize().cx - m_curpoint.x,1)) : CRect(m_curpoint, CSize(2,1));
		if (m_curpoint.x < pCanvas->GetSize().cx-1)
		{
			m_curpoint.x++;
			ScrollToCursor();
		}
		pDoc->UpdateRegion(rectUpdate);
	}
	CScrollView::OnChar(nChar, nRepCnt, nFlags);
}


LRESULT CCanvasView::OnDoRealize(WPARAM wParam, LPARAM lParam)
{
	ASSERT(wParam != NULL);
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

	CMainFrame* pAppFrame = (CMainFrame*) AfxGetApp()->m_pMainWnd;
	ASSERT_KINDOF(CMainFrame, pAppFrame);
/*
	CClientDC appDC(pAppFrame);
	// All views but one should be a background palette.
	// wParam contains a handle to the active view, so the SelectPalette
	// bForceBackground flag is FALSE only if wParam == m_hWnd (this view)
	CPalette* oldPalette = appDC.SelectPalette(&m_pal, ((HWND)wParam) != m_hWnd);

	if (oldPalette != NULL)
	{
		UINT nColorsChanged = appDC.RealizePalette();
		if (nColorsChanged > 0)
			pDoc->UpdateAllViews(NULL);
		appDC.SelectPalette(oldPalette, TRUE);
	}
	else
	{
		TRACE0("\tSelectPalette failed in CDibView::OnPaletteChanged\n");
	}
*/
	return 0L;
}

void CCanvasView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView)
{
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);

	if (bActivate)
	{
		ASSERT(pActivateView == this);
		SetFocus();
		OnDoRealize((WPARAM)m_hWnd, 0);   // same as SendMessage(WM_DOREALIZE);
	}
}

void CCanvasView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    SCROLLINFO si;

    if (nSBCode == SB_THUMBTRACK)
    {
        GetScrollInfo(SB_HORZ,&si,SIF_TRACKPOS);
		nPos = si.nTrackPos; // set 32-bit track position; parameter is only 16-bit
	}

	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CCanvasView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    SCROLLINFO si;

    if (nSBCode == SB_THUMBTRACK)
    {
        GetScrollInfo(SB_VERT,&si,SIF_TRACKPOS);
		nPos = si.nTrackPos;
	}
	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}



void CCanvasView::OnMoveCanvasEnd()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CPoint pt = m_curpoint;
	CheckShiftSelect();

    m_curpoint.y = pCanvas->GetSize().cy-1;
    ScrollToCursor();
	UpdateRegion(CRect(pt, CSize(1,1)));
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
	UpdateBlockSelection();
}
void CCanvasView::OnMoveCanvasHome()
{
	CheckShiftSelect();
    CPoint pt = m_curpoint;
    m_curpoint.y = 0;
    ScrollToCursor();
	UpdateRegion(CRect(pt, CSize(1,1)));
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
	UpdateBlockSelection();
}
void CCanvasView::OnMoveLineEnd()
{
	CheckShiftSelect();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CPoint pt = m_curpoint;
	
	CRect rect = GetVisibleRect(TRUE);
	rect.right = min(rect.right, pCanvas->GetSize().cx-1);
	m_curpoint.x = (m_curpoint.x == rect.right) ? pCanvas->GetSize().cx-1 : rect.right;
    ScrollToCursor();
	UpdateRegion(CRect(pt, CSize(1,1)));
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
	UpdateBlockSelection();
}
void CCanvasView::OnMoveLineHome()
{
	CheckShiftSelect();
    CPoint  pt = m_curpoint;
	CRect rect = GetVisibleRect(TRUE);
	m_curpoint.x = (m_curpoint.x == rect.left) ? 0 : rect.left;
    ScrollToCursor();

	UpdateRegion(CRect(pt, CSize(1,1)));
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
	UpdateBlockSelection();
}

void CCanvasView::OnCharBackspace()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
    CRect rect;

    if (m_curpoint.x>0)
    {
		m_curpoint.x--;
		BOOL bInsertMode = pApp->GetOptions()->GetInsertMode();
		if (pSocket)
        {
            pSocket->DeleteChar(pCanvas, m_curpoint, bInsertMode);
        }
        else
        {
			pPage->SaveCanvas(CRect(m_curpoint, CSize(1,1)), m_curpoint, bInsertMode ? UT_DELETECHAR : UT_BLOCK);
            pCanvas->DeleteChar(m_curpoint, bInsertMode);
            CSize size(pCanvas->GetSize().cx-m_curpoint.x,1);
            pDoc->UpdateRegion(CRect(m_curpoint,size));
        }
    }
}

void CCanvasView::OnCharDelete()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
    CRect rect;

    pDoc->SetModifiedFlag();
    if (m_curpoint.x < pCanvas->GetSize().cx-1)
    {
        if (pSocket)
        {
            pSocket->DeleteChar(pCanvas, m_curpoint, TRUE);
        }
        else
        {
			pPage->SaveCanvas(CRect(m_curpoint, CSize(1,1)), m_curpoint, UT_DELETECHAR);
            pCanvas->DeleteChar(m_curpoint, TRUE);
            CSize size(pCanvas->GetSize().cx-m_curpoint.x,1);
            pDoc->UpdateRegion(CRect(m_curpoint,size));
        }
    }
}

void CCanvasView::OnDrawChar(UINT nID)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	cOptions* pOptions = pDoc->GetApp()->GetOptions();
	ASSERT(pOptions);
	OnChar(pOptions->GetCharSetChar(pDoc->GetCurrentCharSet(), nID - ID_DRAW_CHAR1), 1, 0);
}


void CCanvasView::OnFileLoad()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    CClientSocket* pSocket = pDoc->GetClientSocket();

	CString strFilter = pDoc->GetApp()->GetFormatString(FMT_LOAD);
    cFileDialog fd(TRUE, NULL, NULL, OFN_NOREADONLYRETURN | OFN_ENABLESIZING, strFilter, GetParentFrame());
    if (fd.DoModal() == IDOK)
    {
		LoadFile(fd.GetPathName());
    }
}

void CCanvasView::LoadFile(LPCTSTR p_tszFileName)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage;
    cCanvas* pCanvas;
    CClientSocket* pSocket = pDoc->GetClientSocket();

	if (pDoc->LoadFile(p_tszFileName))
    {
        pPage = pDoc->GetCurrentPage();
        pCanvas = pPage->GetCanvas();
		pDoc->SendMessage(WM_USER_UPDATE_CANVAS);

        CRect rect = CRect(0, 0, pCanvas->GetSize().cx, pCanvas->FindEndY()+1);

		if (pSocket)
		{
			pSocket->UndoCombine(1);
			pSocket->Clear(pCanvas);
		}
        if (rect.bottom > 0)
        {
            if (pSocket) pSocket->SendPart(pCanvas, rect);
        }

        pDoc->SetModifiedFlag(FALSE);
    }
    else
    {
        MessageBox("Cannot load file!");
    }
}


void CCanvasView::OnMoveLineNext()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CClientSocket* pSocket = pDoc->GetClientSocket();

    CPoint pt = m_curpoint;
    m_curpoint.y++;
    if (m_curpoint.y>=pCanvas->GetSize().cy) m_curpoint.y=pCanvas->GetSize().cy;
	m_curpoint.x = 0;

	if (pApp->GetOptions()->GetInsertMode())
	{
	    pDoc->SetModifiedFlag();
		
	    if (pSocket) pSocket->InsertLine(pCanvas, m_curpoint.y); 
		else
		{
			pPage->SaveCanvas(CRect(CPoint(0,pCanvas->GetSize().cy-1), CSize(pCanvas->GetSize().cx, 1)), m_curpoint, UT_BLOCK, FALSE);
			pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_INSERTLINE);

			pCanvas->InsertLine(m_curpoint.y);
	        pDoc->UpdateRegion(CRect(CPoint(0,0), pCanvas->GetSize()));
		}
	}
    ScrollToCursor();
	UpdateRegion(CRect(pt, CSize(1,1)));
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
}

void CCanvasView::OnToggleInsert()
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	pApp->GetOptions()->SetInsertMode(!pApp->GetOptions()->GetInsertMode());
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
}

void CCanvasView::OnAttrBackNext()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
    cPage* pPage = pDoc->GetCurrentPage();

    cCanvas* pCanvas = pPage->GetCanvas();
	int iMaxColour = (pApp->GetOptions()->GetBackground8()) ? 7 : 15;
	pCanvas->SetBack((pCanvas->GetBack() >= iMaxColour) ? 0 : pCanvas->GetBack()+1);
    GetParentFrame()->SendMessage(WM_USER_UPDATE_COLOUR);
}

void CCanvasView::OnAttrBackPrev()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	int iMaxColour = (pApp->GetOptions()->GetBackground8()) ? 7 : 15;
	pCanvas->SetBack((pCanvas->GetBack() == 0) ? iMaxColour : pCanvas->GetBack()-1);
    GetParentFrame()->SendMessage(WM_USER_UPDATE_COLOUR);
}

void CCanvasView::OnAttrForeNext()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	pCanvas->SetFore((pCanvas->GetFore() == 15) ? 0 : pCanvas->GetFore()+1);
    GetParentFrame()->SendMessage(WM_USER_UPDATE_COLOUR);
}

void CCanvasView::OnAttrForePrev()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	pCanvas->SetFore((pCanvas->GetFore() == 0) ? 15 : pCanvas->GetFore()-1);
    GetParentFrame()->SendMessage(WM_USER_UPDATE_COLOUR);
}


void CCanvasView::ScaleFont(int p_iFontWidth)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cFont* pFont = pPage->GetFont();
    cCanvas* pCanvas = pPage->GetCanvas();

	m_font.Set(*pFont); 
	m_font.Scale(CSize(p_iFontWidth, pFont->GetSize().cy*p_iFontWidth/pFont->GetSize().cx));
	//m_font.Scale(CSize((int)(m_font.GetSize().cx*m_dScale),(int)(m_font.GetSize().cy*m_dScale)));
	m_cursorSize = m_font.GetSize();
    CSize size = pCanvas->GetSize();
    size.cx *= m_cursorSize.cx;
    size.cy *= m_cursorSize.cy;

    GetParentFrame()->SendMessage(WM_USER_UPDATE_CHARSET);

    SetScrollSizes(MM_TEXT, size, CSize(m_cursorSize.cx*80, m_cursorSize.cy*25), m_cursorSize);
	if (g_bFullScreen) ShowScrollBar(SB_BOTH, FALSE); //EnableScrollBarCtrl(SB_BOTH, FALSE);
	pDoc->UpdateRegion(CRect(CPoint(0,0), pCanvas->GetSize()));
	GetParentFrame()->DelayRecalcLayout();
}
void CCanvasView::GetScrollSize(CSize& sizeSb)
{
	sizeSb.SetSize(0,0);

	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
	if (pPage)
	{
		cCanvas* pCanvas = pPage->GetCanvas();
		if (pCanvas)
		{
			sizeSb.SetSize(pCanvas->GetSize().cx*m_cursorSize.cx, pCanvas->GetSize().cy*m_cursorSize.cx);
		}
	}
}

void CCanvasView::OnSwitchFont()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	int iOldWidth = m_font.GetSize().cx;

    cPage* pPage = pDoc->GetCurrentPage();
    cFont* pFont = pPage->GetFont();
    cCanvas* pCanvas = pPage->GetCanvas();

    if (pFont->GetSize().cy == 8)
    {
        pPage->SetFont8x16();
    }
    else
    {
        pPage->SetFont8x8();
    }
	ScaleFont(iOldWidth);
}

void CCanvasView::OnSetCharset(UINT nID)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	pDoc->SetCurrentCharSet(nID - ID_SET_CHARSET1);
    GetParentFrame()->SendMessage(WM_USER_UPDATE_CHARSET);
}

void CCanvasView::CheckShiftSelect()
{
	BOOL bShift = (GetKeyState(VK_SHIFT) & 0x8000) != 0;
	if (bShift && !m_bBlockSelectMode)
	{
		OnBlockSelect();
	}
}

void CCanvasView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();

/*
	BOOL bControl = (GetKeyState(VK_CONTROL) & 0x8000) != 0;
	BOOL bShift = (GetKeyState(VK_SHIFT) & 0x8000) != 0;
	BOOL bAlt = (GetKeyState(VK_MENU) & 0x8000) != 0;

	ACCEL* pAccel = NULL;
	UINT nAccelCount = (sizeof(mainAccels) / sizeof(ACCEL));
	for (UINT nVirt = 0; nVirt<nAccelCount; nVirt++)
	{
		ACCEL& acl = mainAccels[nVirt];
		BOOL bMatch = TRUE;
		//if (bMatch && ((nFlags & 8) == 0) && (acl.fVirt & FCONTROL)) bMatch = FALSE;
		if (bMatch && (bControl != ((acl.fVirt & FCONTROL) != 0))) bMatch = FALSE;
		if (bMatch && (bShift != ((acl.fVirt & FSHIFT) != 0))) bMatch = FALSE;
		if (bMatch && (bAlt != ((acl.fVirt & FALT) != 0))) bMatch = FALSE;
		if (bMatch && acl.key == nChar)
		{
			pAccel = &acl;
			break;
		}
	}

	for (UINT nCount = 0; nCount<nRepCnt; nCount++)
	{
		if (pAccel)
		{
			SendMessage(WM_COMMAND, (WPARAM)pAccel->cmd, (LPARAM)GetSafeHwnd());
			m_bIsAccelerator = TRUE;
		}
	}
*/
	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);

}

void CCanvasView::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// ensure system keys are trapped too
	OnKeyDown(nChar, nRepCnt, nFlags);
	//CScrollView::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

LRESULT CCanvasView::OnAddMessage(WPARAM wparam, LPARAM lparam)
{
	if (IsPreview()) return 0;
	return GetParentFrame()->SendMessage(WM_USER_ADD_MESSAGE, wparam, lparam);
}

LRESULT CCanvasView::OnUserJoined(WPARAM wparam, LPARAM lparam)
{
	if (IsPreview()) return 0;
	return GetParentFrame()->SendMessage(WM_USER_JOINED, wparam, lparam);
}
LRESULT CCanvasView::OnUserParted(WPARAM wparam, LPARAM lparam)
{
	if (IsPreview()) return 0;
	return GetParentFrame()->SendMessage(WM_USER_PARTED, wparam, lparam);
}

LRESULT CCanvasView::OnUpdateCanvas(WPARAM wparam, LPARAM lparam)
{
	switch (wparam)
	{
	case 0:
		{
			CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
			cPage* pPage = pDoc->GetCurrentPage();
			cCanvas* pCanvas = pPage->GetCanvas();
			if (pCanvas)
			{
				CSize size = pCanvas->GetSize();
				size.cx *= m_cursorSize.cx;
				size.cy *= m_cursorSize.cy;

				SetScrollSizes(MM_TEXT, size, CSize(m_cursorSize.cx*80, m_cursorSize.cy*25), m_cursorSize);
				if (g_bFullScreen) ShowScrollBar(SB_BOTH, FALSE); //EnableScrollBarCtrl(SB_BOTH, FALSE);

				GetParentFrame()->DelayRecalcLayout();
			}
		}
		break;
	case 1:
		{
			Invalidate();
		}
		break;
	}
	return 0;
}

void CCanvasView::OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	CScrollView::OnSysChar(nChar, nRepCnt, nFlags);
}



void CCanvasView::OnLButtonDown(UINT nFlags, CPoint point)
{
	if (m_bBlockPasteMode)
	{
		m_curpoint = GetCursorPoint(point + GetScrollPosition());
		UpdateBlockSelection();
		OnEditPaste();
	}
	else if (!m_bSimpleMode)
	{
		CPoint pt = m_curpoint;
		m_curpoint = GetCursorPoint(point + GetScrollPosition());

		OnBlockSelect();
		UpdateRegion(CRect(pt, CSize(1,1)));

		if (!m_bCaptureMouse) SetCapture();
	}
}

void CCanvasView::OnMouseMove(UINT nFlags, CPoint point)
{
	if (m_bBlockPasteMode)
	{
		m_curpoint = GetCursorPoint(point + GetScrollPosition());
		UpdateBlockSelection();
	}
	if (GetCapture() == this)
	{
		if (m_bBlockSelectMode)
		{
			m_curpoint = GetCursorPoint(point + GetScrollPosition());
			UpdateBlockSelection();
		}
		else
		{
			CPoint pt = m_curpoint;
			m_curpoint = GetCursorPoint(point + GetScrollPosition());
			CRect rect = GetVisibleRect(TRUE);
			if (m_curpoint.x < rect.left) m_curpoint.x = rect.left;
			if (m_curpoint.x > rect.right) m_curpoint.x = rect.right;
			if (m_curpoint.y < rect.top) m_curpoint.y = rect.top;
			if (m_curpoint.y > rect.bottom) m_curpoint.y = rect.bottom;

			ScrollToCursor();
			UpdateRegion(CRect(pt, CSize(1,1)));
		}
	}
	CScrollView::OnMouseMove(nFlags, point);
}

void CCanvasView::OnLButtonUp(UINT nFlags, CPoint point)
{
	if (GetCapture() == this)
	{
		if (m_bBlockSelectMode)
		{
			m_curpoint = GetCursorPoint(point + GetScrollPosition());

			if (!m_rectSelected.IsRectEmpty() || m_curpoint != m_ptSelected)
			{
				m_rectSelected.SetRect(m_curpoint, m_ptSelected);
				m_rectSelected.NormalizeRect();
				m_rectSelected.bottom++;
				m_rectSelected.right++;
			}
			if (!m_bCaptureMouse) ReleaseCapture();
			if (m_curpoint == m_ptSelected)
			{
				m_bBlockSelectMode = FALSE;
				m_rectSelected.SetRectEmpty();
			}
		}
	}
	CScrollView::OnLButtonUp(nFlags, point);
}

BOOL CCanvasView::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message >= WM_KEYFIRST && pMsg->message <= WM_KEYLAST)
	{
		// finally, translate the message
		if (m_hMainAccel != NULL &&  ::TranslateAccelerator(m_hWnd, m_hMainAccel, pMsg)) return TRUE;
		if (m_bBlockSelectMode && m_hBlockAccel != NULL &&  ::TranslateAccelerator(m_hWnd, m_hBlockAccel, pMsg)) return TRUE;
		else if (m_bBlockPasteMode && m_hPasteAccel != NULL &&  ::TranslateAccelerator(m_hWnd, m_hPasteAccel, pMsg)) return TRUE;
		else if (m_hNormalAccel != NULL &&  ::TranslateAccelerator(m_hWnd, m_hNormalAccel, pMsg)) return TRUE;
		return FALSE;
	}
	return CScrollView::PreTranslateMessage(pMsg);
}

void CCanvasView::OnUpdateCutCopy(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(BlockSelectMode());
}

UINT g_formatPabloDraw = RegisterClipboardFormat("PABLODRAW_BUFFER");


void CCanvasView::OnEditCopy()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (BlockSelectMode())
    {
		cFormatAnsi		fa;
		CSharedFile		sf(GMEM_DDESHARE|GMEM_MOVEABLE|GMEM_ZEROINIT);
		{
			// do this in a separate block so the archive is destroyed when it goes out of scope
			cArchive_store(ar, &sf);
			ar.WriteSz(m_rectSelected.Size());
			ar.Flush();
		}
		fa.Save(&sf, pCanvas, m_rectSelected, pApp->GetOptions());

		if (OpenClipboard())
		{
			EmptyClipboard();
			SetClipboardData(g_formatPabloDraw, sf.Detach());
//			SetClipboardData(CF_TEXT, sf.Detach());
			CloseClipboard();
		}
		OnBlockExit();
    }
}


void CCanvasView::OnEditCut()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (BlockSelectMode())
    {
		cFormatAnsi		fa;
		CSharedFile		sf(GMEM_DDESHARE|GMEM_MOVEABLE|GMEM_ZEROINIT);
		{
			// do this in a separate block so the archive is destroyed when it goes out of scope
			cArchive_store(ar, &sf);
			ar.WriteSz(m_rectSelected.Size());
			ar.Flush();
		}
		fa.Save(&sf, pCanvas, m_rectSelected, pApp->GetOptions());

		if (OpenClipboard())
		{
			EmptyClipboard();
			SetClipboardData(g_formatPabloDraw, sf.Detach());
//			SetClipboardData(CF_TEXT, sf.Detach());
			CloseClipboard();
		}
        pCanvas->Set(m_rectSelected, 7, 32);
		if (pSocket) pSocket->SendPart(pCanvas, m_rectSelected);
		OnBlockExit();
    }
}

void CCanvasView::OnEditPaste()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (m_bBlockPasteMode)
	{
		if (!m_rectClear.IsRectEmpty())
		{
			if (pSocket) pSocket->Erase(pCanvas, m_rectClear);
			else
			{
				pPage->SaveCanvas(m_rectClear, m_curpoint, UT_BLOCK, FALSE);
				pCanvas->Fill(7, 32, m_rectClear);
				pDoc->UpdateRegion(m_rectClear);
			}
			m_rectClear.SetRectEmpty();
		}
		CSize size = pApp->GetBuffer()->GetSize();
		if (!pSocket) pPage->SaveCanvas(CRect(m_curpoint, size), m_curpoint);
		pCanvas->Set(CPoint(0,0), pApp->GetBuffer(), m_curpoint, size, pApp->GetOptions(), m_bPasteUnder, m_bPasteTransparent);
		
		if (pSocket) pSocket->SendPart(pApp->GetBuffer(), CRect(CPoint(0,0), size), m_curpoint);
		pDoc->UpdateRegion(CRect(m_curpoint, size));
		pApp->SetBuffer(NULL);
		m_bBlockPasteMode = FALSE;
	}
	else if (OpenClipboard())
	{
		if (IsClipboardFormatAvailable(g_formatPabloDraw))
//		if (IsClipboardFormatAvailable(CF_TEXT))
		{
			HGLOBAL hmem = GetClipboardData(g_formatPabloDraw);
//			HGLOBAL hmem = GetClipboardData(CF_TEXT);
			CMemFile sf((BYTE*) ::GlobalLock(hmem), ::GlobalSize(hmem));
			CSize size;
			{
				cArchive_load(ar, &sf);
				size = ar.ReadSz();
			}
			if (!pSocket) pPage->SaveCanvas(CRect(m_curpoint, size), m_curpoint, UT_BLOCK);

			cFormatAnsi fa;
			fa.Load(&sf, pCanvas, CRect(m_curpoint, size), pApp->GetOptions());

		
			if (pSocket) pSocket->SendPart(pCanvas, CRect(m_curpoint, size));
			pDoc->UpdateRegion(CRect(m_curpoint, size));

			::GlobalUnlock(hmem);
		}
		CloseClipboard();
	}


/*
    if (pApp->GetBuffer())
    {
		CSize size = pApp->GetBuffer()->GetSize();
        pCanvas->Set(CPoint(0,0), pApp->GetBuffer(), m_curpoint, size);
		if (pSocket) pSocket->SendPart(pCanvas, CRect(m_curpoint, size));
		pDoc->UpdateRegion(CRect(m_curpoint, size));
    }
*/
}


void CCanvasView::OnColumnDelete()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();

	if (pSocket)
	{
		pSocket->DeleteColumn(pCanvas, m_curpoint.x);
	}
	else
	{
		pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_DELETECOL);
		pCanvas->DeleteColumn(m_curpoint.x);
		pDoc->UpdateRegion(CRect(m_curpoint.x, 0, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
	}
}

void CCanvasView::OnColumnInsert()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();

	int iEndY = pCanvas->FindEndY();
	if (iEndY < 0) iEndY = 0;
	if (pSocket)
	{
		pSocket->InsertColumn(pCanvas, m_curpoint.x);
	}
	else
	{
		pPage->SaveCanvas(CRect(CPoint(pCanvas->GetSize().cx-1, 0), CSize(1, iEndY)), m_curpoint, UT_BLOCK, FALSE);
		pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_INSERTCOL);

		pCanvas->InsertColumn(m_curpoint.x);
		pDoc->UpdateRegion(CRect(m_curpoint.x, 0, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
	}
}

void CCanvasView::OnLineDelete()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();

	if (pSocket)
	{
		pSocket->DeleteLine(pCanvas, m_curpoint.y);
	}
	else
	{
		pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_DELETELINE);
		pCanvas->DeleteLine(m_curpoint.y);
		pDoc->UpdateRegion(CRect(0, m_curpoint.y, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
	}
}

void CCanvasView::OnLineInsert()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();

	if (pSocket)
	{
		pSocket->InsertLine(pCanvas, m_curpoint.y);
	}
	else
	{
		pPage->SaveCanvas(CRect(CPoint(0,pCanvas->GetSize().cy-1), CSize(pCanvas->GetSize().cx, 1)), m_curpoint, UT_BLOCK, FALSE);
		pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_INSERTLINE);
		pCanvas->InsertLine(m_curpoint.y);
		pDoc->UpdateRegion(CRect(0, m_curpoint.y, pCanvas->GetSize().cx, pCanvas->GetSize().cy));
	}
}
void CCanvasView::OnGetColour()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();
	pCanvas->SetAttribute(pCanvas->GetAttr(m_curpoint));
    GetParentFrame()->SendMessage(WM_USER_UPDATE_COLOUR);
}

void CCanvasView::OnKillFocus(CWnd* pNewWnd)
{
	CScrollView::OnKillFocus(pNewWnd);
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
}

void CCanvasView::OnSetFocus(CWnd* pOldWnd)
{
	CScrollView::OnSetFocus(pOldWnd);
	if (m_bCaptureMouse)
	{
		SetCapture();
		SetCursor(NULL);
	}
	UpdateRegion(CRect(m_curpoint, CSize(1,1)));
}

LRESULT CCanvasView::OnFullScreenSwitch(WPARAM wParam, LPARAM lParam)
{
	if (!m_bIsPreview)
	{
		switch (lParam)
		{
		case 1:
			m_ptMouseLast = CPoint(LONG_MAX,LONG_MAX);
			m_bCaptureMouse = TRUE;
			SetCapture();
			SetCursor(NULL);
			break;
		case 2:
			m_bCaptureMouse = FALSE;
			ReleaseCapture();
			SetCursor(::LoadCursor(NULL, IDC_IBEAM));
			break;
		}
	}
	BOOL bFullScreen = (BOOL)wParam;
	if (bFullScreen)
	{
		ModifyStyle(WS_VSCROLL|WS_HSCROLL, 0);
		if (!m_bIsPreview) ModifyStyleEx(WS_EX_CLIENTEDGE, 0);
	}
	else
	{
		ModifyStyle(0, WS_VSCROLL|WS_HSCROLL);
		if (!m_bIsPreview) ModifyStyleEx(0, WS_EX_CLIENTEDGE);
	}
	return 0;
}

void CCanvasView::OnTimer(UINT nIDEvent)
{
	if (nIDEvent == ID_BLINK_TIMER)
	{
		CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
		m_bBlinkOn = !m_bBlinkOn;
		if (!m_bIsPreview && pApp->GetOptions()->GetBackground8())
		{
			CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
			cPage* pPage = pDoc->GetCurrentPage();
			if (pPage)
			{
				cCanvas* pCanvas = pPage->GetCanvas();

				CRect rect = GetVisibleRect();

				CPoint pt;
				for (pt.y = rect.top; pt.y<rect.bottom; pt.y++)
				{
					for (pt.x = rect.left; pt.x<rect.right; pt.x++)
					{
						if (pCanvas->GetBack(pt) >= 8)
						{
							UpdateRegion(CRect(pt, CSize(1,1)));
						}
					}
				}
			}
		}
		UpdateRegion(CRect(m_curpoint, CSize(1,1)));
		SetTimer(ID_BLINK_TIMER, BLINK_TIMER_SPEED, NULL);
		
	}
	if (nIDEvent == ID_TYPE_TIMER)
	{
		CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
		cPage* pPage = pDoc->GetCurrentPage();
		if (pPage)
		{
			cCanvas* pCanvas = pPage->GetCanvas();

			if (m_curpoint.x == pCanvas->GetSize().cx-1)
			{
				m_curpoint.x = 0;
				m_curpoint.y++;
			}
			OnChar(rand()%255, 1, 0);
		}
		SetTimer(ID_TYPE_TIMER, 50, NULL);
	}

	CScrollView::OnTimer(nIDEvent);
}


void CCanvasView::OnBlockSelect()
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
	cPage* pPage = pDoc->GetCurrentPage();
	cCanvas* pCanvas = pPage->GetCanvas();

	if (BlockSelectMode())
	{
		UpdateRegion(m_rectSelected);
	}

	m_bBlockSelectMode = TRUE;
	m_ptSelected = m_curpoint;
	ScrollToCursor();

	m_rectSelected = CRect(m_curpoint, CSize(1,1));

	UpdateRegion(m_rectSelected);
}

void CCanvasView::OnBlockExit()
{
    CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

	if (m_bBlockPasteMode)
	{
		m_bBlockPasteMode = FALSE;
		CRect rectOldClear = m_rectClear;
		CRect rectOldPaste = m_rectPaste;
		m_curpoint = m_ptSelected;
		m_rectPaste.SetRectEmpty();
		m_rectClear.SetRectEmpty();
		pApp->SetBuffer(NULL);
		pDoc->UpdateRegion(rectOldClear);
		pDoc->UpdateRegion(rectOldPaste);
		ScrollToCursor();
	}
	else if (BlockSelectMode())
	{
		m_bBlockSelectMode = FALSE;
		CRect rectOld = m_rectSelected;
		m_rectSelected.SetRectEmpty();
		m_curpoint = m_ptSelected;
		pDoc->UpdateRegion(rectOld);
		ScrollToCursor();
	}
}


void CCanvasView::OnFill()
{
	cCommandList cl;
	cMenuItemList ml(&cl);
	GetFillMenu(cl, ml);
	cMenu menu;
	menu.CreatePopupMenu();
	menu.AddMenu(&ml);

	CPoint ptCursor = CPoint((m_curpoint.x+1)*m_cursorSize.cx,m_curpoint.y*m_cursorSize.cy);
	ptCursor -= GetScrollPosition();
	ClientToScreen(&ptCursor);

	menu.TrackPopupMenu(TPM_LEFTALIGN, ptCursor.x, ptCursor.y, this);
	OnSetFocus(NULL);
}

void CCanvasView::OnFillAttribute()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	
	if (pSocket) pSocket->FillAttr(pCanvas, m_rectSelected, (UCHAR)pCanvas->GetAttribute());
	else
	{	
		pPage->SaveCanvas(m_rectSelected, m_curpoint);
		pCanvas->FillAttr(pCanvas->GetAttribute(), m_rectSelected);
		pDoc->UpdateRegion(m_rectSelected);
	}
	OnBlockExit();
}

void CCanvasView::OnFillBacgroundonly()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	
	if (pSocket) pSocket->FillBack(pCanvas, m_rectSelected, pCanvas->GetBack());
	else
	{	
		pPage->SaveCanvas(m_rectSelected, m_curpoint);
		pCanvas->FillBack(pCanvas->GetBack(), m_rectSelected);
		pDoc->UpdateRegion(m_rectSelected);
	}
	OnBlockExit();
}

void CCanvasView::OnFillBothcharacterattribute()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();

	ReleaseCapture();
	CCharSelectDialog cd;
	if (cd.DoModal() == IDOK)
	{
		if (pSocket)
		{
			pSocket->UndoCombine(1);
			pSocket->FillAttr(pCanvas, m_rectSelected, (UCHAR)pCanvas->GetAttribute());
			pSocket->FillChar(pCanvas, m_rectSelected, cd.GetCanvasElement().character);
		}
		else
		{	
			pPage->SaveCanvas(m_rectSelected, m_curpoint);
			pCanvas->Fill(pCanvas->GetAttribute(), cd.GetCanvasElement().character, m_rectSelected);
			pDoc->UpdateRegion(m_rectSelected);
		}
		OnBlockExit();
	}
}

void CCanvasView::OnFillCharacter()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();

	ReleaseCapture();
	CCharSelectDialog cd;
	if (cd.DoModal() == IDOK)
	{
		if (pSocket) pSocket->FillChar(pCanvas, m_rectSelected, cd.GetCanvasElement().character);
		else
		{	
			pPage->SaveCanvas(m_rectSelected, m_curpoint);
			pCanvas->FillChar(cd.GetCanvasElement().character, m_rectSelected);
			pDoc->UpdateRegion(m_rectSelected);
		}
		OnBlockExit();
	}
}

void CCanvasView::OnFillForeground()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	
	if (pSocket) pSocket->FillFore(pCanvas, m_rectSelected, pCanvas->GetFore());
	else
	{	
		pPage->SaveCanvas(m_rectSelected, m_curpoint);
		pCanvas->FillFore(pCanvas->GetFore(), m_rectSelected);
		pDoc->UpdateRegion(m_rectSelected);
	}
	OnBlockExit();
}

void CCanvasView::UpdateBlockSelection()
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	if (BlockSelectMode())
	{
		CRect rectOldSelected = m_rectSelected;
		ScrollToCursor();
		m_rectSelected.SetRect(m_curpoint, m_ptSelected);
		m_rectSelected.NormalizeRect();
		m_rectSelected.bottom++;
		m_rectSelected.right++;

		UpdateRegion(rectOldSelected);
		UpdateRegion(m_rectSelected);
	}
	if (m_bBlockPasteMode)
	{
		CRect rectOldPaste = m_rectPaste;
		ScrollToCursor();
		m_rectPaste = CRect(m_curpoint, pApp->GetBuffer()->GetSize());

		UpdateRegion(rectOldPaste);
		UpdateRegion(m_rectPaste);
	}
}
void CCanvasView::OnToolsStarttyping()
{
	m_bIsTyping = !m_bIsTyping;
	if (m_bIsTyping) SetTimer(ID_TYPE_TIMER, 50, NULL);
	else KillTimer(ID_TYPE_TIMER);
	
}

UINT CCanvasView::OnGetDlgCode()
{
	return DLGC_WANTCHARS;
}

void CCanvasView::OnEditDelete()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();
	
	CRect rectSave = m_rectSelected;
	rectSave.right = pCanvas->GetSize().cx;
	if (pSocket) pSocket->Delete(pCanvas, m_rectSelected);
	else
	{
		pPage->SaveCanvas(rectSave, m_curpoint);
		pCanvas->Delete(m_rectSelected);
		CRect rectUpdate = m_rectSelected;
		rectUpdate.left = 0;
		rectUpdate.right = pCanvas->GetSize().cx;
		pDoc->UpdateRegion(rectUpdate);
	}
	OnBlockExit();
}

void CCanvasView::OnEditErase()
{
	if (m_rectSelected.IsRectEmpty()) return;
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();

	if (pSocket) pSocket->Erase(pCanvas, m_rectSelected);
	else
	{
		pPage->SaveCanvas(m_rectSelected, m_curpoint);
		pCanvas->Fill(7, 32, m_rectSelected);
		pDoc->UpdateRegion(m_rectSelected);
	}
	OnBlockExit();
}

void CCanvasView::OnEditClear()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
    CClientSocket* pSocket = pDoc->GetClientSocket();

	if (MessageBox(_T("Are you sure you want to clear the canvas?"), NULL, MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2) == IDYES)
	{
		if (pSocket) pSocket->Clear(pCanvas);
		else
		{
			pPage->SaveCanvas(CRect(0,0,0,0), m_curpoint, UT_CLEAR);
			pCanvas->Fill(7, 32);
			pDoc->UpdateRegion(CRect(CPoint(0,0), pCanvas->GetSize()));
		}
	}
}

CRect CCanvasView::GetVisibleRect(BOOL p_bUseReal)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    cPage* pPage = pDoc->GetCurrentPage();
	CRect rect;
	GetClientRect(rect);
	CPoint ptScroll = GetScrollPosition();
	rect += ptScroll;
	rect.NormalizeRect();
	if (p_bUseReal)
	{
		rect.bottom--;
		rect.right--;
	}
	rect.top /= m_cursorSize.cy;
	rect.bottom /= m_cursorSize.cy;
	rect.left /= m_cursorSize.cx;
	rect.right /= m_cursorSize.cx;

	if (!p_bUseReal)
	{
		rect.bottom++;
		rect.right++;
	}

	if (pPage)
	{
		cCanvas* pCanvas = pPage->GetCanvas();
		rect.bottom = min(rect.bottom, pCanvas->GetSize().cy);
		rect.right = min(rect.right, pCanvas->GetSize().cx);
	}
	return rect;
}

BOOL CCanvasView::OnProcessCommand(UINT nID)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	switch (nID)
	{
	case ID_EDIT_UNDO:
		{
			if (pSocket) {} //pSocket->Undo(pCanvas);
			else
			{
				CPoint ptOld = m_curpoint;
				CRectArray arrRect;
				pPage->Undo(arrRect, m_curpoint);
				pDoc->UpdateRegion(arrRect);
				pDoc->UpdateRegion(CRect(ptOld, CSize(1,1)));
				pDoc->UpdateRegion(CRect(m_curpoint, CSize(1,1)));
			}
		}
		break;
	case ID_EDIT_REDO:
		{
			if (pSocket) {} //pSocket->Redo(pCanvas);
			else
			{
				CPoint ptOld = m_curpoint;
				CRectArray arrRect;
				pPage->Redo(arrRect, m_curpoint);
				pDoc->UpdateRegion(arrRect);
				pDoc->UpdateRegion(CRect(ptOld, CSize(1,1)));
				pDoc->UpdateRegion(CRect(m_curpoint, CSize(1,1)));
			}
		}
		break;
	case ID_BLOCK_MOVE:
	case ID_BLOCK_COPY:
		if (BlockSelectMode())
		{
			if (nID == ID_BLOCK_MOVE) m_rectClear = m_rectSelected;
			m_rectPaste = m_rectSelected;
			cMemCanvas* pmc = new cMemCanvas(m_rectSelected.Size());
			pmc->Set(m_rectSelected.TopLeft(), pCanvas, CPoint(0,0), m_rectSelected.Size());
			pApp->SetBuffer(pmc);
			OnBlockExit();
			m_ptSelected = m_curpoint;
			m_bBlockPasteMode = TRUE;
			m_bPasteUnder = FALSE;
			m_bPasteTransparent = FALSE;
		}
		return TRUE;
	}
	return FALSE;
}
void CCanvasView::OnUpdateCommand(CCmdUI *pCmdUI)
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	switch (pCmdUI->m_nID)
	{
	case ID_EDIT_REDO:
		pCmdUI->Enable((pSocket || pPage->CanRedo()) && !m_bBlockSelectMode && !m_bBlockPasteMode);
		break;
	case ID_EDIT_UNDO:
		pCmdUI->Enable((pSocket || pPage->CanUndo()) && !m_bBlockSelectMode && !m_bBlockPasteMode);
		break;
	}
}

CPoint CCanvasView::GetCursorPoint(CPoint p_ptPixelOffset)
{
	CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();

	CPoint ptCanvas = CPoint(p_ptPixelOffset.x/m_cursorSize.cx,p_ptPixelOffset.y/m_cursorSize.cy);

	cPage* pPage = pDoc->GetCurrentPage();
	if (pPage)
	{
		cCanvas* pCanvas = pPage->GetCanvas();

		if (ptCanvas.x > pCanvas->GetSize().cx-1) ptCanvas.x = pCanvas->GetSize().cx-1;
		if (ptCanvas.y > pCanvas->GetSize().cy-1) ptCanvas.y = pCanvas->GetSize().cy-1;
		if (ptCanvas.x < 0) ptCanvas.x = 0;
		if (ptCanvas.y < 0) ptCanvas.y = 0;
	}
	return ptCanvas;
}

void CCanvasView::OnUpdateBlockPaste(CCmdUI *pCmdUI)
{
	BOOL bClipboardAvailable = FALSE;
	if (OpenClipboard())
	{
		bClipboardAvailable = IsClipboardFormatAvailable(g_formatPabloDraw);
		CloseClipboard();
	}
	BOOL bEnable = FALSE;
	switch (pCmdUI->m_nID)
	{
	case ID_EDIT_PASTE:
		bEnable = bClipboardAvailable;
		break;
	case ID_BLOCK_ROTATE:
	case ID_BLOCK_FLIPX:
	case ID_BLOCK_FLIPY:
		bEnable = m_bBlockSelectMode || m_bBlockPasteMode;
		break;
	case ID_BLOCK_PASTE:
	case ID_BLOCK_TRANSPARENT:
	case ID_BLOCK_UNDER:
		bEnable = m_bBlockPasteMode;
		break;
	}
	pCmdUI->Enable(bEnable);
}

void CCanvasView::OnBlockRotate()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (m_bBlockPasteMode)
	{
		pApp->GetBuffer()->Rotate();
		UpdateRegion(m_rectPaste);
	}
	else if (m_bBlockSelectMode)
	{
		cMemCanvas mc(m_rectSelected.Size());
		mc.Set(m_rectSelected.TopLeft(), pCanvas, CPoint(0,0), m_rectSelected.Size());
		mc.Rotate();
		if (pSocket) pSocket->SendPart(&mc, CRect(CPoint(0,0), mc.GetSize()), m_rectSelected.TopLeft());
		else
		{
			pCanvas->Set(CPoint(0,0), &mc, m_rectSelected.TopLeft(), mc.GetSize());
		}
		OnBlockExit();
	}
}

void CCanvasView::OnBlockFlipx()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (m_bBlockPasteMode)
	{
		pApp->GetBuffer()->FlipX();
		UpdateRegion(m_rectPaste);
	}
	else if (m_bBlockSelectMode)
	{
		cMemCanvas mc(m_rectSelected.Size());
		mc.Set(m_rectSelected.TopLeft(), pCanvas, CPoint(0,0), m_rectSelected.Size());
		mc.FlipX();
		if (pSocket) pSocket->SendPart(&mc, CRect(CPoint(0,0), mc.GetSize()), m_rectSelected.TopLeft());
		else
		{
			pCanvas->Set(CPoint(0,0), &mc, m_rectSelected.TopLeft(), mc.GetSize());
		}
		OnBlockExit();
	}
}

void CCanvasView::OnBlockFlipy()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)GetDocument();
    CClientSocket* pSocket = pDoc->GetClientSocket();

    cPage* pPage = pDoc->GetCurrentPage();
    cCanvas* pCanvas = pPage->GetCanvas();
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	if (m_bBlockPasteMode)
	{
		pApp->GetBuffer()->FlipY();
		UpdateRegion(m_rectPaste);
	}
	else if (m_bBlockSelectMode)
	{
		cMemCanvas mc(m_rectSelected.Size());
		mc.Set(m_rectSelected.TopLeft(), pCanvas, CPoint(0,0), m_rectSelected.Size());
		mc.FlipY();
		if (pSocket) pSocket->SendPart(&mc, CRect(CPoint(0,0), mc.GetSize()), m_rectSelected.TopLeft());
		else
		{
			pCanvas->Set(CPoint(0,0), &mc, m_rectSelected.TopLeft(), mc.GetSize());
		}
		OnBlockExit();
	}
}

void CCanvasView::OnBlock()
{
	cCommandList cl;
	cMenuItemList ml(&cl);
	if (m_bBlockSelectMode)	GetEditMenu(cl, ml, m_bBlockPasteMode, m_bBlockSelectMode);
	else GetBlockMenu(cl, ml, m_bBlockPasteMode, m_bBlockSelectMode);
	cMenu menu;
	menu.CreatePopupMenu();
	menu.AddMenu(&ml);

	CPoint ptCursor = CPoint((m_curpoint.x+1)*m_cursorSize.cx,m_curpoint.y*m_cursorSize.cy);
	ptCursor -= GetScrollPosition();
	ClientToScreen(&ptCursor);

	menu.TrackPopupMenu(TPM_LEFTALIGN, ptCursor.x, ptCursor.y, this);
	OnSetFocus(NULL);
}

void CCanvasView::OnBlockTransparent()
{
	m_bPasteTransparent = !m_bPasteTransparent;
	UpdateRegion(m_rectPaste);
}

void CCanvasView::OnBlockUnder()
{
	m_bPasteUnder = !m_bPasteUnder;
	UpdateRegion(m_rectPaste);
}

void CCanvasView::OnRButtonDown(UINT nFlags, CPoint point)
{
	if (m_bBlockSelectMode || m_bBlockPasteMode)
	{
		OnBlockExit();
	}
	CScrollView::OnRButtonDown(nFlags, point);
}

