
#include "stdafx.h"
#include "cPage.h"
#include <stdlib.h>
#include "resource.h"


cPage::cPage(cOptions* p_pOptions, CSize p_size, cFont* p_pFont, cPalette* p_pPalette)
{
    CSize size = (p_size == CSize(0,0)) ? p_pOptions->GetDefaultSize() : p_size;
    m_pCanvas = new cMemCanvas(size);

    m_pFont = new cFont();
    SetFont8x16();
	m_bUndoing = false;
   
/*    
    char path_buffer[_MAX_PATH];
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];

    m_pFont = new cFont(CSize(8,16));
    CFile file;
   _splitpath( AfxGetApp()->m_pszHelpFilePath , drive, dir, fname, ext );
   _fullpath( dir, dir, _MAX_DIR );
   _splitpath( dir, drive, dir, fname, ext );
   _makepath( path_buffer, drive, dir, "font", "fnt" );
    if (file.Open(path_buffer,CFile::modeRead))
    {
        m_pFont->Load(file);
        file.Close();
    }
*/
    m_pPalette = new cPalette;
    m_pPalette->SetSystemDefault();
	m_posUndo = NULL;

}

cPage::~cPage()
{
    if (m_pCanvas) delete m_pCanvas;
    if (m_pFont) delete m_pFont;
    if (m_pPalette) delete m_pPalette;
}


BOOL cPage::SetFont8x8()
{
    HRSRC hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_FONT8x8), "RasterFont");
    if (hrsrc)
    {
        HGLOBAL hglobal = LoadResource(NULL, hrsrc);
        if (hglobal)
        {
            int iResourceSize = SizeofResource(NULL, hrsrc);
            LPVOID buf = LockResource(hglobal);
            CMemFile file((unsigned char*)buf, iResourceSize);

            m_pFont->Load(file);
//            m_pFont->Scale(CSize(2,2));//CSize(9,16));
            file.Close();

        }
    }
    return TRUE;
}

BOOL cPage::SetFont8x16()
{
    HRSRC hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_FONT8x16), "RasterFont");
    if (hrsrc)
    {
        HGLOBAL hglobal = LoadResource(NULL, hrsrc);
        if (hglobal)
        {
            int iResourceSize = SizeofResource(NULL, hrsrc);
            LPVOID buf = LockResource(hglobal);
            CMemFile file((unsigned char*)buf, iResourceSize);

            m_pFont->Load(file);
//			double dScale = 1.0;
//            m_pFont->Scale(CSize((int)(8*dScale),(int)(16*dScale)));//CSize(9,16));
            file.Close();

        }
    }
    return TRUE;
}



void cPage::SaveCanvas(CRect p_rect, CPoint p_ptCursor, eUndoType p_UndoType, BOOL p_bNewLevel)
{
	if (!m_bUndoing)
	{
		while (m_posUndo && m_posUndo != m_listUndo.GetTailPosition())
			m_listUndo.RemoveTail();
		cUndoState us(m_pCanvas, p_rect, p_ptCursor, p_UndoType, p_bNewLevel);
		m_listUndo.AddTail(us);

		while (m_listUndo.GetCount() > MAX_UNDOLEVELS) // ensure we don't store TOO much
			m_listUndo.RemoveHead();
		m_posUndo = m_listUndo.GetTailPosition();
	}
}

void cPage::UpdateUndoBuffer(CPoint p_ptCursor, eUndoType p_enUndoType)
{
	POSITION pos = m_listUndo.GetHeadPosition();
	while (pos)
	{
		cUndoState& us = m_listUndo.GetAt(pos);
		switch (p_enUndoType)
		{
		case UT_INSERTLINE:
			if (p_ptCursor.y >= us.GetSaveRect().top &&
				p_ptCursor.y < us.GetSaveRect().bottom)
			{
				cUndoState nus(us);
				int iDiff = p_ptCursor.y - us.GetSaveRect().top;
				nus.DeleteLines(p_ptCursor.y, us.GetSaveRect().Height()-iDiff);
				us.DeleteLines(0, iDiff+1);
				m_listUndo.InsertBefore(pos, nus);
			}
			else 
			{
				us.InsertLines(p_ptCursor.y, 1);
			}
			break;
		case UT_DELETELINE:
			break;
		}
		m_listUndo.GetNext(pos);
	}
}


void cPage::Undo(CRectArray& p_arrRect, CPoint& p_ptCursor, CListeningSocket* p_pSocket)
{
	m_bUndoing = true;
	BOOL bDone = FALSE;
	while (m_posUndo && !bDone)
	{
		cUndoState& us = m_listUndo.GetPrev(m_posUndo);
		us.Undo(m_pCanvas, p_pSocket);
		p_ptCursor = us.GetCursor();
		p_arrRect.Add(us.GetUpdateRect());
		bDone = TRUE;
		if (m_posUndo)
		{
			cUndoState& next = m_listUndo.GetAt(m_posUndo);
			if (!next.IsEndState()) bDone = FALSE;
		}
	}
	m_bUndoing = false;
}
void cPage::Redo(CRectArray& p_arrRect, CPoint& p_ptCursor, CListeningSocket* p_pSocket)
{
	m_bUndoing = true;
	if (m_posUndo != m_listUndo.GetTailPosition())
	{
		if (!m_posUndo) m_posUndo = m_listUndo.GetHeadPosition(); else m_listUndo.GetNext(m_posUndo);
		BOOL bDone = FALSE;
		while (m_posUndo && !bDone)
		{
			cUndoState& us = m_listUndo.GetAt(m_posUndo);
			us.Redo(m_pCanvas, p_pSocket);
			p_ptCursor = us.GetCursor();
			p_arrRect.Add(us.GetUpdateRect());
			if (us.IsEndState()) bDone = TRUE;
			else m_listUndo.GetNext(m_posUndo);
		}
		if (!m_posUndo) m_posUndo = m_listUndo.GetTailPosition();
	}
	m_bUndoing = false;
}
