

#include "stdafx.h"
#include "cformat.h"


cFormat::cFormat(LPCTSTR p_tszFormatName, tFormatSupportFlags p_flags)
{
    m_strFormatName = p_tszFormatName;
    m_flags = p_flags;
}

cFormat::~cFormat()
{
    
}


BOOL cFormat::IsProperFormat(LPCTSTR p_tszExtension, fFormatMapType p_formatType)
{
	POSITION pos = m_formatMaps.GetHeadPosition();
	while (pos)
	{
		sFormatMap& fm = m_formatMaps.GetNext(pos);
		if (
			(fm.strExtension.CompareNoCase(p_tszExtension) == 0) &&
			((fm.type & p_formatType) != 0)
			)
		{
			return TRUE;
		}
	}
	return FALSE;
}

void cFormat::AddFormatMap(int type, CString strDescription, CString strExtension)
{
	sFormatMap fm;
	fm.strDescription = strDescription;
	fm.strExtension = strExtension;
	fm.type = type;
	m_formatMaps.AddTail(fm);
}
