// cArchive.h: interface for the cArchive class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CARCHIVE_H__918E2068_109A_4300_B44B_C9C01E302D8D__INCLUDED_)
#define AFX_CARCHIVE_H__918E2068_109A_4300_B44B_C9C01E302D8D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//#define USE_MFC_ARCHIVE


#ifdef USE_MFC_ARCHIVE


class cArchive : public CArchive
{
public:
	cArchive(CFile* pFile, UINT nMode, int nBufSize = 4096, void* lpBuf = 0)
		: CArchive(pFile, nMode, nBufSize, lpBuf)
	{
		m_bIsEOF = FALSE;
	}
    inline UCHAR Readuc()
	{
		UCHAR ucValue;
		if (Read(&ucValue, sizeof(UCHAR)) != sizeof(UCHAR)) m_bIsEOF = TRUE;
		return ucValue;
	}

    inline CHAR Readc()
	{
		CHAR cValue;
		if (Read(&cValue, sizeof(CHAR)) != sizeof(CHAR)) m_bIsEOF = TRUE;
		return cValue;
	}

    inline USHORT Readus()
	{
		USHORT usValue;
		if (Read(&usValue, sizeof(USHORT)) != sizeof(USHORT)) m_bIsEOF = TRUE;
		return usValue;
	}

    inline SHORT Reads()
	{
		SHORT sValue;
		if (Read(&sValue, sizeof(SHORT)) != sizeof(SHORT)) m_bIsEOF = TRUE;
		return sValue;
	}

    inline ULONG Readul()
	{
		ULONG ulValue;
		if (Read(&ulValue, sizeof(ULONG)) != sizeof(ULONG)) m_bIsEOF = TRUE;
		return ulValue;
	}

    inline LONG Readl()
	{
		LONG lValue;
		if (Read(&lValue, sizeof(LONG)) != sizeof(LONG)) m_bIsEOF = TRUE;
		return lValue;
	}


	inline BOOL IsEOF() { return m_bIsEOF; }

    inline void Writeuc(UCHAR p_ucVal)
	{
		Write(&p_ucVal, sizeof(UCHAR));
	}

	inline void Writec(CHAR p_cVal)
	{
		Write(&p_cVal, sizeof(CHAR));
	}

	inline void Writeus(USHORT p_usVal)
	{
		Write(&p_usVal, sizeof(USHORT));
	}

    inline void Writes(SHORT p_sVal)
	{
		Write(&p_sVal, sizeof(SHORT));
	}

    inline void Writeul(ULONG p_ulVal)
	{
		Write(&p_ulVal, sizeof(ULONG));
	}

    inline void Writel(LONG p_lVal)
	{
		Write(&p_lVal, sizeof(LONG));
	}


private:
	BOOL	m_bIsEOF;

};

#define cArchive_load(ar, pFile) cArchive ar(pFile, cArchive::load)
#define cArchive_store(ar, pFile) cArchive ar(pFile, cArchive::store)

#else

class cArchive  
{
public:
    enum eMode
    {
        M_NONE     = 0,
        M_READ     = 1,
        M_WRITE    = 2
    };

	cArchive(CSocketFile* p_pFile, TLONG p_lSize = 0, LONG p_lBufSize = 4096);
	cArchive(CFile* p_pFile, TLONG p_lSize = 0, LONG p_lBufSize = 4096);
	virtual ~cArchive();
           
    BOOL Flush();

    inline UCHAR Readuc();
    inline CHAR Readc();
    inline USHORT Readus();
    inline SHORT Reads();
    inline ULONG Readul();
    inline LONG Readl();
    BOOL Read(void* p_pBuf, TLONG p_lBufSize);
	inline CRect ReadRc()
	{
		CRect rc;
		rc.left = Readul();
		rc.top = Readul();
		rc.right = Readul();
		rc.bottom = Readul();
		return rc;
	}
	inline CPoint ReadPt()
	{
		CPoint pt;
		pt.x = Readul();
		pt.y = Readul();
		return pt;
	}
	inline CSize ReadSz()
	{
		CSize sz;
		sz.cx = Readul();
		sz.cy = Readul();
		return sz;
	}

    inline BOOL Writeuc(UCHAR p_ucVal);
    inline BOOL Writec(CHAR p_cVal);
    inline BOOL Writeus(USHORT p_usVal);
    inline BOOL Writes(SHORT p_sVal);
    inline BOOL Writeul(ULONG p_ulVal);
    inline BOOL Writel(LONG p_lVal);
    BOOL WriteString(LPCSTR p_szString);
    BOOL Write(void* p_pBuf, TLONG p_lBufSize);
	inline void WriteRc(CRect rc)
	{
		Writeul(rc.left);
		Writeul(rc.top);
		Writeul(rc.right);
		Writeul(rc.bottom);
	}
	inline void WritePt(CPoint pt)
	{
		Writeul(pt.x);
		Writeul(pt.y);
	}
	inline void WriteSz(CSize sz)
	{
		Writeul(sz.cx);
		Writeul(sz.cy);
	}


	inline BOOL IsBufferEmpty() const { return m_bEOF; }
    inline BOOL IsEOF() const { return m_bEOF; }
    
    inline CFile* GetFile() const { return m_pFile; }

private:

    UCHAR   ReadByte();
    BOOL    ReadRefreshBuffer();

    BOOL    WriteByte(UCHAR p_ucVal);
    BOOL    WriteRefreshBuffer();

    CFile* m_pFile;

                                               
    TLONG    m_lBufStart;
    LONG    m_lBufPos;
    TLONG    m_lCurBufSize;
    LONG    m_lBufSize;
    
    TLONG    m_lStart;
    TLONG    m_lEnd;

    BOOL    m_bEOF;
	BOOL	m_bIsSocket;

    eMode   m_mode;


    UCHAR*  m_pBuf;
};

#define cArchive_load(ar, pFile) cArchive ar(pFile)
#define cArchive_store(ar, pFile) cArchive ar(pFile)

inline UCHAR cArchive::Readuc()
{
    return (UCHAR)ReadByte();
}

inline CHAR cArchive::Readc()
{
    return (CHAR)ReadByte();
}

inline USHORT cArchive::Readus()
{
    USHORT usRetVal;
    Read(&usRetVal,sizeof(USHORT));
    return usRetVal;
}

inline SHORT cArchive::Reads()
{
    SHORT sRetVal;
    Read(&sRetVal,sizeof(SHORT));
    return sRetVal;
}

inline ULONG cArchive::Readul()
{
    ULONG ulRetVal;
    Read(&ulRetVal,sizeof(ULONG));
    return ulRetVal;
}

inline LONG cArchive::Readl()
{
    LONG lRetVal;
    Read(&lRetVal,sizeof(LONG));
    return lRetVal;
}

inline BOOL cArchive::Writeuc(UCHAR p_ucVal)
{
    return WriteByte(p_ucVal);
}

inline BOOL cArchive::Writec(CHAR p_cVal)
{
    return WriteByte((UCHAR)p_cVal);
}

inline BOOL cArchive::Writeus(USHORT p_usVal)
{
    return Write(&p_usVal,sizeof(USHORT));
}

inline BOOL cArchive::Writes(SHORT p_sVal)
{
    return Write(&p_sVal,sizeof(SHORT));
}

inline BOOL cArchive::Writeul(ULONG p_ulVal)
{
    return Write(&p_ulVal,sizeof(ULONG));
}

inline BOOL cArchive::Writel(LONG p_lVal)
{
    return Write(&p_lVal,sizeof(LONG));
}
#endif

#endif // !defined(AFX_CARCHIVE_H__918E2068_109A_4300_B44B_C9C01E302D8D__INCLUDED_)


