// ChatWindow.cpp : implementation file
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "UserListWindow.h"


// CUserListWindow

CUserListWindow::CUserListWindow()
{
	m_pParentFrame = NULL;
	m_pListBox = NULL;
}

CUserListWindow::~CUserListWindow()
{
}


BEGIN_MESSAGE_MAP(CUserListWindow, CSizingControlBarG)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()



// CUserListWindow message handlers


int CUserListWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CSizingControlBar::OnCreate(lpCreateStruct) == -1)
		return -1;

    CRect rect;
    GetClientRect(rect);
	CFont font;
	font.Attach(GetStockObject(DEFAULT_GUI_FONT));
    
	m_pListBox = new CListBox();
	m_pListBox->Create(WS_CHILD|LBS_SORT|LBS_NOSEL|LBS_NOINTEGRALHEIGHT|WS_VSCROLL, rect, this, 1);
	m_pListBox->ModifyStyleEx(0,WS_EX_CLIENTEDGE);
	m_pListBox->SetFont(&font);
	m_pListBox->ShowWindow(SW_SHOW);

	return 0;
}

void CUserListWindow::OnSize(UINT nType, int cx, int cy)
{
	CSizingControlBar::OnSize(nType, cx, cy);
    if (m_pListBox)
    {
        m_pListBox->MoveWindow(0,0,cx,cy);
    }
}

void CUserListWindow::AddUser(LPCTSTR p_tszUser)
{
	if (m_pListBox)
	{
		m_pListBox->AddString(p_tszUser);
	}
}

void CUserListWindow::RemoveUser(LPCTSTR p_tszUser)
{
	if (m_pListBox)
	{
		UINT nIndex = m_pListBox->FindStringExact(-1, p_tszUser);
		if (nIndex != -1) m_pListBox->DeleteString(nIndex);
	}
}

void CUserListWindow::RemoveAllUsers()
{
	if (m_pListBox) m_pListBox->ResetContent();
}

BOOL CUserListWindow::SetParentFrame(CFrameWnd* p_pParentFrame)
{
	m_pParentFrame = p_pParentFrame;
    return TRUE;
}

void CUserListWindow::OnDestroy()
{
	delete m_pListBox;
	CSizingControlBarG::OnDestroy();

}
BOOL CUserListWindow::UpdateFixedSizes(BOOL bHorz, BOOL bDocked)
{
    //m_szFixed.cx = 150;
	CSizingControlBarG::UpdateFixedSizes(bHorz, bDocked);
	return TRUE;  // keep it's size when negotiating space
}

