// ServingSocket.cpp: implementation of the CServingSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "ServingSocket.h"
#include "ListeningSocket.h"
#include "PabloDrawdoc.h"
#include "pablo_ver.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServingSocket::CServingSocket(CListeningSocket* pListenSocket)
{
    m_pListenSocket = pListenSocket;
	m_pFile = NULL;
	m_pThread = NULL;
	m_bUserJoined = FALSE;
}

CServingSocket::~CServingSocket()
{
	if (m_pFile != NULL) delete m_pFile;
}

BOOL CServingSocket::Init()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)m_pListenSocket->m_pDoc;
    cPage* pPage = pDoc->GetCurrentPage();
	if (!pPage) return FALSE;
    cCanvas* pCanvas = pPage->GetCanvas();

	m_pFile = new CSocketFile(this, TRUE);
	
	cArchive_store(ar, m_pFile); 

    CRect rect = CRect(CPoint(0,0),CSize(pCanvas->GetSize().cx, pCanvas->FindEndY()+1));

	CSingleLock(&m_pListenSocket->m_mutex, TRUE);

	cMemCanvas mc(rect.Size());
	mc.Set(rect.TopLeft(), pCanvas, CPoint(0,0), rect.Size());

    ar.Writeul(MT_INIT);
	ar.Writeul(PABLO_SOCKET_VERSION);
	ar.Writeul(_tcslen(PABLO_BUILD));
	ar.WriteString(PABLO_BUILD);
	ar.Writeul(pCanvas->GetSize().cx);
	ar.Writeul(pCanvas->GetSize().cy);
	ar.Flush();

	if (rect.bottom > 0)
    {
		CClientSocket::SendPart(m_pFile, &mc, CRect(CPoint(0,0), rect.Size()), rect.TopLeft(), pDoc->GetApp()->GetOptions());
    }
	// send all the current users to the new client
	CStringList sl;
	m_pListenSocket->GetAliasList(sl, this);
	POSITION pos = sl.GetHeadPosition();
	while (pos)
	{
		ar.Writeul(MT_USER_JOIN);
		CString& strAlias = sl.GetNext(pos);
		ar.Writeul(strAlias.GetLength());
		ar.WriteString(strAlias);
	}

	ar.Flush();
	return TRUE;
}

void CServingSocket::OnClose(int nErrorCode)
{
	// send message to everyone else that this user has left
	if (m_bUserJoined)
	{
		CString str;
		str = m_strAlias;
		m_pListenSocket->Writeul(MT_USER_PART, this);
		m_pListenSocket->Writeul(str.GetLength(), this); // length
		m_pListenSocket->Write((const void*)(LPCTSTR)str, str.GetLength(), this);

		if (nErrorCode == 0)
			str.Format(_T("*** %s has left"), m_strAlias);
		else
			str.Format(_T("*** %s has left (connection error)"), m_strAlias);
		m_pListenSocket->Writeul(MT_MESSAGE, this);
		m_pListenSocket->Writeul(str.GetLength(), this);
		m_pListenSocket->Write((const void*)(LPCTSTR)str, str.GetLength(), this);
	}
	CSocket::OnClose(nErrorCode);
	if (m_pThread) m_pThread->PostThreadMessage(WM_USER_DISCONNECT, 0,0); //OnDisconnect(0, 0);
	m_pThread = NULL;	
}

void CServingSocket::OnReceive(int nErrorCode)
{
    CSocket::OnReceive(nErrorCode);

	ULONG ulCount;
	CString str;
    CPoint pt;
	eMessageType mt;
    CRect rect;
	cArchive_load(ar, m_pFile);
	do
	{
	    CSingleLock(m_pCriticalSection, TRUE);
		mt = (eMessageType)ar.Readul();
        switch (mt)
        {
/*
        case MT_CLOSE:
            //OnClose(0); // the 1 tells the thread not to try sending a close message back.
		    if (m_pCriticalSection) m_pCriticalSection->Unlock();
			if (m_pThread) m_pThread->OnDisconnect(0, 0);
            return;  // we return, since this socket is now closed!
*/
		case MT_CLEAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul()); // width
            m_pListenSocket->Writeul(ar.Readul()); // height
			break;
		case MT_DELETECOL:
		case MT_INSERTCOL:
		case MT_INSERTLINE:
        case MT_DELETELINE:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul()); // line/col to insert at
			break;
        case MT_DELETECHAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeuc(ar.Readuc()); // insert
            m_pListenSocket->Writeul(ar.Readul()); // x
            m_pListenSocket->Writeul(ar.Readul()); // y
            break;
        case MT_INSERTCHAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeuc(ar.Readuc()); // insert
            m_pListenSocket->Writeul(ar.Readul()); // x
            m_pListenSocket->Writeul(ar.Readul()); // y
            m_pListenSocket->Writeus(ar.Readus()); // value
            break;
		
		case MT_UNDO:
			{
				cPage* pPage = m_pListenSocket->GetDocument()->GetCurrentPage();
				CRectArray	arrRect;
				CPoint		ptCursor;
				pPage->Undo(arrRect, ptCursor, m_pListenSocket);
			}
			break;
		case MT_REDO:
			{
				cPage* pPage = m_pListenSocket->GetDocument()->GetCurrentPage();
				CRectArray	arrRect;
				CPoint		ptCursor;
				pPage->Redo(arrRect, ptCursor, m_pListenSocket);
			}
			break;
		case MT_UNDOCOMBINE:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul());
			break;

		case MT_FILL_CHAR:
		case MT_FILL_ATTR:
		case MT_FILL_FORE:
		case MT_FILL_BACK:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->WriteRc(ar.ReadRc());
            m_pListenSocket->Writeuc(ar.Readuc());
			break;

		case MT_ERASE_RECT:
        case MT_DELETE_RECT:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->WriteRc(ar.ReadRc());
			break;

        case MT_SENDPART:
			{
				rect = ar.ReadRc();
				ULONG ulSize = ar.Readul();
				char* buf = new char[ulSize];
				ar.Read(buf, ulSize);


				m_pListenSocket->Writeul(mt);
				m_pListenSocket->WriteRc(rect);
				m_pListenSocket->Writeul(ulSize);

				m_pListenSocket->Write(buf, ulSize);

				delete [] buf;


/*
				sCanvasElement ce;
				cMemCanvas mc(rect.Size());
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					for (pt.x=0; pt.x<rect.Width(); pt.x++)
					{
						ce.value = ar.Readus();
						mc.Set(pt, ce);
					}
				}

				// write everything after everything is read
				m_pListenSocket->Writeul(mt);
				m_pListenSocket->WriteRc(rect);

				sCanvasElement* pBuf = new sCanvasElement[rect.Width()];
				pt.x = 0;
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					mc.GetLine(pt, pBuf);
					m_pListenSocket->Write(pBuf, rect.Width()*sizeof(sCanvasElement));
				}
				delete [] pBuf;
				*/
			}
            break;

		case MT_USER_JOIN:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
			m_strAlias = str;
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);

			m_bUserJoined = TRUE;
			str.Format(_T("*** %s has joined"), m_strAlias);
			ulCount = str.GetLength();
            m_pListenSocket->Writeul(MT_MESSAGE);
			m_pListenSocket->Writeul(ulCount); 
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);
			break;

		case MT_USER_PART:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);

			str.Format(_T("*** %s has left"), m_strAlias);
			ulCount = str.GetLength();
            m_pListenSocket->Writeul(MT_MESSAGE);
			m_pListenSocket->Writeul(ulCount); 
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);
			break;

		case MT_MESSAGE:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);
			break;
        }
    }
    while (!ar.IsBufferEmpty());
	
    m_pListenSocket->FlushAll();
}

