// ChildFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "ChildFrm.h"
#include "MainFrm.h"
#include "directx\ddutil.h"
#include "sAccel.h"


CDisplay*			g_pDisplay			= NULL;
BOOL				g_bFullScreen		= FALSE;
CRect				g_rectWindowed;

#define NORMAL_SETTINGS			_T("Main")
#define FULLSCREEN_SETTINGS		_T("Main-FullScreen")

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_MOVE()
    ON_MESSAGE(WM_USER_UPDATE_COLOUR, OnUpdateColour)
	ON_MESSAGE(WM_USER_UPDATE_CHARSET, OnUpdateCharSet)
	ON_MESSAGE(WM_USER_ADD_MESSAGE, OnAddMessage)
	ON_MESSAGE(WM_USER_JOINED, OnUserJoined)
	ON_MESSAGE(WM_USER_PARTED, OnUserParted)
	ON_COMMAND(ID_SWITCHCHATEDIT, OnSwitchChatEdit)
	ON_COMMAND(ID_SHOW_CHAT_WINDOW, OnShowChatWindow)
	ON_UPDATE_COMMAND_UI(ID_SHOW_CHAT_WINDOW, OnUpdateShowChatWindow)
	ON_COMMAND(ID_VIEW_SHOW_PREVIEW, OnShowPreview)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOW_PREVIEW, OnUpdateShowPreview)

	ON_COMMAND(ID_CANVAS_BREAKCONNECTION, OnCanvasBreakconnection)
	ON_COMMAND(ID_CANVAS_CONNECTTOSERVER, OnCanvasConnecttoserver)
	ON_COMMAND(ID_CANVAS_STARTSERVER, OnCanvasStartserver)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_BREAKCONNECTION, OnUpdateCanvasBreakconnection)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_CONNECTTOSERVER, OnUpdateCanvasConnecttoserver)
	ON_UPDATE_COMMAND_UI(ID_CANVAS_STARTSERVER, OnUpdateCanvasStartserver)
	ON_COMMAND(ID_VIEW_CHARACTER_SET, OnViewCharacterSet)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CHARACTER_SET, OnUpdateViewCharacterSet)
	ON_COMMAND(ID_VIEW_COLOURBAR, OnViewColourbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COLOURBAR, OnUpdateViewColourbar)
	ON_WM_SIZE()

	ON_COMMAND(ID_CYCLE_BACKGROUND8, OnCycleBackground8)
	ON_UPDATE_COMMAND_UI(ID_CYCLE_BACKGROUND8, OnUpdateCycleBackground8)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_COMMAND(ID_FULLSCREEN_SWITCH, OnFullscreenSwitch)
	ON_UPDATE_COMMAND_UI(ID_FULLSCREEN_SWITCH, OnUpdateFullscreenSwitch)
	ON_COMMAND(ID_VIEW_MENUBAR, OnViewMenubar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MENUBAR, OnUpdateViewMenubar)

	ON_UPDATE_COMMAND_UI(ID_INDICATOR_INS, OnUpdateInsert)

	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_TOOLBAR, OnViewToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateViewToolbar)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame(CPabloDrawDoc* p_pDocument)
{
	// TODO: add member initialization code here
	m_pDocument = p_pDocument;
	m_pView = NULL;
}

CMainFrame::~CMainFrame()
{
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	cs.style |= FWS_ADDTOTITLE;
	cs.lpszClass = AfxRegisterWndClass
		(
			CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
			0,
			0,
			AfxGetApp()->LoadIcon(IDR_MAINFRAME)
		);
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return TRUE;
}


void CMainFrame::ActivateFrame(int nCmdShow)
{
	CFrameWnd::ActivateFrame(nCmdShow);
} 

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
    ID_INDICATOR_POS,
	ID_INDICATOR_INS,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	CArray<ACCEL> accels;

	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_TAB			, ID_SWITCHCHATEDIT			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT | FALT			, 'V'				, ID_VIEW_SHOW_PREVIEW		));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FALT			, 'X'				, ID_APP_EXIT				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FALT			, 'Z'				, ID_CYCLE_BACKGROUND8		));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FALT			, 'L'				, ID_FILE_LOAD				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FCONTROL		, 'L'				, ID_FILE_LOAD				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FCONTROL		, 'N'				, ID_FILE_NEW				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FCONTROL		, 'O'				, ID_FILE_LOAD				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FCONTROL		, 'P'				, ID_FILE_PRINT				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FCONTROL		, 'S'				, ID_FILE_SAVE				));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FALT			, 'S'				, ID_FILE_SAVE_AS			));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT	| FALT			, VK_RETURN			, ID_FULLSCREEN_SWITCH		));
	accels.Add(sAccel( FVIRTKEY | FNOINVERT					, VK_ESCAPE			, ID_VIEW_MENUBAR			));
//	accels.Add(sAccel( FVIRTKEY | FNOINVERT	, , ));

	m_hAccelTable = ::CreateAcceleratorTable(accels.GetData(), accels.GetCount());

	CRect rect;
	GetClientRect(rect);
	m_pView = new CCanvasView();
	m_pView->Create(NULL, NULL, WS_CHILD|WS_VISIBLE, rect, this, AFX_IDW_PANE_FIRST);
	m_pDocument->AddView(m_pView);
	m_pView->OnInitialUpdate();
	m_pViewActive = m_pView;

	CreateMenu();

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
    m_wndStatusBar.SetPaneInfo(1,ID_INDICATOR_POS,0,100);

	EnableDocking(CBRS_ALIGN_ANY);


	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC, CRect(0,0,0,0), 1) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);


    if (!m_wndPreview.Create("Preview", this, CSize(200,200), TRUE, 2, WS_CHILD|WS_VISIBLE|CBRS_GRIPPER|CBRS_RIGHT| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndPreview.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBar(&m_wndPreview);

	if (!m_wndChat.Create("Chat", this, CSize(300,100), TRUE, 3, WS_VISIBLE|WS_CHILD|CBRS_BOTTOM|CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndChat.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndChat);

	if (!m_wndUserList.Create("User List", this, CSize(90, 100), TRUE, 4, WS_VISIBLE|WS_CHILD|CBRS_BOTTOM|CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndUserList.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBarLeftOf(&m_wndUserList, &m_wndChat);



    if (!m_wndColour.Create("Colour", this, CSize(200,200), TRUE, 5, WS_CHILD|WS_VISIBLE | CBRS_BOTTOM| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndColour.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBar(&m_wndColour);

    if (!m_wndCharSet.Create("Character Set", this, CSize(200,200), TRUE, 6, WS_CHILD|WS_VISIBLE | CBRS_BOTTOM| CBRS_SIZE_DYNAMIC))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
    m_wndCharSet.EnableDocking(CBRS_ALIGN_ANY);
    DockControlBarLeftOf(&m_wndCharSet, &m_wndColour);

	m_wndChat.SetParentFrame(this);
	m_wndColour.SetParentFrame(this);
	m_wndCharSet.SetParentFrame(this);
	m_wndPreview.SetParentFrame(this);

	m_wndUserList.ShowWindow(SW_HIDE);
	m_wndChat.ShowWindow(SW_HIDE);

	LoadBarState((g_bFullScreen) ? FULLSCREEN_SETTINGS : NORMAL_SETTINGS);
	CSizingControlBar::GlobalLoadState(this, (g_bFullScreen) ? FULLSCREEN_SETTINGS : NORMAL_SETTINGS);
	return 0;
}

void CMainFrame::OnMove(int x, int y)
{
	CFrameWnd::OnMove(x, y);
}


LRESULT CMainFrame::OnUpdateColour(WPARAM wparam, LPARAM lparam)
{
    m_wndColour.Update();
    return 0;
}

LRESULT CMainFrame::OnUpdateCharSet(WPARAM wparam, LPARAM lparam)
{
    m_wndCharSet.Update();
    return 0;
}

LRESULT CMainFrame::OnAddMessage(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszMessage = (LPCTSTR)wparam;
	ASSERT(tszMessage);
    m_wndChat.AddMessage(tszMessage);
    return 0;
}

LRESULT CMainFrame::OnUserJoined(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszUser = (LPCTSTR)wparam;
	ASSERT(tszUser);
    m_wndUserList.AddUser(tszUser);
    return 0;
}

LRESULT CMainFrame::OnUserParted(WPARAM wparam, LPARAM lparam)
{
	LPCTSTR tszUser = (LPCTSTR)wparam;
	if (tszUser)
	{
		m_wndUserList.RemoveUser(tszUser);
	}
	else
	{
		m_wndUserList.RemoveAllUsers();
		m_wndChat.AddMessage(_T("*** Disconnected"));
	}

    return 0;
}


void CMainFrame::OnSwitchChatEdit()
{
	if (GetFocus())
	{
		if (GetActiveView() && (GetActiveView()->IsChild(GetFocus()) || GetActiveView() == GetFocus()))
		{
			if (g_bFullScreen && (!m_wndChat.IsVisible() || !m_wndUserList.IsVisible()))
			{
				m_wndChat.ShowWindow(SW_SHOW);
				m_wndUserList.ShowWindow(SW_SHOW);
				DelayRecalcLayout();
			}
			if (m_wndChat.IsVisible() && m_wndChat.m_pChatView)
			{
				m_wndChat.m_pChatView->SetFocus();
			}
		}
		else
		{
			if (g_bFullScreen && (m_wndChat.IsVisible() || m_wndUserList.IsVisible()))
			{
				m_wndChat.ShowWindow(SW_HIDE);
				m_wndUserList.ShowWindow(SW_HIDE);
				DelayRecalcLayout();
			}
			GetActiveView()->SetFocus();
		}
	}
}

void CMainFrame::DockControlBarLeftOf(CControlBar* Bar, CControlBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;
	
	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout(TRUE);
	
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;
	
	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line. By calculating a rectangle, we
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}


void CMainFrame::OnShowChatWindow()
{
	if (m_wndChat.IsVisible() || m_wndUserList.IsVisible())
	{
		m_wndChat.ShowWindow(SW_HIDE);
		m_wndUserList.ShowWindow(SW_HIDE);
	}
	else
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
	}
	DelayRecalcLayout();
}

void CMainFrame::OnUpdateShowChatWindow(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndChat.IsVisible() || m_wndUserList.IsVisible()) ? TRUE : FALSE);
}

void CMainFrame::OnShowPreview()
{
	if (m_wndPreview.IsVisible())
	{
		m_wndPreview.ShowWindow((m_wndPreview.IsVisible()) ? SW_HIDE : SW_SHOW); 
	    m_pView->SetFocus();
	}
	else
	{
		m_wndPreview.ShowWindow((m_wndPreview.IsVisible()) ? SW_HIDE : SW_SHOW); 
		m_wndPreview.SetChildFocus();
	}
	DelayRecalcLayout();
}

void CMainFrame::OnUpdateShowPreview(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_wndPreview.IsVisible() ? TRUE : FALSE);
}
void CMainFrame::OnCanvasBreakconnection()
{
	GetDocument()->OnCanvasBreakconnection();
}
void CMainFrame::OnCanvasConnecttoserver()
{
	GetDocument()->OnCanvasConnecttoserver();
	if (GetDocument()->GetClientSocket())
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
		DelayRecalcLayout();
	}
}
void CMainFrame::OnCanvasStartserver()
{
	GetDocument()->OnCanvasStartserver();
	if (GetDocument()->GetClientSocket())
	{
		m_wndChat.ShowWindow(SW_SHOW);
		m_wndUserList.ShowWindow(SW_SHOW);
		DelayRecalcLayout();
	}
}
void CMainFrame::OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI)
{
	GetDocument()->OnUpdateCanvasBreakconnection(pCmdUI);
}
void CMainFrame::OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI)
{
	GetDocument()->OnUpdateCanvasConnecttoserver(pCmdUI);
}
void CMainFrame::OnUpdateCanvasStartserver(CCmdUI* pCmdUI)
{
	GetDocument()->OnUpdateCanvasStartserver(pCmdUI);
}


void CMainFrame::OnViewCharacterSet()
{
	m_wndCharSet.ShowWindow((m_wndCharSet.IsVisible()) ? SW_HIDE : SW_SHOW); 
	DelayRecalcLayout();
}

void CMainFrame::OnUpdateViewCharacterSet(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndCharSet.IsVisible()) ? TRUE : FALSE);
}

void CMainFrame::OnViewColourbar()
{
	m_wndColour.ShowWindow((m_wndColour.IsVisible()) ? SW_HIDE : SW_SHOW); 
	DelayRecalcLayout();
}

void CMainFrame::OnUpdateViewColourbar(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((m_wndColour.IsVisible()) ? TRUE : FALSE);
}

void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);
}


/////

void CMainFrame::OnCycleBackground8()
{
    CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	pApp->GetOptions()->SetBackground8(!pApp->GetOptions()->GetBackground8());
	SendMessageToDescendants(WM_USER_UPDATE_CANVAS, 1);

}

void CMainFrame::OnUpdateCycleBackground8(CCmdUI *pCmdUI)
{
    CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	pCmdUI->SetCheck(!pApp->GetOptions()->GetBackground8());
}

void CMainFrame::OnSysCommand(UINT nID, LPARAM lParam)
{
	switch (nID)
	{
		case SC_MOVE:
		case SC_SIZE:
		case SC_MAXIMIZE:
		case SC_MONITORPOWER:
			if( g_bFullScreen )
				return;
			break;
	}
	CFrameWnd::OnSysCommand(nID, lParam);
}

void CMainFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();

	if (g_pDisplay) delete g_pDisplay;
}


void CMainFrame::OnFullscreenSwitch()
{
	g_bFullScreen = !g_bFullScreen;
	int iMenu = 0;
	HRESULT hr;
	HWND hwnd = AfxGetMainWnd()->GetSafeHwnd();

	if (g_bFullScreen)
	{
		GetWindowRect(g_rectWindowed);
		CSizingControlBar::GlobalSaveState(this, NORMAL_SETTINGS);
		SaveBarState(NORMAL_SETTINGS);


		if (g_pDisplay) delete g_pDisplay;
		g_pDisplay = new CDisplay();
		if( SUCCEEDED( hr = g_pDisplay->CreateFullScreenDisplay( hwnd, 640, 400, 16 ) ) )
		//if (true) //if( SUCCEEDED( hr = g_pDisplay->CreateWindowedDisplay(hwnd, 640, 400) ) )
		{
			SetMenu(NULL);
			iMenu = 1;
			ModifyStyle(WS_CAPTION|WS_BORDER|WS_THICKFRAME|WS_SYSMENU, 0, SWP_FRAMECHANGED);
			MoveWindow(CRect(0,0,640, 400));

			m_wndToolBar.ShowWindow(SW_HIDE);
			m_wndPreview.ShowWindow(SW_HIDE);
			m_wndStatusBar.ShowWindow(SW_HIDE);
			LoadBarState(FULLSCREEN_SETTINGS);
			CSizingControlBar::GlobalLoadState(this, FULLSCREEN_SETTINGS);
		}
		else
		{
			MoveWindow(g_rectWindowed);
			MessageBox(_T("Sorry, your video card does not support 640x400x16 mode"));
			delete g_pDisplay;
			g_pDisplay = NULL;
			g_bFullScreen = FALSE;
			return;
		}
	}
	else
	{
		SaveBarState(FULLSCREEN_SETTINGS);
		CSizingControlBar::GlobalSaveState(this, FULLSCREEN_SETTINGS);
		if (g_pDisplay) delete g_pDisplay;
		g_pDisplay = NULL;
		MoveWindow(g_rectWindowed);
		ModifyStyle(0, WS_CAPTION|WS_BORDER|WS_THICKFRAME|WS_SYSMENU, SWP_FRAMECHANGED);

		if (GetMenu() == NULL)
		{
			SetMenu(&m_menu);
			iMenu = 2;
		}

		m_wndToolBar.ShowWindow(SW_SHOW);
		m_wndPreview.ShowWindow(SW_SHOW);
		m_wndStatusBar.ShowWindow(SW_SHOW);
		CSizingControlBar::GlobalLoadState(this, NORMAL_SETTINGS);
		LoadBarState(NORMAL_SETTINGS);
	}
	DelayRecalcLayout();
	SendMessageToDescendants(WM_USER_FULLSCREEN_SWITCH, (WPARAM)g_bFullScreen, (LPARAM)iMenu);
}

void CMainFrame::OnUpdateFullscreenSwitch(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck((g_bFullScreen) ? 1 : 0);
}

void CMainFrame::OnViewMenubar()
{
	if (GetMenu())
	{
		SetMenu(NULL);
		SendMessageToDescendants(WM_USER_FULLSCREEN_SWITCH, (WPARAM)g_bFullScreen, 1);
	}
	else
	{
		SetMenu(&m_menu);
		SendMessageToDescendants(WM_USER_FULLSCREEN_SWITCH, (WPARAM)g_bFullScreen, 2);
	}
}

void CMainFrame::OnUpdateViewMenubar(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(g_bFullScreen);
}

void CMainFrame::OnUpdateInsert(CCmdUI *pCmdUI)
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	pCmdUI->Enable(pApp->GetOptions()->GetInsertMode());
}

void CMainFrame::OnClose()
{
	CSizingControlBar::GlobalSaveState(this, (g_bFullScreen) ? FULLSCREEN_SETTINGS : NORMAL_SETTINGS);
	SaveBarState((g_bFullScreen) ? FULLSCREEN_SETTINGS : NORMAL_SETTINGS);

	CFrameWnd::OnClose();
}

void CMainFrame::OnViewToolbar()
{
	m_wndToolBar.ShowWindow((m_wndToolBar.IsVisible()) ? SW_HIDE : SW_SHOW);
	DelayRecalcLayout();
}

void CMainFrame::OnUpdateViewToolbar(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_wndToolBar.IsVisible() ? TRUE : FALSE);
}

BOOL CMainFrame::CreateMenu(void)
{
/*
    POPUP "&Edit"
    BEGIN
        MENUITEM "Cu&t to Clipboard\tCtrl+X",   ID_EDIT_CUT
        MENUITEM "&Copy to Clipboard\tCtrl+C",  ID_EDIT_COPY
        MENUITEM "&Paste from Clipboard\tCtrl+V", ID_EDIT_PASTE
        MENUITEM SEPARATOR
        MENUITEM "&Move\tM",                    ID_BLOCK_MOVE
        MENUITEM "C&opy\tC",                    ID_BLOCK_COPY
        MENUITEM "P&aste\tP",                   ID_BLOCK_PASTE
        MENUITEM SEPARATOR
        POPUP "Block\tCtrl+B or B"
        BEGIN
            POPUP "&Fill\tCtrl+F or F"
            BEGIN
                MENUITEM "&Character",                  ID_FILL_CHARACTER
                MENUITEM "&Attribute",                  ID_FILL_ATTRIBUTE
                MENUITEM "Bac&kground",                 ID_FILL_BACKGROUND
                MENUITEM "&Foreground",                 ID_FILL_FOREGROUND
                MENUITEM "&Both Character && Attribute", ID_FILL_BOTH
            END
            MENUITEM "&Erase\tE",                   ID_EDIT_ERASE
            MENUITEM "&Delete\tD",                  ID_EDIT_DELETE
            MENUITEM "&Rotate\tR",                  ID_BLOCK_ROTATE
            MENUITEM "Flip &X\tX",                  ID_BLOCK_FLIPX
            MENUITEM "Flip &Y\tY",                  ID_BLOCK_FLIPY
            MENUITEM "Paste &Under\tU",             ID_BLOCK_UNDER
            MENUITEM "&Transparent\tT",             ID_BLOCK_TRANSPARENT
        END
        MENUITEM SEPARATOR
        MENUITEM "C&lear\tAlt+C",               ID_EDIT_CLEAR
    END
    POPUP "&Tools"
    BEGIN
        MENUITEM "&Start Server...",            ID_CYCLE_BACKGROUND
        MENUITEM "&Connect to Server...",       ID_CANVAS_CONNECTTOSERVER
        MENUITEM "&Break Connection",           ID_CANVAS_BREAKCONNECTION
        MENUITEM SEPARATOR
        POPUP "Options"
        BEGIN
            MENUITEM "iCE colours\tAlt+Z",          ID_CYCLE_BACKGROUND8
        END
    END
    POPUP "&Help"
    BEGIN
        MENUITEM "&About PabloDraw...",         ID_APP_ABOUT
    END
    POPUP "Vie&w"
    BEGIN
        MENUITEM "&Toolbar",                    ID_VIEW_TOOLBAR
        MENUITEM "&Status Bar",                 ID_VIEW_STATUS_BAR
        MENUITEM "&Chat Window",                ID_SHOW_CHAT_WINDOW
        MENUITEM "&Preview Window\tAlt+V",      ID_VIEW_SHOW_PREVIEW
        MENUITEM SEPARATOR
        MENUITEM "C&olour Bar",                 ID_VIEW_COLOURBAR
        MENUITEM "C&haracter Sets",             ID_VIEW_CHARACTER_SET
        MENUITEM SEPARATOR
        MENUITEM "&Full Screen\tAlt+Enter",     ID_FULLSCREEN_SWITCH
    END

*/
	m_cl.AddTail(cCommand(ID_FILE_NEW, 0, 0, 0, FALSE, _T("&New|New|Create a new file|Create a new file")));
	m_cl.AddTail(cCommand(ID_FILE_LOAD, 0, 0, 0, FALSE, _T("&Load...|Load|Load file|Load an existing file")));
	m_cl.AddTail(cCommand(ID_FILE_SAVE, 0, 0, 0, FALSE, _T("&Save")));
	m_cl.AddTail(cCommand(ID_FILE_SAVE_AS, 0, 0, 0, FALSE, _T("Save &As...")));
	m_cl.AddTail(cCommand(ID_FILE_PRINT, 0, 0, 0, FALSE, _T("&Print...")));
	m_cl.AddTail(cCommand(ID_FILE_PRINT_PREVIEW, 0, 0, 0, FALSE, _T("Print Pre&view")));
	m_cl.AddTail(cCommand(ID_FILE_PRINT_SETUP, 0, 0, 0, FALSE, _T("P&rint Setup...")));
	m_cl.AddTail(cCommand(ID_FILE_SEND_MAIL, 0, 0, 0, FALSE, _T("Sen&d...")));
	m_cl.AddTail(cCommand(ID_FILE_MRU_FILE1, 0, 0, 0, FALSE, _T("Recent File")));
	m_cl.AddTail(cCommand(ID_APP_EXIT, 0, 0, 0, FALSE, _T("E&xit|Exit|Exit PabloDraw|Exit PabloDraw")));

	m_cl.AddTail(cCommand(ID_VIEW_TOOLBAR, 0, 0, 0, FALSE, _T("&Toolbar")));
	m_cl.AddTail(cCommand(ID_VIEW_STATUS_BAR, 0, 0, 0, FALSE, _T("&Status Bar")));
	m_cl.AddTail(cCommand(ID_SHOW_CHAT_WINDOW, 0, 0, 0, FALSE, _T("&Chat Window")));
	m_cl.AddTail(cCommand(ID_VIEW_SHOW_PREVIEW, 0, 0, 0, FALSE, _T("&Preview Window")));
	m_cl.AddTail(cCommand(ID_VIEW_COLOURBAR, 0, 0, 0, FALSE, _T("C&olour Bar")));
	m_cl.AddTail(cCommand(ID_VIEW_CHARACTER_SET, 0, 0, 0, FALSE, _T("C&haracter Sets")));
	m_cl.AddTail(cCommand(ID_FULLSCREEN_SWITCH, 0, 0, 0, FALSE, _T("&Full Screen")));

	m_cl.AddTail(cCommand(ID_APP_ABOUT, 0, 0, 0, FALSE, _T("&About")));

	m_cl.AddTail(cCommand(ID_CYCLE_BACKGROUND, 0, 0, 0, FALSE, _T("&Start Server...")));
	m_cl.AddTail(cCommand(ID_CANVAS_CONNECTTOSERVER, 0, 0, 0, FALSE, _T("&Connect to Server...")));
	m_cl.AddTail(cCommand(ID_CANVAS_BREAKCONNECTION, 0, 0, 0, FALSE, _T("&Break Connection")));
	m_cl.AddTail(cCommand(ID_CYCLE_BACKGROUND8, 0, 0, 0, FALSE, _T("iCE colours")));


/*
	m_cl.AddTail(cCommand(ID_, 0, 0, 0, FALSE, _T("")));
	m_cl.AddTail(cCommand(ID_, 0, 0, 0, FALSE, _T("")));
	m_cl.AddTail(cCommand(ID_, 0, 0, 0, FALSE, _T("")));
*/
	m_cl.SetAccelerators(m_hAccelTable, TRUE, TRUE);
	m_menu.CreateMenu();

	cMenuItemList main(&m_cl);
	cMenuItemList sub(&m_cl);
	cMenuItemList subsub(&m_cl);
	
	sub.RemoveAll();
	sub.AddTail(cMenuItem(ID_FILE_NEW));
	sub.AddTail(cMenuItem(ID_FILE_LOAD));
	sub.AddTail(cMenuItem(ID_FILE_SAVE));
	sub.AddTail(cMenuItem(ID_FILE_SAVE_AS));
	/*sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_FILE_PRINT));
	sub.AddTail(cMenuItem(ID_FILE_PRINT_PREVIEW));
	sub.AddTail(cMenuItem(ID_FILE_PRINT_SETUP));*/
	sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_FILE_SEND_MAIL));
	sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_FILE_MRU_FILE1));
	sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_APP_EXIT));

	main.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&File"), &sub));

	sub.RemoveAll();
	m_pView->GetEditMenu(m_cl, sub);
	main.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Edit"), &sub));

	sub.RemoveAll();
	sub.AddTail(cMenuItem(ID_VIEW_TOOLBAR));
	sub.AddTail(cMenuItem(ID_VIEW_STATUS_BAR));
	sub.AddTail(cMenuItem(ID_SHOW_CHAT_WINDOW));
	sub.AddTail(cMenuItem(ID_VIEW_SHOW_PREVIEW));
	sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_VIEW_COLOURBAR));
	sub.AddTail(cMenuItem(ID_VIEW_CHARACTER_SET));
	sub.AddTail(cMenuItem(MENUID_SEPARATOR));
	sub.AddTail(cMenuItem(ID_FULLSCREEN_SWITCH));
	main.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("Vie&w"), &sub));

	sub.RemoveAll();
	sub.AddTail(cMenuItem(ID_CYCLE_BACKGROUND));
	sub.AddTail(cMenuItem(ID_CANVAS_CONNECTTOSERVER));
	sub.AddTail(cMenuItem(ID_CANVAS_BREAKCONNECTION));
	subsub.RemoveAll();
	subsub.AddTail(cMenuItem(ID_CYCLE_BACKGROUND8));
	sub.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Options"), &subsub));

	main.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Tools"), &sub));

	sub.RemoveAll();
	sub.AddTail(cMenuItem(ID_APP_ABOUT));
	main.AddTail(cMenuItem(MENUID_SUBMENU, FALSE, _T("&Help"), &sub));

	m_menu.AddMenu(&main);

	SetMenu(&m_menu);
	return TRUE;
}
