// ColourWindow.cpp : implementation file
//

#include "stdafx.h"
#include "pablodraw.h"
#include "ColourWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColourWindow

CColourWindow::CColourWindow()
{
    m_bFloatVert = FALSE;
    m_pColourView = NULL;
}

CColourWindow::~CColourWindow()
{
}


BEGIN_MESSAGE_MAP(CColourWindow, CSizingControlBar)
    ON_WM_CREATE()
    ON_WM_SIZE()
	ON_MESSAGE(WM_USER_FULLSCREEN_SWITCH, OnFullScreenSwitch)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColourWindow message handlers


int CColourWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CSizingControlBar::OnCreate(lpCreateStruct) == -1)
        return -1;
    CRect rect;
    GetClientRect(rect);
    
    m_pColourView = new CColourView();
    m_pColourView->Create(NULL, NULL, WS_CHILD|WS_VISIBLE, rect, this, 0);


    return 0;
}
BOOL CColourWindow::SetParentFrame(CMainFrame* p_pParentFrame)
{
    if (!m_pColourView) return FALSE;

    m_pColourView->SetParentFrame(p_pParentFrame);

    return TRUE;
}


void CColourWindow::OnSize(UINT nType, int cx, int cy) 
{
    CSizingControlBar::OnSize(nType, cx, cy);
    if (m_pColourView)
    {
        m_pColourView->MoveWindow(0,0,cx,cy);
    }
}
BOOL CColourWindow::UpdateFixedSizes(BOOL bHorz, BOOL bDocked)
{
    if (!bHorz || (m_bFloatVert && !bDocked))
    {
        m_szFixed = m_pColourView->GetSize(TRUE);
    }
    else
    {
        m_szFixed = m_pColourView->GetSize(FALSE);
    }
    return CSizingControlBar::UpdateFixedSizes(bHorz, bDocked);

}


CSize CColourWindow::CalcDynamicLayout(int nLength, DWORD dwMode)
{
    //dwMode &= ~LM_STRETCH;
    if (nLength > 0)
    {
        if (dwMode & LM_LENGTHY)
        {
            m_bFloatVert = (nLength > 100);
        }
        else
        {
            m_bFloatVert = (nLength < 100);
        }
    }

    return CSizingControlBar::CalcDynamicLayout(nLength, dwMode);
}

LRESULT CColourWindow::OnFullScreenSwitch(WPARAM wParam, LPARAM lParam)
{
	BOOL bFullScreen = (BOOL)wParam;
	m_pColourView->SetSimpleMode(bFullScreen);
	
	if (bFullScreen)
	{
		SetBorders(0,0,0,0);
		m_pColourView->ModifyStyle(0, WS_DISABLED);
	}
	else
	{
		SetBorders(3,3,3,3);
		m_pColourView->ModifyStyle(WS_DISABLED, 0);
	}
	return 0;
}