#pragma once

#include "ColourWindow.h"
#include "CharSetWindow.h"
#include "ChatWindow.h"
#include "PreviewWindow.h"
#include "UserListWindow.h"

class CChildFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CChildFrame)
public:
	CChildFrame();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// Implementation
public:
	virtual ~CChildFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
protected:
	CStatusBar		m_wndStatusBar;
    CColourWindow	m_wndColour;
    CCharSetWindow	m_wndCharSet;
	CChatWindow		m_wndChat;
	CPreviewWindow	m_wndPreview;
	CUserListWindow m_wndUserList;

	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMove(int x, int y);
    afx_msg LRESULT OnUpdateColour(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnUpdateCharSet(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnAddMessage(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserJoined(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserParted(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnFullScreenSwitch(WPARAM wparam, LPARAM lparam);
	afx_msg void OnSwitchChatEdit();

	void DockControlBarLeftOf(CControlBar* Bar, CControlBar* LeftOf);
    void ActivateFrame(int nCmdShow);

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnShowChatWindow();
	afx_msg void OnUpdateShowChatWindow(CCmdUI *pCmdUI);
	afx_msg void OnShowPreview();
	afx_msg void OnUpdateShowPreview(CCmdUI *pCmdUI);

	afx_msg void OnCanvasBreakconnection();
	afx_msg void OnCanvasConnecttoserver();
	afx_msg void OnCanvasStartserver();
	afx_msg void OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasStartserver(CCmdUI* pCmdUI);
	afx_msg void OnViewCharacterSet();
	afx_msg void OnUpdateViewCharacterSet(CCmdUI *pCmdUI);
	afx_msg void OnViewColourbar();
	afx_msg void OnUpdateViewColourbar(CCmdUI *pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
};

