#include "stdafx.h"
#include "cUndo.h"

cUndoState::cUndoState()
{
	m_rectSave.SetRectEmpty();
	m_pCanvas = NULL;
	m_bEndState = TRUE;
}
cUndoState::cUndoState(cCanvas* p_pSource, CRect p_rectSave, CPoint p_ptCursor, eUndoType p_UndoType, BOOL p_bEndState)
{
	m_rectSave = p_rectSave;
	m_ptCursor = p_ptCursor;
	m_UndoType = p_UndoType;
	m_bEndState = p_bEndState;
	m_bIsUndo = TRUE;
	m_pCanvas = NULL;
	switch (p_UndoType)
	{
	case UT_CLEAR:
		{
			int iEndY = p_pSource->FindEndY()+1;
			m_rectSave = CRect(CPoint(0,0), CSize(p_pSource->GetSize().cx, iEndY));
		}
		m_pCanvas = new cMemCanvas(m_rectSave.Size());
		m_pCanvas->Set(m_rectSave.TopLeft(), p_pSource, CPoint(0,0), m_rectSave.Size());
		break;
	case UT_BLOCK:
	case UT_DELETECHAR:
		m_pCanvas = new cMemCanvas(m_rectSave.Size());
		m_pCanvas->Set(m_rectSave.TopLeft(), p_pSource, CPoint(0,0), m_rectSave.Size());
		break;
	case UT_INSERTLINE:
	case UT_DELETELINE:
		m_rectSave = CRect(CPoint(0,m_ptCursor.y), CSize(p_pSource->GetSize().cx, 1));
		m_pCanvas = new cMemCanvas(m_rectSave.Size());
		m_pCanvas->Set(m_rectSave.TopLeft(), p_pSource, CPoint(0,0), m_rectSave.Size());
		break;
	case UT_INSERTCOL:
	case UT_DELETECOL:
		{
			int iEndY = p_pSource->FindEndY()+1;
			m_rectSave = CRect(CPoint(m_ptCursor.x,0), CSize(1, iEndY));
			m_pCanvas = new cMemCanvas(m_rectSave.Size());
			m_pCanvas->Set(m_rectSave.TopLeft(), p_pSource, CPoint(0,0), m_rectSave.Size());
		}
		break;
	}
	switch (p_UndoType)
	{
	case UT_CLEAR:
		m_rectUpdate = CRect(CPoint(0,0), p_pSource->GetSize());
		break;
	case UT_INSERTCHAR:
	case UT_DELETECHAR:
		m_rectUpdate = CRect(m_ptCursor, CSize(p_pSource->GetSize().cx-m_ptCursor.x, 1));
		break;
	case UT_INSERTLINE:
	case UT_DELETELINE:
		m_rectUpdate = CRect(CPoint(0, m_ptCursor.y), CSize(p_pSource->GetSize().cx, p_pSource->GetSize().cy-m_ptCursor.y));
		break;
	case UT_INSERTCOL:
	case UT_DELETECOL:
		m_rectUpdate = CRect(CPoint(m_ptCursor.x, 0), CSize(p_pSource->GetSize().cx-m_ptCursor.x, p_pSource->GetSize().cy));
		break;
	default:
		m_rectUpdate = m_rectSave;
		break;
	}
}

cUndoState::cUndoState(const cUndoState& p_value)
{
	m_pCanvas = NULL;
	Set(p_value);
}

cUndoState::~cUndoState()
{
	if (m_pCanvas) delete m_pCanvas;
}

cUndoState& cUndoState::operator=(const cUndoState& p_value)
{
	Set(p_value);
	return *this;
}
void cUndoState::Set(const cUndoState& p_value)
{
	if (this != &p_value)
	{
		if (m_pCanvas) delete m_pCanvas;
		m_rectSave = p_value.m_rectSave;
		m_rectUpdate = p_value.m_rectUpdate;
		m_ptCursor = p_value.m_ptCursor;
		m_UndoType = p_value.m_UndoType;
		m_bEndState = p_value.m_bEndState;
		m_bIsUndo = p_value.m_bIsUndo;
		m_pCanvas = NULL;
		if (p_value.m_pCanvas)
		{
			m_pCanvas = new cMemCanvas(p_value.m_pCanvas->GetSize());
			m_pCanvas->Set(CPoint(0,0), p_value.m_pCanvas, CPoint(0,0), p_value.m_pCanvas->GetSize());
		}
	}
}

void cUndoState::Undo(cCanvas* p_pSource, CListeningSocket* p_pSocket)
{
	if (!m_bIsUndo) return;
	if (p_pSocket)
	{
		p_pSocket->Writeul(MT_UNDOSTATE);
		p_pSocket->Writeuc(FALSE);
	}

	m_bIsUndo = FALSE;
	switch (m_UndoType)
	{
	case UT_BLOCK:
		SwapBuffers(p_pSource, p_pSocket);
		break;
	case UT_CLEAR:
		{
			int iEndY = p_pSource->FindEndY()+1;
			if (iEndY < 0) iEndY = 0;
			cMemCanvas mc(CSize(p_pSource->GetSize().cx, iEndY));
			mc.Set(CPoint(0,0), p_pSource, CPoint(0,0), mc.GetSize());
			if (p_pSocket)
			{
				p_pSocket->Writeul(MT_CLEAR);
				p_pSocket->Writeul(p_pSource->GetSize().cx);
				p_pSocket->Writeul(p_pSource->GetSize().cy);

				p_pSocket->Writeul(MT_SENDPART);
				CRect rect(CPoint(0,0), m_pCanvas->GetSize());
				p_pSocket->WriteRc(rect);

				sCanvasElement* pBuf = new sCanvasElement[rect.Width()];
				CPoint pt;
				pt.x = 0;
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					m_pCanvas->GetLine(pt, pBuf);
					p_pSocket->Write(pBuf, rect.Width()*sizeof(sCanvasElement));
				}
				delete [] pBuf;
			}
			else
			{
				p_pSource->Fill(7, 32);
				p_pSource->Set(CPoint(0,0), m_pCanvas, CPoint(0,0), m_pCanvas->GetSize());
			}
			m_pCanvas->Resize(mc.GetSize());
			m_pCanvas->Set(CPoint(0,0), &mc, CPoint(0,0), mc.GetSize());
		}
		break;
	case UT_INSERTCHAR:
		{
			if (!m_pCanvas) m_pCanvas = new cMemCanvas(CSize(1,1));
			m_pCanvas->Resize(CSize(1,1));
			m_pCanvas->Set(m_ptCursor, p_pSource, CPoint(0,0), m_pCanvas->GetSize());
			if (p_pSocket)
			{
	            p_pSocket->Writeul(MT_DELETECHAR);
		        p_pSocket->Writeuc(TRUE); // insert
			    p_pSocket->Writeul(m_ptCursor.x); // x
				p_pSocket->Writeul(m_ptCursor.y); // y
			}
			else p_pSource->DeleteChar(m_ptCursor);
			
		}
		break;
	case UT_DELETECHAR:
		{
			if (p_pSocket)
			{
	            p_pSocket->Writeul(MT_INSERTCHAR);
		        p_pSocket->Writeuc(TRUE); // insert
			    p_pSocket->Writeul(m_ptCursor.x); // x
				p_pSocket->Writeul(m_ptCursor.y); // y
				p_pSocket->Writeus(m_pCanvas->Get(CPoint(0,0)).value);
			}
			else p_pSource->InsertChar(m_ptCursor, m_pCanvas->Get(CPoint(0,0)));
		}
		break;
	case UT_INSERTLINE:
		SwapBuffers(p_pSource, p_pSocket);
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_DELETELINE);
            p_pSocket->Writeul(m_ptCursor.y); // line/col to insert at
		}
		else p_pSource->DeleteLine(m_ptCursor.y);
		break;
	case UT_DELETELINE:
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_INSERTLINE);
            p_pSocket->Writeul(m_ptCursor.y); // line/col to insert at
		}
		else p_pSource->InsertLine(m_ptCursor.y);
		SwapBuffers(p_pSource, p_pSocket);
		break;
	case UT_INSERTCOL:
		SwapBuffers(p_pSource, p_pSocket);
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_DELETECOL);
            p_pSocket->Writeul(m_ptCursor.x); // line/col to insert at
		}
		else p_pSource->DeleteColumn(m_ptCursor.x);
		break;
	case UT_DELETECOL:
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_INSERTCOL);
            p_pSocket->Writeul(m_ptCursor.x); // line/col to insert at
		}
		else p_pSource->InsertColumn(m_ptCursor.x);
		SwapBuffers(p_pSource, p_pSocket);
		break;
	}

	if (p_pSocket)
	{
		p_pSocket->Writeul(MT_UNDOSTATE);
		p_pSocket->Writeuc(TRUE);
	}

}

void cUndoState::Redo(cCanvas* p_pSource, CListeningSocket* p_pSocket)
{
	if (m_bIsUndo) return;
	if (p_pSocket)
	{
		p_pSocket->Writeul(MT_UNDOSTATE);
		p_pSocket->Writeuc(FALSE);
	}
	m_bIsUndo = TRUE;
	switch (m_UndoType)
	{
	case UT_BLOCK:
		SwapBuffers(p_pSource, p_pSocket);
		break;
	case UT_CLEAR:
		{
			int iEndY = p_pSource->FindEndY()+1;
			if (iEndY < 0) iEndY = 0;
			cMemCanvas mc(CSize(p_pSource->GetSize().cx, iEndY));
			mc.Set(CPoint(0,0), p_pSource, CPoint(0,0), mc.GetSize());
			if (p_pSocket)
			{
				p_pSocket->Writeul(MT_CLEAR);
				p_pSocket->Writeul(p_pSource->GetSize().cx);
				p_pSocket->Writeul(p_pSource->GetSize().cy);

				p_pSocket->Writeul(MT_SENDPART);
				CRect rect(CPoint(0,0), m_pCanvas->GetSize());
				p_pSocket->WriteRc(rect);

				sCanvasElement* pBuf = new sCanvasElement[rect.Width()];
				CPoint pt;
				pt.x = 0;
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					m_pCanvas->GetLine(pt, pBuf);
					p_pSocket->Write(pBuf, rect.Width()*sizeof(sCanvasElement));
				}
				delete [] pBuf;
			}
			else
			{
				p_pSource->Fill(7, 32);
				p_pSource->Set(CPoint(0,0), m_pCanvas, CPoint(0,0), m_pCanvas->GetSize());
			}
			m_pCanvas->Resize(mc.GetSize());
			m_pCanvas->Set(CPoint(0,0), &mc, CPoint(0,0), mc.GetSize());
		}
		break;
	case UT_INSERTCHAR:
		{
			if (p_pSocket)
			{
				p_pSocket->Writeul(MT_INSERTCHAR);
				p_pSocket->Writeuc(TRUE); // insert
				p_pSocket->Writeul(m_ptCursor.x); // x
				p_pSocket->Writeul(m_ptCursor.y); // y
				p_pSocket->Writeus(m_pCanvas->Get(CPoint(0,0)).value);
			}
			else p_pSource->InsertChar(m_ptCursor, m_pCanvas->Get(CPoint(0,0)));
		}
		break;
	case UT_DELETECHAR:
		{
			if (!m_pCanvas) m_pCanvas = new cMemCanvas(CSize(1,1));
			m_pCanvas->Resize(CSize(1,1));
			m_pCanvas->Set(m_ptCursor, p_pSource, CPoint(0,0), m_pCanvas->GetSize());
			if (p_pSocket)
			{
	            p_pSocket->Writeul(MT_DELETECHAR);
		        p_pSocket->Writeuc(TRUE); // insert
			    p_pSocket->Writeul(m_ptCursor.x); // x
				p_pSocket->Writeul(m_ptCursor.y); // y
			}
			else p_pSource->DeleteChar(m_ptCursor);
		}
	case UT_INSERTLINE:
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_INSERTLINE);
            p_pSocket->Writeul(m_ptCursor.y); // line/col to insert at
		}
		else p_pSource->InsertLine(m_ptCursor.y);
		SwapBuffers(p_pSource, p_pSocket);
		break;
	case UT_DELETELINE:
		SwapBuffers(p_pSource, p_pSocket);
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_DELETELINE);
            p_pSocket->Writeul(m_ptCursor.y); // line/col to insert at
		}
		else p_pSource->DeleteLine(m_ptCursor.y);
		break;
	case UT_INSERTCOL:
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_INSERTCOL);
            p_pSocket->Writeul(m_ptCursor.x); // line/col to insert at
		}
		else p_pSource->InsertColumn(m_ptCursor.x);
		SwapBuffers(p_pSource, p_pSocket);
		break;
	case UT_DELETECOL:
		SwapBuffers(p_pSource, p_pSocket);
		if (p_pSocket)
		{
			p_pSocket->Writeul(MT_DELETECOL);
            p_pSocket->Writeul(m_ptCursor.x); // line/col to insert at
		}
		else p_pSource->DeleteColumn(m_ptCursor.x);
		break;
	}
	if (p_pSocket)
	{
		p_pSocket->Writeul(MT_UNDOSTATE);
		p_pSocket->Writeuc(TRUE);
	}
}

void cUndoState::SwapBuffers(cCanvas* p_pSource, CListeningSocket* p_pSocket)
{
	cMemCanvas mcTemp(m_rectSave.Size());
	mcTemp.Set(m_rectSave.TopLeft(), p_pSource, CPoint(0,0), mcTemp.GetSize());
	if (p_pSocket)
		p_pSocket->SendPart(m_pCanvas, CRect(CPoint(0,0), m_rectSave.Size()), m_rectSave.TopLeft());
	else
		p_pSource->Set(CPoint(0,0), m_pCanvas, m_rectSave.TopLeft(), m_rectSave.Size());
	m_pCanvas->Set(CPoint(0,0), &mcTemp, CPoint(0,0), m_rectSave.Size());
}


void cUndoState::DeleteLines(int p_iStart, int p_iCount)
{
	for (int i=0; i<p_iCount; i++)
	{
		m_pCanvas->DeleteLine(p_iStart-m_rectSave.top);
	}
	if (m_pCanvas->GetSize().cy > p_iCount)
	{
		m_pCanvas->Resize(CSize(m_pCanvas->GetSize().cx, m_pCanvas->GetSize().cy-p_iCount));
	}
}

void cUndoState::InsertLines(int p_iStart, int p_iCount)
{
	if (p_iStart <= m_rectSave.top)
	{
		m_rectUpdate += CSize(0, p_iCount);
		m_rectSave += CSize(0, p_iCount);
	}
}

void cUndoState::DeleteColumns(int p_iStart, int p_iCount)
{
	for (int i=0; i<p_iCount; i++)
	{
		m_pCanvas->DeleteColumn(p_iStart-m_rectSave.left);
	}
	m_pCanvas->Resize(CSize(m_pCanvas->GetSize().cx-p_iCount, m_pCanvas->GetSize().cy));
}
