
#include "stdafx.h"
#include "cpalette.h"

cPalette::cPalette(int p_iNumCol)
{
    m_pData = NULL;
    Resize(p_iNumCol);
}

cPalette::~cPalette()
{
    if (m_pData) delete [] m_pData;
}

BOOL cPalette::Resize(int p_iNumCol)
{
    if (m_pData) delete [] m_pData;
    ASSERT(p_iNumCol > 0);
    m_iNumCol = p_iNumCol;
    m_pData = new sPalette[m_iNumCol];
    return TRUE;
}

void cPalette::SetSystemDefault()
{
    int i;
    sPalette* pPal;
    for (i=0; i<16; i++)
    {
        if (i>=m_iNumCol) break;
        pPal = &m_pData[i];
        switch (i)
        {
        case 0:
            pPal->red = 0; pPal->green = 0; pPal->blue = 0;
            break;
        case 1:
            pPal->red = 0; pPal->green = 0; pPal->blue = 171;
            break;
        case 2:
            pPal->red = 0; pPal->green = 171; pPal->blue = 0;
            break;
        case 3:
            pPal->red = 0; pPal->green = 171; pPal->blue = 171;
            break;
        case 4:
            pPal->red = 171; pPal->green = 0; pPal->blue = 0;
            break;
        case 5:
            pPal->red = 171; pPal->green = 0; pPal->blue = 171;
            break;
        case 6:
            pPal->red = 171; pPal->green = 87; pPal->blue = 0;
            break;
        case 7:
            pPal->red = 171; pPal->green = 171; pPal->blue = 171;
            break;
        case 8:
            pPal->red = 87; pPal->green = 87; pPal->blue = 87;
            break;
        case 9:
            pPal->red = 87; pPal->green = 87; pPal->blue = 255;
            break;
        case 10:
            pPal->red = 87; pPal->green = 255; pPal->blue = 87;
            break;
        case 11:
            pPal->red = 87; pPal->green = 255; pPal->blue = 255;
            break;
        case 12:
            pPal->red = 255; pPal->green = 87; pPal->blue = 87;
            break;
        case 13:
            pPal->red = 255; pPal->green = 87; pPal->blue = 255;
            break;
        case 14:
            pPal->red = 255; pPal->green = 255; pPal->blue = 87;
            break;
        case 15:
            pPal->red = 255; pPal->green = 255; pPal->blue = 255;
            break;
        }
    }
        
}

BOOL cPalette::Load(CFile& file, int p_iMaxCol)
{

    return FALSE;
}


PALETTEENTRY cPalette::GetPaletteEntry(int p_iCol)
{
    PALETTEENTRY pe;
    ASSERT(p_iCol < m_iNumCol);
    sPalette& pal = m_pData[p_iCol];
    pe.peRed = pal.red;
    pe.peGreen = pal.green;
    pe.peBlue = pal.blue;
    pe.peFlags = 0;
    return pe;
}

RGBQUAD cPalette::GetRGBQuad(int p_iCol)
{
    RGBQUAD rgb;
    ASSERT(p_iCol < m_iNumCol);
    sPalette& pal = m_pData[p_iCol];
    rgb.rgbRed = pal.red;
    rgb.rgbGreen = pal.green;
    rgb.rgbBlue = pal.blue;
    rgb.rgbReserved = 0;
    return rgb;
}
