/*----------------------------------------------------------------------------
 *  File:       psl_menu.cpp
 *  Purpose:    implementation for cMenu class
 *----------------------------------------------------------------------------
 */

#include "stdafx.h"
#include "cMenu.h"


    cCommand::cCommand
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszText                       // menu text
        )
    {
        Set(p_lID, p_dwImageID, p_dwDisabledImageID, p_dwHotImageID, p_bShowSelective, p_tszText);
    }

    cCommand::cCommand
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszMenuText,                  // menu text
            LPCTSTR         p_tszButtonText,                // toolbar button text
            LPCTSTR         p_tszToolTip,                   // tooltip text
            LPCTSTR         p_tszHelpText                   // status bar text
        )
    {
        Set(p_lID, p_dwImageID, p_dwDisabledImageID, p_dwHotImageID, p_bShowSelective, p_tszMenuText, p_tszButtonText, p_tszToolTip, p_tszHelpText);
    }

    cCommand::cCommand(const cCommand& p_value)
    {
        Set(p_value);
    }

    const cCommand&   cCommand::operator=(const cCommand& p_value) 
    {
        Set(p_value); 
        return *this; 
    }

    void cCommand::Set(const cCommand& p_value)
    {
        if (this != &p_value)
        {
            m_lID = p_value.m_lID;
            m_strMenuText = p_value.m_strMenuText;
            m_strButtonText = p_value.m_strButtonText;
            m_strToolTip = p_value.m_strToolTip;
            m_strHelpText = p_value.m_strHelpText;
			m_strAccelerator = p_value.m_strAccelerator;
            m_dwImageID = p_value.m_dwImageID;
            m_dwDisabledImageID = p_value.m_dwDisabledImageID;
            m_dwHotImageID = p_value.m_dwHotImageID;
            m_bShowSelective = p_value.m_bShowSelective;
        }
    }

    void cCommand::Set
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszText                       // menu text
        )
    {
        m_lID = p_lID;
        SetText(p_tszText);
        m_dwImageID = p_dwImageID;
        m_dwDisabledImageID = p_dwDisabledImageID;
        m_dwHotImageID = p_dwHotImageID;
        m_bShowSelective = p_bShowSelective;
		m_strAccelerator.Empty();
    }

    void cCommand::Set
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszMenuText,                  // menu text
            LPCTSTR         p_tszButtonText,                // toolbar button text
            LPCTSTR         p_tszToolTip,                   // tooltip text
            LPCTSTR         p_tszHelpText                   // status bar text
        )
    {
        m_lID = p_lID;
        m_strMenuText = p_tszMenuText;
        m_strButtonText = p_tszButtonText;
        m_strToolTip = p_tszToolTip;
        m_strHelpText = p_tszHelpText;
        m_dwImageID = p_dwImageID;
        m_dwDisabledImageID = p_dwDisabledImageID;
        m_dwHotImageID = p_dwHotImageID;
        m_bShowSelective = p_bShowSelective;
		m_strAccelerator.Empty();
    }


    void cCommand::SetText(LPCTSTR    p_tszText)
    {
        CString strText = p_tszText;
        LONG     lButtonTextPos = strText.Find(_T("|"),0);
        LONG     lToolTipPos = (lButtonTextPos != -1) ? strText.Find(_T("|"),lButtonTextPos+1) : -1;
        LONG     lHelpTextPos = (lToolTipPos != -1) ? strText.Find(_T("|"), lToolTipPos+1) : -1;
        if (lButtonTextPos >= 0)
        {
            if (lButtonTextPos != 0)
            {
                SetMenuText(strText.Mid(0,lButtonTextPos));
            }
            else
            {
                SetMenuText(NULL);
            }
            if (lToolTipPos > lButtonTextPos)
            {
                SetButtonText(strText.Mid(lButtonTextPos+1, lToolTipPos-lButtonTextPos-1));
                if (lHelpTextPos > lToolTipPos)
                {
                    SetToolTip(strText.Mid(lToolTipPos+1, lHelpTextPos-lToolTipPos-1));
                    SetHelpText(strText.Mid(lHelpTextPos+1, strText.GetLength()-lHelpTextPos-1));
                }
                else
                {
                    SetToolTip(strText.Mid(lToolTipPos+1, strText.GetLength()-lToolTipPos-1));
                    SetHelpText(NULL);
                }
            }
            else
            {
                SetButtonText(strText.Mid(lButtonTextPos+1, strText.GetLength()-lButtonTextPos-1));
                SetToolTip(NULL);
                SetHelpText(NULL);
            }
        }
        else
        {
            SetMenuText(strText);
            SetToolTip(NULL);
            SetHelpText(NULL);
            SetButtonText(NULL);
        }
    }


    void cCommandList::SetAccelerators(HACCEL p_hAccel, BOOL p_bUpdateItems, BOOL p_bAppend)
    {
        m_hAccel = p_hAccel;

        if (p_bUpdateItems)
        {
            POSITION pos = GetHeadPosition();
            while (pos)
            {
                cCommand& command = GetNext(pos);
                AddAccelerators(command, p_bAppend);
            }
        }
    }

    void cCommandList::CopyData(cCommand& p_Dest, const cCommand& p_Source)
    {
        p_Dest = p_Source;
        AddAccelerators(p_Dest, FALSE);
    }

    void cCommandList::AddAccelerators(cCommand& p_Dest, BOOL p_bAppend)
    {
        if (m_hAccel != NULL)
        {
            int cAccels = CopyAcceleratorTable(m_hAccel, NULL, 0);
            LPACCEL pAccel = new ACCEL[cAccels];
            CopyAcceleratorTable(m_hAccel, pAccel, cAccels);

            LPACCEL pCurAccel = NULL;
            CString strKeyCommand;

            for (int i=0; i<cAccels; i++)
            {
                if (pAccel[i].cmd == p_Dest.GetID())
                {
                    if ((pAccel[i].fVirt & FCONTROL) != 0) strKeyCommand += _T("Ctrl+");
                    if ((pAccel[i].fVirt & FALT) != 0) strKeyCommand += _T("Alt+");
                    if ((pAccel[i].fVirt & FSHIFT) != 0) strKeyCommand += _T("Shift+");
                    switch (pAccel[i].key)
                    {
                    case VK_RETURN:
                        strKeyCommand += _T("Enter");
                        break;
                    case VK_ESCAPE:
						strKeyCommand += _T("Escape");
                        break;
                    case VK_TAB:
						strKeyCommand += _T("Tab");
                        break;
					default:
                        strKeyCommand += (TCHAR)pAccel[i].key;
                        break;
                    }
                    break; // only process ONE accelerator for the shortcut key
                }
            }

            if (!strKeyCommand.IsEmpty())
            {
				CString strAccel = p_Dest.GetAccelerator();
				if (!strAccel.IsEmpty())
				{
					strAccel += _T(" or ");
				}
				strAccel += strKeyCommand;
				p_Dest.SetAccelerator(strAccel);
            }
            
            delete [] pAccel;
        }
    }







    cMenuItem::cMenuItem
        (
            LONG     p_lID, 
            BOOL     p_bShowText,
            LPCTSTR     p_tszSubMenuText,
            const cMenuItemList* p_listSubMenu
        )
    {
        m_plistSubMenu = NULL;
        Set(p_lID, p_bShowText, p_tszSubMenuText, p_listSubMenu);        
    }

    cMenuItem::cMenuItem(const cMenuItem& p_value)
    {
        m_plistSubMenu = NULL;
        Set(p_value);
    }

    cMenuItem::~cMenuItem()
    {
        if (m_plistSubMenu) delete m_plistSubMenu;
    }

    void cMenuItem::Set
        (
            LONG     p_lID, 
            BOOL     p_bShowText,
            LPCTSTR     p_tszSubMenuText,
            const cMenuItemList* p_listSubMenu
        )
    {
        m_lID = p_lID;
        m_bShowText = p_bShowText;
        m_command.SetText(p_tszSubMenuText);
        if (m_plistSubMenu) delete m_plistSubMenu;
        m_plistSubMenu = (p_listSubMenu) ? new cMenuItemList(*p_listSubMenu) : NULL;
    }

    void cMenuItem::Set(const cMenuItem& p_value)
    {
        if (this != &p_value)
        {
            m_lID = p_value.m_lID;
            m_command = p_value.m_command;
            m_bShowText = p_value.m_bShowText;
            if (m_plistSubMenu) delete m_plistSubMenu;
            m_plistSubMenu = (p_value.m_plistSubMenu) ? new cMenuItemList(*p_value.m_plistSubMenu) : NULL;
        }
    }

    void cMenuItem::SetSubMenu(const cMenuItemList* p_listSubMenu) 
    {
        if (m_plistSubMenu) delete m_plistSubMenu;
        m_plistSubMenu = (p_listSubMenu) ? new cMenuItemList(*p_listSubMenu) : NULL;
    }












/*----------------------------------------------------------------------------
 *  Name:           cMenu::cMenu
 *  Purpose:        constructor
 *----------------------------------------------------------------------------
 */
cMenu::cMenu()
{
}

/*----------------------------------------------------------------------------
 *  Name:           cMenu::~cMenu
 *  Purpose:        destructor
 *----------------------------------------------------------------------------
 */
cMenu::~cMenu()
{
}

/*----------------------------------------------------------------------------
 *  Name:           cMenu::AddMenu
 *  Purpose:        to add menu items to this object
 *  Post condition: append given menu items to the menu
 *  Returns:        TRUE if successfule
 *                  FALSE otherwise
 *----------------------------------------------------------------------------
 */
BOOL     cMenu::AddMenu
    (
        const cMenuItemList* p_plistMenuItems    // [in] structure/items to put on the menu
    )
{
    if (p_plistMenuItems->GetCommandList())
    {
        m_listCommands.AddTail((cCommandListBase*)p_plistMenuItems->GetCommandList());    
    }
	return ConvertMenu(*this, p_plistMenuItems);
}

/*----------------------------------------------------------------------------
 *  Name:           cMenu::CreateMenu
 *  Purpose:        does the actual work of appending menu items
 *  Post condition: append menu items in p_pMenuArray to menu
 *  Returns:        TRUE if successfule
 *                  FALSE otherwise
 *----------------------------------------------------------------------------
 */
BOOL cMenu::ConvertMenu
    (
        CMenu& p_menu,
        const cMenuItemList* p_plistMenuItems    // [in] structure/items to put on the menu
    )
{
    BOOL        bRetVal     = TRUE;
    POSITION posMenuItem = p_plistMenuItems->GetHeadPosition();

    while (posMenuItem && bRetVal)
    {
        const cMenuItem& menuItem = p_plistMenuItems->GetNext(posMenuItem);
        const cCommand* pCommand = p_plistMenuItems->GetCommandList()->FindCommand(menuItem.GetID());
        
        switch (menuItem.GetID())
        {
        case MENUID_SUBMENU:
            if (menuItem.GetSubMenu() != NULL)
            {
                CMenu SubMenu;
                SubMenu.CreatePopupMenu();
                bRetVal = ConvertMenu(SubMenu, menuItem.GetSubMenu());
        
                if (bRetVal)
                {
                    bRetVal = p_menu.AppendMenu(MF_POPUP | MF_STRING, (UINT)SubMenu.Detach(), menuItem.GetSubMenuText());
                }                        
            }
            break;

        case MENUID_SEPARATOR:
            bRetVal = p_menu.AppendMenu(MF_SEPARATOR);
            break;

        default:
            ASSERT(pCommand); // must exist
            bRetVal = p_menu.AppendMenu(MF_STRING, menuItem.GetID(), pCommand->GetMenuText());
            break;
        }
    }
    return bRetVal;
}
