

#ifndef __FORMAT_H__
#define __FORMAT_H__

#include "ccanvas.h"
#include "cfont.h"
#include "cpalette.h"
#include "coptions.h"
#include "cArchive.h"
#include "cPage.h"

typedef int fFormatMapType;
const int FMT_NONE	= 0x0000;
const int FMT_SAVE	= 0x0001;
const int FMT_LOAD	= 0x0002;

struct sFormatMap
{
	fFormatMapType	type;
	CString			strExtension;
	CString			strDescription;
};

typedef CList<sFormatMap,const sFormatMap&> tFormatMapList;


typedef ULONG   tFormatSupportFlags;

const ULONG FORMAT_SUPPORT_NONE         = 0x00000000;
const ULONG FORMAT_SUPPORT_FONT         = 0x00000001;
const ULONG FORMAT_SUPPORT_PALETTE      = 0x00000002;
const ULONG FORMAT_SUPPORT_DATA         = 0x00000004;
const ULONG FORMAT_SUPPORT_MULTILAYER   = 0x00000008;

class cFormat
{
public:
    cFormat(LPCTSTR p_tszFormatName, tFormatSupportFlags p_flags);
    virtual ~cFormat();

    virtual BOOL Save(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions) = 0;
    virtual BOOL Load(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions) = 0;

    inline BOOL IsFontSupported() { return m_flags & FORMAT_SUPPORT_FONT; }
    inline BOOL IsPaletteSupported() { return m_flags & FORMAT_SUPPORT_PALETTE; }
    inline BOOL IsDataSupported() { return m_flags & FORMAT_SUPPORT_DATA; }
    inline BOOL IsMultiLayerSupported() { return m_flags & FORMAT_SUPPORT_MULTILAYER; }

	BOOL	IsProperFormat(LPCTSTR p_tszExtension, fFormatMapType p_formatType);

	const tFormatMapList*	GetFormatMapList() const  { return &m_formatMaps; }
	void					AddFormatMap(fFormatMapType type, CString strDescription, CString strExtension);



protected:


private:
    tFormatSupportFlags     m_flags;
    CString                 m_strFormatName;
    tFormatMapList          m_formatMaps;
};

typedef BOOL fnCreateFormat(cFormat** p_ppFormat);

typedef CList<cFormat*,cFormat*> cFormatList;

#endif