// ListeningSocket.cpp: implementation of the CListeningSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "PabloDrawDoc.h"
#include "ListeningSocket.h"
#include "ServingSocketThread.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CListeningSocket::CListeningSocket(CPabloDrawDoc* pDoc)
{
    m_pDoc = pDoc;
    m_pev = NULL;
}

CListeningSocket::~CListeningSocket()
{
}

void CListeningSocket::DisconnectAll(CEvent* p_pev)
{
	CSingleLock(&m_mutex, TRUE);
	if (m_connectionList.IsEmpty())
    {
        p_pev->SetEvent();
    }
    else
    {
        m_pev = p_pev;
	    while (!m_connectionList.IsEmpty())
	    {
		    CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetHead();
		    //pThread->m_pListeningSocket = NULL;
		    pThread->PostThreadMessage(WM_USER_DISCONNECT, 1, 0);
			
			CSingleLock(m_pev, TRUE); // lock this round
			m_pev->ResetEvent();
	    }
    }
}


void CListeningSocket::OnAccept(int nErrorCode)
{
	CSocket soc;

	// Accept the connection using a temp CSocket object.
	Accept(soc);

	// Create a thread to handle the connection. The thread is created suspended so that we can
	// set variables in CConnectThread before it starts executing.
	CServingSocketThread* pThread = (CServingSocketThread*)AfxBeginThread(RUNTIME_CLASS(CServingSocketThread), THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
	if (!pThread)
	{
		soc.Close();
		TRACE("Could not create thread\n");
		return;
	}
	pThread->Initialize(pThread, this, soc.Detach());

	// Now start the thread.
	pThread->ResumeThread();

	CSocket::OnAccept(nErrorCode);
}


void CListeningSocket::Write(const void* pBuf, UINT uiSize, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			cArchive_store(ar,pThread->m_pSocket->m_pFile);
			ar.Write((void*)pBuf, uiSize);
        }
    }
}

void CListeningSocket::Writeul(ULONG ulValue, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			cArchive_store(ar,pThread->m_pSocket->m_pFile);
			ar.Writeul(ulValue);
        }
    }
}

void CListeningSocket::Writeus(USHORT usValue, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			cArchive_store(ar,pThread->m_pSocket->m_pFile);
			ar.Writeus(usValue);
        }
    }
}

void CListeningSocket::Writeuc(UCHAR ucValue, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			cArchive_store(ar,pThread->m_pSocket->m_pFile);
			ar.Writeuc(ucValue);
        }
    }
}
void CListeningSocket::WriteRc(LPRECT rect, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			cArchive_store(ar,pThread->m_pSocket->m_pFile);
			ar.WriteRc(rect);
        }
    }
}

void CListeningSocket::SendPart(cCanvas* pCanvas, CRect rect, CPoint ptDest, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			CClientSocket::SendPart(pThread->m_pSocket->m_pFile, pCanvas, rect, ptDest, GetDocument()->GetApp()->GetOptions());
        }
    }
}

void CListeningSocket::FlushAll(CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
//		if (pThread->m_pSocket && pThread->m_pSocket->m_pArchive) pThread->m_pSocket->m_pArchive->Flush(); //Writeul(ulValue);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
//			cArchive_store(ar,pThread->m_pSocket->m_pFile);
//			ar.Writeuc(ucValue);
		}
    }
}

void CListeningSocket::RemoveSocket(CServingSocketThread* pSocketThread)
{
	CSingleLock(&m_mutex, TRUE);
	POSITION pos,temp;
    pos = m_connectionList.GetHeadPosition();
	while (pos)
	{
		temp = pos;
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (pThread == pSocketThread)
		{
			m_connectionList.RemoveAt(temp);
			break;
		}
	}
    if (m_pev) m_pev->SetEvent(); // signal that we've been removed

}
void CListeningSocket::AddSocket(CServingSocketThread* pSocketThread)
{
	CSingleLock(&m_mutex, TRUE);
	m_connectionList.AddTail(pSocketThread);
}

void CListeningSocket::GetAliasList(CStringList& p_sl, CServingSocket* pSource)
{
	CSingleLock(&m_mutex, TRUE);
    POSITION pos;
    pos = m_connectionList.GetHeadPosition();
    while (pos)
    {
		CServingSocketThread* pThread = (CServingSocketThread*)m_connectionList.GetNext(pos);
        if (!pSource || (pThread->m_hSocket != pSource->m_hSocket))
        {
			if (pThread->GetSocket())
				p_sl.AddTail(pThread->GetSocket()->GetAlias());
		}
    }
}

IMPLEMENT_DYNAMIC(CListeningSocket, CSocket);
