// CharSetView.cpp : implementation file
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "CharSetView.h"
#include "cOptions.h"
#include "MainFrm.h"

// CCharSetView

IMPLEMENT_DYNAMIC(CCharSetView, CWnd)
CCharSetView::CCharSetView()
{
	m_bIsVert = FALSE;
	m_pParentFrame = NULL;
	m_bIsSimpleMode = FALSE;
}

CCharSetView::~CCharSetView()
{
}


BEGIN_MESSAGE_MAP(CCharSetView, CWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

CSize CCharSetView::GetSize(BOOL p_bIsVert)
{
    m_bIsVert = p_bIsVert;
	int iCharMax = 270;
	if (GetMainFrame())
	{
	    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
		CDC& dc = *GetWindowDC();
        cPage* pPage = pDoc->GetCurrentPage();
		if (pPage)
		{
			cCanvas* pCanvas = pPage->GetCanvas();
			cPalette* pPal = pPage->GetPalette();
			cFont* pFont = pPage->GetFont();

			CRect rectClient;
			GetClientRect(rectClient);
			cOptions* pOptions = pDoc->GetApp()->GetOptions();

			TEXTMETRIC tm;
			dc.GetTextMetrics(&tm);

			CPoint ptStart;
			ptStart = (m_bIsVert) ? CPoint(0, 0) : CPoint(0, (rectClient.Height()-pFont->GetSize().cy-tm.tmHeight)/2);

			HGDIOBJ oldfont = dc.SelectObject(GetStockObject(DEFAULT_GUI_FONT));
			CSize sizeMaxString(0,0);
			int c;
			if (m_bIsSimpleMode)
			{
				iCharMax = 0;
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("%i="), c+1);
					CSize sizeString = dc.GetTextExtent(strText);
					iCharMax += sizeString.cx+10;
					if (sizeString.cx > sizeMaxString.cx) sizeMaxString.cx = sizeString.cx;
					if (sizeString.cy > sizeMaxString.cy) sizeMaxString.cy = sizeString.cy;
				}
				if (m_bIsVert)
				{
					iCharMax = (m_bIsVert) ? max(sizeMaxString.cy+3, pFont->GetSize().cy+3) : sizeMaxString.cx+pFont->GetSize().cx;
					iCharMax *= CHARSET_MAX_CHARS;
				}
			}
			else
			{
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("F%i "), c+1);
					CSize sizeString = dc.GetTextExtent(strText);
					if (sizeString.cx > sizeMaxString.cx) sizeMaxString.cx = sizeString.cx;
					if (sizeString.cy > sizeMaxString.cy) sizeMaxString.cy = sizeString.cy;
				}
				iCharMax = (m_bIsVert) ? max(sizeMaxString.cy+5, pFont->GetSize().cy+5) : max(sizeMaxString.cx+1, pFont->GetSize().cx+5);
				iCharMax *= CHARSET_MAX_CHARS;
			}
			dc.SelectObject(oldfont);
		}
	}
	int iWidthMax = (m_bIsSimpleMode && !p_bIsVert) ? 16 : 40;
	
	if (p_bIsVert) return CSize(iWidthMax,iCharMax);
    else return CSize(iCharMax, iWidthMax);
}


// CCharSetView message handlers


void CCharSetView::OnPaint()
{
    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
	CPaintDC dc(this); // device context for painting
	if (pDoc)
	{
        cPage* pPage = pDoc->GetCurrentPage();
		if (pPage)
		{
			cCanvas* pCanvas = pPage->GetCanvas();
			cPalette* pPal = pPage->GetPalette();
			cFont* pFont = pPage->GetFont();

			CRect rectClient;
			GetClientRect(rectClient);
			cOptions* pOptions = pDoc->GetApp()->GetOptions();

			TEXTMETRIC tm;
			dc.GetTextMetrics(&tm);

			CBrush brush(GetSysColor(COLOR_3DFACE));
			dc.FillRect(rectClient, &brush);
			CBrush brushWhite(GetSysColor(COLOR_BTNTEXT));
			CPoint ptStart;

			CBrush* pOldBrush = dc.SelectObject(&brush);
			HGDIOBJ oldfont = dc.SelectObject(GetStockObject(DEFAULT_GUI_FONT));
			CSize sizeMaxString(0,0);
			int c;


			if (m_bIsSimpleMode)
			{
				ptStart = CPoint(0, 0);
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("%i="), c+1);
					CSize sizeString = dc.GetTextExtent(strText);
					if (sizeString.cx > sizeMaxString.cx) sizeMaxString.cx = sizeString.cx;
					if (sizeString.cy > sizeMaxString.cy) sizeMaxString.cy = sizeString.cy;
				}

				int iCharMax = (m_bIsVert) ? max(sizeMaxString.cy+3, pFont->GetSize().cy+3) : sizeMaxString.cx+pFont->GetSize().cx;
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("%i="), c+1);
					CSize sizeString = (m_bIsVert) ? sizeMaxString : dc.GetTextExtent(strText);
					dc.SetBkColor(GetSysColor(COLOR_3DFACE));
					dc.TextOut(ptStart.x, ptStart.y, strText);
					ptStart += CSize(sizeString.cx+1, 0);
					CRect rectChar(ptStart, pFont->GetSize());
					for (int y=0; y<pFont->GetSize().cy; y++)
					{
						for (int x=0; x<pFont->GetSize().cx; x++)
						{
							if (pFont->GetPoint(pOptions->GetCharSetChar(pDoc->GetCurrentCharSet(), c), CPoint(x,y)))
							{
								CRect rect(ptStart + CPoint(x,y) , CSize(1,1));
								dc.FillRect(rect, &brushWhite);
							}
						}
					}
					if (m_bIsVert)
					{
						ptStart -= CSize(sizeString.cx, 0);
						ptStart += (m_bIsVert) ? CSize(0, iCharMax) : CSize(iCharMax, 0);
					}
					else
					{
						ptStart += CSize(pFont->GetSize().cx+1,0);
					}
				}
			}
			else
			{
				ptStart = (m_bIsVert) ? CPoint(0, 0) : CPoint(0, (rectClient.Height()-pFont->GetSize().cy-tm.tmHeight)/2);
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("F%i "), c+1);
					CSize sizeString = dc.GetTextExtent(strText);
					if (sizeString.cx > sizeMaxString.cx) sizeMaxString.cx = sizeString.cx;
					if (sizeString.cy > sizeMaxString.cy) sizeMaxString.cy = sizeString.cy;
				}

				int iCharMax = (m_bIsVert) ? max(sizeMaxString.cy+5, pFont->GetSize().cy+5) : max(sizeMaxString.cx+1, pFont->GetSize().cx+5);
				for (c = 0; c<CHARSET_MAX_CHARS; c++)
				{
					CString strText;
					strText.Format(_T("F%i "), c+1);
					CSize sizeString = sizeMaxString;
					dc.SetBkColor(GetSysColor(COLOR_3DFACE));
					dc.TextOut(ptStart.x, ptStart.y, strText);
					ptStart += (m_bIsVert) ? CSize(sizeString.cx, 0) : CSize(sizeString.cx/4,tm.tmHeight);
					CRect rectChar(ptStart, pFont->GetSize());
					rectChar.InflateRect(1,1,1,1);
					dc.Draw3dRect(rectChar, GetSysColor(COLOR_3DSHADOW), GetSysColor(COLOR_3DHILIGHT));
					for (int y=0; y<pFont->GetSize().cy; y++)
					{
						for (int x=0; x<pFont->GetSize().cx; x++)
						{
							if (pFont->GetPoint(pOptions->GetCharSetChar(pDoc->GetCurrentCharSet(), c), CPoint(x,y)))
							{
								CRect rect(ptStart + CPoint(x,y) , CSize(1,1));
								dc.FillRect(rect, &brushWhite);
							}
						}
					}
					ptStart -= (m_bIsVert) ? CSize(sizeString.cx, 0) : CSize(sizeString.cx/4,tm.tmHeight);
					ptStart += (m_bIsVert) ? CSize(0, iCharMax) : CSize(iCharMax, 0);
				}
			}
			dc.SelectObject(oldfont);
			dc.SelectObject(pOldBrush);
		}
	}



}
