{
 empathy block/line cursoring rotuines
}
unit cursor;
     Interface
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eBlockCursor;
Procedure eHalfBlockCursor;
Procedure eLineCursor;
Procedure eSetCursor(startLine, endLine : byte);
Procedure eGetCursor(Var StartLine, EndLine : Byte);
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Implementation
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Const
  mono = 7;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Var
  origstartline,
  origendline,
  mode : Byte;
  origexitproc : Pointer;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eSetCursor(startline, endline : Byte); Assembler;
Asm
  mov ah, $01
  mov ch, startline
  mov cl, endline
  int $10
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eGetCursor(Var startline, endline : Byte); Assembler;
Asm
  mov ah, $03
  mov bh, $00
  int $10
  les di, startline
  mov Byte ptr es:[di], ch
  les di, endline
  mov Byte ptr es:[di], cl
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eBlockCursor;
begin
  if mode = mono
    then eSetCursor(1, 12)
    else eSetCursor(1, 7);
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eHalfBlockCursor;
begin
  if mode = mono
    then eSetCursor(7, 12)
    else eSetCursor(4, 7);
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eLineCursor;
begin
  if mode = mono
    then eSetCursor(11, 12)
    else eSetCursor(6, 7);
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eRestoreCursor; Far;
begin
  system.exitproc := origexitproc;
end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
begin
 eGetCursor(origstartline, origendline);
 Asm
  mov ah, $0F
  int $10
  mov mode, al
 end;
 origexitproc := system.exitproc;
 system.exitproc := addr(eRestoreCursor);
end.
