{$S-,R-,I-,V-,B-}
unit timeunit;
     interface
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
const
  eTimerResolution = 1193181.667;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure  eInitializeTimer;
Procedure  eRestoreTimer;
Function   eReadTimer : LongInt;
Function   eElapsedTime(Start, Stop : LongInt) : Real;
Function   eElapsedTimeString(Start, Stop : LongInt) : String;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Implementation

Var
  SaveExitProc : Pointer;
  Delta : LongInt;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
  Function Cardinal(L : LongInt) : Real;
    {-Return the unsigned equivalent of L as a Real}
  begin                      {Cardinal}
    if L < 0 then
      Cardinal := 4294967296.0+L
    else
      Cardinal := L;
  end;                       {Cardinal}
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Function eElapsedTime(Start, Stop : LongInt) : Real;
 begin
 eElapsedTime := 1000.0*Cardinal(Stop-(Start+Delta))/eTimerResolution;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Function eElapsedTimeString(Start, Stop : LongInt) : String;
Var R : Real;
    S : String;
 begin
  R := eElapsedTime(Start, Stop);
  Str(R:0:3, S);
  eElapsedTimeString := S;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eInitializeTimer;
 begin
 Port[$43] := $34;
 Inline($EB/$00);
 Port[$40] := $00;
 Inline($EB/$00);
 Port[$40] := $00;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eRestoreTimer;
 begin
  Port[$43] := $36;
  Inline($EB/$00);
  Port[$40] := $00;
  Inline($EB/$00);
  Port[$40] := $00;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Function eReadTimer : LongInt;
 begin
    Inline(
      $FA/                   {cli             ;Disable interrupts}
      $BA/$20/$00/           {mov  dx,$20     ;Address PIC ocw3}
      $B0/$0A/               {mov  al,$0A     ;Ask to read irr}
      $EE/                   {out  dx,al}
      $B0/$00/               {mov  al,$00     ;Latch timer 0}
      $E6/$43/               {out  $43,al}
      $EC/                   {in   al,dx      ;Read irr}
      $89/$C7/               {mov  di,ax      ;Save it in DI}
      $E4/$40/               {in   al,$40     ;Counter --> bx}
      $88/$C3/               {mov  bl,al      ;LSB in BL}
      $E4/$40/               {in   al,$40}
      $88/$C7/               {mov  bh,al      ;MSB in BH}
      $F7/$D3/               {not  bx         ;Need ascending counter}
      $E4/$21/               {in   al,$21     ;Read PIC imr}
      $89/$C6/               {mov  si,ax      ;Save it in SI}
      $B0/$FF/               {mov  al,$0FF    ;Mask all interrupts}
      $E6/$21/               {out  $21,al}
      $B8/$40/$00/           {mov  ax,$40     ;read low Word of time}
      $8E/$C0/               {mov  es,ax      ;from BIOS data area}
      $26/$8B/$16/$6C/$00/   {mov  dx,es:[$6C]}
      $89/$F0/               {mov  ax,si      ;Restore imr from SI}
      $E6/$21/               {out  $21,al}
      $FB/                   {sti             ;Enable interrupts}
      $89/$F8/               {mov  ax,di      ;Retrieve old irr}
      $A8/$01/               {test al,$01     ;Counter hit 0?}
      $74/$07/               {jz   done       ;Jump if not}
      $81/$FB/$FF/$00/       {cmp  bx,$FF     ;Counter > $FF?}
      $77/$01/               {ja   done       ;Done if so}
      $42/                   {inc  dx         ;else count int req.}
      {done:}
      $89/$5E/$FC/           {mov [bp-4],bx   ;set Function result}
      $89/$56/$FE);          {mov [bp-2],dx}
 end;                       {ReadTimer}
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure Calibrate;
Const Reps = 1000;
Var I : Word;
    L1, L2, Diff : LongInt;
 begin
  Delta := MaxInt;
  For I := 1 to Reps do
   begin
   L1 := eReadTimer;
   L2 := eReadTimer;
   Diff := L2-L1;
   if Diff < Delta then Delta := Diff;
   end;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
{$F+}
Procedure OurExitProc;
 begin
 ExitProc := SaveExitProc;
 eRestoreTimer;
 end;
{$F-}
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
begin
  SaveExitProc := ExitProc;
  ExitProc := @OurExitProc;
  eInitializeTimer;
  Calibrate;
end.
