unit ebldfncs;
interface

uses types, zBuild, ans2bin, ansiload,xms_;

procedure build;
var
    articleCount : word;
    txtFile : text;
    datFile : file;
    menuCount : byte;
    magHead : magHeader;
    fnames   : array[1..maxMenus] of ^fileNames;
    mfnames  : array[1..MAXMENUS] of ^string;
    menus : array[1..MAXMENUS] of ^menuHeader;
    iname,ename,hname : string[20];
    startPos,
    currentPos : longInt;
    order : string[3];
    tfname,dfname,exfname : string[20];
    outFile : file;
    usedXMS : boolean;

implementation
procedure cleanup;
var i,s : byte;
begin
   for i := 1 to menuCount do begin
      for s := 1 to menus[i]^.count do begin
         dispose(menus[i]^.articles[s]);
         dispose(fnames[i]^.name[s]);
      end;
      dispose(menus[i]);
      dispose(mfnames[i]);
   end;
   if (usedXMS) then begin
      pipeLn('|07Relasing XMS');
      xms_.xmsReleaseBlock(xmsHandle);
   end;
end;

procedure defaults;
begin
   with magHead do begin
      iname := '';
      ename := '';
      hname := '';
      with system do begin
         fadedelay := 10; scrolldelay := 10; name := 'Generic'; issue := '1';
         doCursor := false; cycle := false; hiColor := false; doSlice := true;
      end;
      with introHeader do begin
         start := 0; stop := 0; hi := ''; lo := ''; author := '';
         title := ''; autoScroll := true; showHeader := false;
         x := 0; y := 0; fade := false; action := 3; id := 0;
      end;
      with exitHeader do begin
         start := 0; stop := 0; hi := ''; lo := ''; author := '';
         title := ''; autoScroll := false; showHeader := false;
         x := 0; y := 0; fade := false; action := 0; id := 0;
      end;
      fillchar(header,sizeOf(headerHeader),0);
      header.line := 1;
   end;
end;

procedure newMenu;
begin
   inc(menuCount);
   new(menus[menuCount]);
   new(mfnames[menuCount]);
   new(fnames[menuCount]);
   with menus[menuCount]^ do begin
      id := 0; fallback := 1; start := 0; stop := 0; fade := false;
      count := 0;
   end;
   mfnames[menuCount]^ := '';
end;

procedure newArticle(id : byte);
begin
   inc(menus[id]^.count);
   new(menus[id]^.articles[menus[id]^.Count]);
   fillchar(menus[id]^.articles[menus[id]^.count]^,sizeOf(itemheader),0);
   new(fnames[id]^.name[menus[id]^.count]);
   fillchar(fnames[id]^.name[menus[id]^.count]^,sizeOf(itemheader),0);
   with menus[id]^.articles[menus[id]^.Count]^ do begin
      start := 0; stop := 0; hi := ''; lo := ''; author := '';
      title := ''; autoScroll := false; showHeader := TRUE;
      x := 0; y := 0; fade := false; action := 0; id := id;
   end;
   fnames[id]^.name[menus[id]^.count]^ := '';
   menus[menuCount]^.articles[menus[menuCount]^.count]^.start := currentPos;
end;

function checkBool(s : string) : boolean;
begin
   if (upString(s) = 'TRUE') or (upString(s) = '1') then checkBool := true
   else checkBool := false;
end;

procedure addItem(id : char);
var str ,
    s   : string;
    f   : file;
    ext : string;
begin
   str := '';
   s := '';
   while (not( eof(txtFile) ) AND not(upString(s) = '[END]' ) ) do begin
      readTfLn(txtFile,s);
      if s <> '' then str := getToken(upString(s),' ',1);
      case ( upCase(id) ) of
         'S' : begin
            if ( str = 'CYCLE' ) then begin
               str := getToken(s,' ',2);
               magHead.system.cycle := checkBool(str);
            end
            else if ( str = 'TIMESLICE' ) then begin
               str := getToken(s,' ',2);
               magHead.system.doSlice := checkBool(str);
            end
            else if ( str = 'HICOLOR' ) then begin
               str := getToken(s,' ',2);
               magHead.system.hicolor := checkBool(str);
            end
            else if ( str = 'SHOWCURSOR' ) then begin
               str := getToken(s,' ',2);
               magHead.system.docursor := checkBool(str);
            end
            else if ( str = 'FADEDELAY' ) then magHead.system.fadedelay := strToByte(getToken(s,' ',2))
            else if ( str = 'SCROLLDELAY' ) then magHead.system.scrolldelay := strToByte(getToken(s,' ',2))
            else if ( str = 'NAME' ) then magHead.system.name := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'ISSUE' ) then magHead.system.issue := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'EXENAME' ) then exfName := getToken(upString(s),' ',2)
            else if ( str = 'DATANAME' ) then dfName := getToken(upString(s),' ',2);
         end;
         'I' : begin
            if ( str = 'AUTOSCROLL' ) then begin
               str := getToken(s,' ',2);
               magHead.introHeader.autoScroll := checkBool(str);
            end
            else if ( str = 'FADE' ) then begin
               str := getToken(s,' ',2);
               magHead.introHeader.fade := checkBool(str);
            end
            else if ( str = 'FILE' ) then begin
               order := order + 'I';
               str := getToken(upString(s),' ',2);
               magHead.introHeader.start := currentPos;
               if (not(copy(str,length(str)-2,3) = 'BIN')) then Convert(str,usedXMS);
               openFile(f,str,1);
               iname := str;
               inc(currentPos,fileSize(f));
               magHead.introHeader.stop := currentPos;
               closeFile(f);
            end
            else begin
            end;
         end;
         'E' : begin
            if ( str = 'AUTOSCROLL' ) then begin
               str := getToken(s,' ',2);
               magHead.exitHeader.autoscroll := checkBool(str);
            end
            else if ( str = 'FADE' ) then begin
               str := getToken(s,' ',2);
               magHead.exitHeader.fade := checkBool(str);
            end
            else if ( str = 'FILE' ) then begin
               order := order + 'E';
               str := getToken(upString(s),' ',2);
               magHead.exitHeader.start := currentPos;
               if (not(copy(str,length(str)-2,3) = 'BIN')) then Convert(str,usedXMS);
               openFile(f,str,1);
               ename := str;
               inc(currentPos,fileSize(f));
               magHead.exitHeader.stop := currentPos;
               closeFile(f);
            end
            else begin
            end;
         end;
         'H' : begin
            if ( str = 'AUTHOR' ) then begin
               magHead.header.authorx := strToByte(getToken(s,' ',2));
               magHead.header.authory := strToByte(getToken(s,' ',3));
            end
            else if ( str = 'TITLE' ) then begin
               magHead.header.titlex := strToByte(getToken(s,' ',2));
               magHead.header.titley := strToByte(getToken(s,' ',3));
            end
            else if ( str = 'PERCENT' ) then begin
               magHead.header.PERCENTx := strToByte(getToken(s,' ',2));
               magHead.header.PERCENTy := strToByte(getToken(s,' ',3));
            end
            else if ( str = 'LINE' ) then begin
               magHead.header.line := strToByte(getToken(s,' ',2));
            end
            else if ( str = 'LENGTH' ) then begin
               magHead.header.PERCENTlen := strToByte(getToken(s,' ',2));
            end
            else if ( str = 'HI' ) then begin
               magHead.header.PERCENThi := getToken(s,' ',2);
            end
            else if ( str = 'LO' ) then begin
               magHead.header.PERCENTlo := getToken(s,' ',2);
            end
            else if ( str = 'FILE' ) then begin
               order := order + 'H';
               str := getToken(upString(s),' ',2);
               magHead.Header.start := currentPos;
               if (not(copy(str,length(str)-2,3) = 'BIN')) then Convert(str,usedXMS);
               openFile(f,str,1);
               hname := str;
               inc(currentPos,fileSize(f));
               magHead.Header.stop := currentPos;
               closeFile(f);
            end;
         end;
         'M' : begin
            if ( str = 'FILE' ) then begin
               str := getToken(upString(s),' ',2);
               menus[menuCount]^.start := currentPos;
               if (not(copy(str,length(str)-2,3) = 'BIN')) then Convert(str,usedXMS);
               openFile(f,str,1);
               mfnames[menuCount]^ := str;
               inc(currentPos,fileSize(f));
               menus[menuCount]^.stop := currentPos;
               closeFile(f);
            end
            else if ( str = 'FADE' ) then begin
               str := getToken(s,' ',2);
               menus[menuCount]^.fade := checkBool(str);
            end
            else if ( str = 'ID' ) then begin
               menus[menuCount]^.id := strToByte(getToken(s,' ',2));
            end
            else if ( str = 'FALLBACK' ) then begin
               menus[menuCount]^.fallback := strToByte(getToken(s,' ',2));
            end
         end;
         else begin
            if ( str = 'AUTHOR' ) then
               menus[menuCount]^.articles[menus[menuCount]^.count]^.author := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'TITLE' ) then
               menus[menuCount]^.articles[menus[menuCount]^.count]^.title := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'HI' ) then
               menus[menuCount]^.articles[menus[menuCount]^.count]^.hi := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'LO' ) then
               menus[menuCount]^.articles[menus[menuCount]^.count]^.LO := stringRest(s,' ',2,numToken(s,' '))
            else if ( str = 'FADE' ) then begin
               str := getToken(s,' ',2);
               menus[menuCount]^.articles[menus[menuCount]^.count]^.fade := checkBool(str);
            end
            else if ( str = 'SHOWHEADER' ) then begin
               str := getToken(s,' ',2);
               menus[menuCount]^.articles[menus[menuCount]^.count]^.showHeader := checkBool(str);
            end
            else if ( str = 'AUTOSCROLL' ) then begin
               str := getToken(s,' ',2);
               menus[menuCount]^.articles[menus[menuCount]^.count]^.autoScroll := checkBool(str);
            end
            else if ( str = 'ACTION' ) then begin
               str := getToken(upString(s),' ',2);
               if ( str = 'SHOW' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 0
               else if ( str = 'JUMP' ) then begin
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 1;
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.start := strToByte(getToken(s,' ',3));
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.stop := strToByte(getToken(s,' ',3));
               end
               else if ( str = 'BACK' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 2
               (* toggle actions *)
               else if ( str = 'TOGGLE' ) then begin
                  str := getToken(upString(s),' ',3);
                  if ( str = 'CYCLE' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 4
                  else if ( str = 'TIMESLICE' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 5
                  else if ( str = 'HICOLOR' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 6
                  else if ( str = 'SHOWCURSOR' ) then menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 7;
               end
               (* end toggle actions *)
               else begin
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.action := 3;
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.start := -1;
                  menus[menuCount]^.articles[menus[menuCount]^.count]^.stop := -1;
               end;
            end
            else if ( str = 'XY' ) then begin
               menus[menuCount]^.articles[menus[menuCount]^.count]^.x := strToByte(getToken(s,' ',2));
               menus[menuCount]^.articles[menus[menuCount]^.count]^.y := strToByte(getToken(s,' ',3));
            end
            else if ( str = 'FILE' ) then begin
               str := getToken(upString(s),' ',2);
               menus[menuCount]^.articles[menus[menuCount]^.count]^.start := currentPos;
               if (not(copy(str,length(str)-2,3) = 'BIN')) then Convert(str,usedXMS);
               openFile(f,str,1);
               fnames[menuCount]^.name[menus[menuCount]^.count]^ := str;
               inc(currentPos,fileSize(f));
               menus[menuCount]^.articles[menus[menuCount]^.count]^.stop := currentPos;
               closeFile(f);
            end;
         end;
      end;
      str := '';
   end;
end;

procedure parseTextFile;
var go : boolean;
    str ,
    s   : string;
begin
   go := true;
   s := '';
   str := '';
   {$I-} reset(txtFile); {$I+}
   if ( ioResult <> 0 ) then go := false;
   while ( go AND not( eof( txtFile ) ) ) do begin
      readTFLn(txtFile,s);
      if s <> '' then str := getToken(upString(s),' ',1);
      if (str = '[INTRO]') then addItem('I')
      else if (str = '[EXIT]') then addItem('E')
      else if (str = '[MENU]') then begin
         newMenu;
         addItem('M')
      end
      else if (str = '[ITEM]') then begin
         newArticle(menuCount);
         addItem(' ');
      end
      else if (str = '[SYSTEM]') then addItem('S')
      else if (str = '[HEADER]') then addItem('H');
      s := '';
      str := '';
   end;
end;


procedure fcopy(s : string);
var f : file;
    numread,numwritten : word;
    fBuf : array[1..8192] of byte;
    ext : string;
begin
   openFile(f,s,1);
   if (fileSize(f) mod 160) <> 0 then begin
      pipeln('Error, file is not an 80xXX binary file, aborting!');
      halt(1);
   end;
   repeat
      BlockRead(f, fBuf, SizeOf(fBuf), NumRead);
      BlockWrite(datFile, fBuf, NumRead, NumWritten);
   until (NumRead = 0) or (NumWritten <> NumRead);
   closeFile(f);
end;

procedure makeDataFile;
var i,s : byte;
    nf : file;
begin
   reset(datFile,1);
   startpos := sizeOf(magHeader);
   for i := 1 to menuCount do
      startpos := startpos + (sizeOf(menuHeader)) + (sizeOf(itemHeader)*menus[i]^.count);
   inc(magHead.introHeader.start,startpos);
   inc(magHead.introHeader.stop,startpos);
   inc(magHead.exitHeader.start,startpos);
   inc(magHead.exitHeader.stop,startpos);
   inc(magHead.header.start,startpos);
   inc(magHead.Header.stop,startpos);
   if magHead.Header.stop-magHead.header.start = 0 then magHead.header.line := 1;
   magHead.menus := menuCount;
   writeF(datFile,1,magHead,sizeOf(magHeader));
   for i := 1 to menuCount do begin
      inc(menus[i]^.start,startpos);
      inc(menus[i]^.stop,startpos);
      for s := 1 to menus[i]^.count do begin
         if menus[i]^.articles[s]^.action = 0 then begin
           inc(menus[i]^.articles[s]^.start,startpos);
           inc(menus[i]^.articles[s]^.stop,startpos);
         end;
      end;
      writeF(datFile,filePos(datFile),menus[i]^,sizeOf(menuHeader));
      for s := 1 to menus[i]^.count do
         writeF(datfile,filePos(datFile),menus[i]^.articles[s]^,sizeOf(itemHeader));
   end;
   i := 1;
   repeat
      case order[i] of
         'I' : fCopy(iName);
         'E' : fCopy(eName);
         'H' : fCopy(hName);
      end;
      inc(i);
   until (i > 3);
   for i := 1 to menuCount do begin
      fCopy(mfnames[i]^);
      for s := 1 to menus[i]^.count do begin
         if menus[i]^.articles[s]^.action = 0 then fcopy(fnames[i]^.name[s]^);
         inc(articleCount);
      end;
   end;
end;

procedure build;
begin
   usedXms := false;
   currentPos := 1;
   menuCount := 0;
   articleCount := 0;
   order := '';
   defaults;
   if (paramCount < 1) then begin
      pipeLn('|12Invalid command line parameters, usage is|08:|NL|15ebuild filename.eb');
      halt(255);
   end;
   tfName := upString(paramStr(1));
   openTextFile(txtFile,tfname);
   parseTextFile;
   makeFile(datFile,dfname,1);
   makeDataFile;
   closeTextFile(txtFile);
   closeFile(datFile);
   openFile(datFile,exfname,1);
   if (fileSize(datFile) > progSize) then writeF(datFile,fileSize(datFile)-sizeOf(dfName),dfName,sizeOf(dfname))
   else writeF(datFile,fileSize(datFile)+1,dfname,sizeOf(dfName));
   closeFile(datFile);
   cleanup;
   pipeln('|08[|07'+progName+' v|15'+progVer+'|08]');
   pipeln('|07Menus|08:|15 '+numToStr(menuCount)+'|NL|07Items|08:|15 '+numToStr(articleCount));
end;

end.