unit ANSILoad;

Interface

var XMSHandle : Word;

Procedure LoadFile(FileName:string;
                   Width:word;
                   MaxLines:longint;
                   var Lines:longint;
                   FindaSig : Boolean);

Implementation uses Crt, XMS_;


Function MaxL(l1,l2:longint): Longint;
Begin
   MaxL := byte(l1 > l2) * l1 + byte(not(l1 > l2)) * l2;
End;

Function MinL(l1,l2:longint):longint;
Begin
   MinL := byte(l1<l2) * l1 + byte(not(l1<l2)) * l2;
End;

Procedure LoadFile(FileName:string; Width:word; MaxLines:longint; var Lines:longint;FindaSig : Boolean);
Type TParmRec = Record
                 B : Word;
                 S : String[3];
                End;
Var
 OldCurAttr : Byte;
 CurCh  : Char;
 F      : File;
 FindasigTripped : Boolean;
 Cntr2, BuffLen, BuffCntr, CurX, SavX:word; CurY, SavY : Longint;
 FSEState, CurAttr, CurParm : Byte;
 FileBuffer : Array[1..8192] of char;
 Parameter  : Array[1..10] of TParmRec;

Procedure PutCharAttr(x:word; y:longint; Ch:char; Attr:byte);
Var Tmp:word;
Begin
 Tmp := Word(Ch)+Word(Attr shl 8);
 xms_.xmsMoveDataTo(XMSHandle,(pred(Y)*Width+pred(X))*2,2,@Tmp);
End;

Procedure DoColors;
Var Cntr : Byte;
    Fore,Back : Byte;
Begin
   If CurParm = 0 then exit;
   For Cntr := 1 to CurParm do Begin
      If FindasigTripped then Begin
         FindasigTripped := False;
         Curattr := OldCurAttr;
      End;
      Case Parameter[Cntr].b of
         0 :  CurAttr := $07;
         1 :  CurAttr:=CurAttr or $08;{asm or Attr, 08h end;}
         5 :  CurAttr:=CurAttr or $80;{asm or Attr, 80h end;}
         7 :  Asm
        mov     ax, word ptr CurAttr
        mov     bx, ax
        and     ax, 0707h
        xchg    ah, al
        and     bx, 80h
        add     ax, bx
        mov     word ptr CurAttr, bx
         End;
         25 : CurAttr := (CurAttr AND (NOT $80)); {blink off}
         30 : CurAttr := (CurAttr AND $F8) + black;
         31 : CurAttr := (CurAttr AND $f8) + red;
         32 : CurAttr := (CurAttr AND $f8) + green;
         33 : CurAttr := (CurAttr AND $f8) + brown;
         34 : CurAttr := (CurAttr AND $f8) + blue;
         35 : CurAttr := (CurAttr AND $f8) + magenta;
         36 : CurAttr := (CurAttr AND $f8) + cyan;
         37 : CurAttr := (CurAttr AND $f8) + Lightgray;
         40 : CurAttr := (CurAttr AND $8F) + (black shl 4);
         41 : CurAttr := (CurAttr AND $8F) + (red shl 4);
         42 : CurAttr := (CurAttr AND $8F) + (green shl 4);
         43 : CurAttr := (CurAttr AND $8F) + (brown shl 4);
         44 : CurAttr := (CurAttr AND $8F) + (blue shl 4);
         45 : CurAttr := (CurAttr AND $8F) + (magenta shl 4);
         46 : CurAttr := (CurAttr AND $8F) + (cyan shl 4);
         47 : CurAttr := (CurAttr AND $8F) + (lightgray shl 4);
      End;
   If FindASig Then Begin
      {If (Lo(Textattr) = 0) and (Hi(TextAttr) = 0) then TextAttr := 15;}
      Fore := (CurAttr and $0f);
      Back := (CurAttr and $f0) shr 4;
      {Fore := CurAttr And $0F;
      Back := (CurAttr Shr 4) And $08;}
      If (Fore = 0) and (Back = 0) Then Begin
         OldCurattr := Curattr;
         CurAttr := 15;
         FindaSigTripped := True;
      End;
   End;
End;
End;

Procedure PutCh(CH : Char);
Begin
   Case CH of
      #8 : Begin
         If CurX > 1 then Begin
            Dec(CurX);
            PutCharAttr(CurX, CurY, ' ', CurAttr);
         End;
      End;
      #10 : If CurY < MaxLines then Inc(CurY);
      #13 : CurX:=1;

      #1..
      #7,
      #11,
      #14..
      #255: Begin
         PutCharAttr(CurX, CurY, Ch, CurAttr);
         Inc(CurX);
         If CurX > Width then Begin
            CurX := 1;
            If CurY < (MaxLines-1) then Inc(CurY);
         End;
      End;
   End; { Case }
   Lines:=MaxL(Lines, CurY);
End;

Begin
 FindAsigTripped := False;
 Assign(f,FileName);
 {$I-} Reset(f,1); {$I+}
 If IOResult<>0 then Exit;
 FSEState := 0;
 CurAttr  := 7;
 FillChar(Parameter, SizeOf(Parameter), 0);
 CurX := 1; CurY := 1; Lines := 0; SavX := 1; SavY := 1;
 Repeat
  BlockRead(f, FileBuffer, sizeOf(fileBuffer), BuffLen);
  For BuffCntr := 1 to BuffLen do
   Begin
    CurCh := FileBuffer[BuffCntr];
    Case FSEState of
     0 : Case CurCh of
          #26 : begin close(f); Exit; end;
          #27 : inc(FSEState);
           #9 : if CurX<Width-8 then CurX:=((CurX shr 3)+1)shl 3;
           else PutCh(CurCh);
         end;
     1 : Begin
          If CurCh='[' then
           begin
            inc(FSEState);
            CurParm:=0;
            Parameter[1].b := 0;
            Parameter[1].s := '';
           End else
           Begin
            PutCh(#27);
            PutCh('[');
            FSEState:=0;
           End;
         End;
     2 : Begin
          Case CurCh of
           '0'..'9','?','=','"' :
            Begin
             if CurParm=0 then CurParm:=1;
             Parameter[CurParm].s:=Parameter[CurParm].s+CurCh;
             if CurCh in ['0'..'9'] then Parameter[CurParm].b:=(Parameter[CurParm].b*10)+(ord(CurCh)-ord('0'))
                else begin
                      if CurParm<10 then inc(CurParm);
                      Parameter[CurParm].b:=0;
                      Parameter[CurParm].s[0]:=#0;
                     end;
            End;
           ';' : Begin
                  if CurParm < 10 then inc(CurParm);
                  Parameter[CurParm].b:=0;
                  Parameter[CurParm].s[0]:=#0;
                 End;
           'H','f': Begin
                     if CurParm>=1 then CurY:=MaxL(1,MinL(Parameter[1].b,MaxLines));
                     if CurParm>=2 then CurX:=MaxL(1,MinL(Parameter[2].b,Width));
                     FSEState:=0;
                    End;
           'A' : Begin
                  CurY:=MaxL(1,CurY-MaxL(1,Parameter[1].b));
                  FSEState:=0;
                 End;
           'B' : Begin
                  CurY:=MinL(CurY+MaxL(1,Parameter[1].b),MaxLines);
                  FSEState:=0;
                 End;
           'C' : Begin
                  CurX:=MinL(CurX+MaxL(1,Parameter[1].b),Width);
                  FSEState:=0;
                 End;
           'D' : Begin
                  CurX:=MaxL(1,CurX-MaxL(1,Parameter[1].b));
                  FSEState:=0;
                 End;
           'J' : Begin
                  Case Parameter[1].b of
                   0 : for Cntr2:=CurX to Width do PutCharAttr(Cntr2,CurY,' ', CurAttr);
                   1,2: begin
                         CurX:=1; CurY:=1;
                        End;
                  End;
                  FSEState:=0;
                 End;
           'K' : Begin
                  for Cntr2:=CurX to Width do PutCharAttr(Cntr2, CurY, ' ', CurAttr);
                  FSEState:=0;
                 end;
           'm' : Begin
                  DoColors;
                  FSEState:=0;
                 End;
           's' : Begin
                  SavX:=CurX;
                  SavY:=CurY;
                  FSEState:=0;
                 End;
           'u' : Begin
                  CurX:=SavX;
                  CurY:=SavY;
                  FSEState:=0;
                 End;
           'h' : FSEState:=0;
          End;
         End;
     End;
   End;
 Until (BuffLen<sizeOf(fileBuffer)) or Eof(F);
 Close(f);
End;

Procedure PutScreen(Col:word; Line:longint);
Const LookupTbl:Array[0..8] of byte=(8,0,1,2,3,4,5,6,7);
Var WritePtr : Longint;
Begin
   WritePtr:=(((Line shr 4)*(80))+(Col shr 3))shl 1;
   Port[$3D4] :=$08;
   Port[$3D5] :=(Port[$3D5] and $E0) or (Line AND 15);
   Port[$3C0] :=$33;
   Port[$3C0]:=(Port[$3C0] and $F0) or (LookupTbl[Col and $07]);
   asm cli end;
   while (Port[$3DA] and 8)=8 do;
   xms_.xmsGetDataFrom(XMSHandle,WritePtr, 4160,ptr($B800,0));
   while (Port[$3DA] and 8)<>8 do;
   asm sti end;
End;

{Procedure LoadAnsi(FileName:string,Tmp : LongInt);
Var
  NumLines:longint;
Begin
 TextAttr := 8;
 ClrScr;
 Maxlines := 1000;
 LoadFile(FileName,80,Tmp,NumLines);
{ ReadText(XMSHandle, NumLines, 80);}
{ XMSFreeEMB(XMSHandle);}
{ asm mov ax,3; int 10h; end;
 asm mov ah,1; mov cx,2000h;Int 10h end; {No Cursor}
{End;}

begin
end.