unit zBuild;

interface

{  Includes  }
uses crt, dos;

{   Types    }
type   rgb     = record r, g, b : byte; end;
       paltype = array[0..255] of rgb;
       TFont = array[1..4096] of char;
{ Variables  }

{ Constants  }
const
   doSlice      : boolean = true;
   zVer         = '.5';
   zDate        = '12/4/98';
   zLogo        = '(zBUILD)';
   zLogoColor   = '|08(|15z|07BUILD|08)';
   F1 = 59;   F2 = 60;   F3 = 61;   F4 = 62;   F5 = 63;   F6 = 64;
   F7 = 65;   F8 = 66;   F9 = 67;   F10 = 68;  SHIFT_F1 = 84;
   SHIFT_F2 = 85;        SHIFT_F3 = 86;        SHIFT_F4 = 87;
   SHIFT_F5 = 88;        SHIFT_F6 = 89;        SHIFT_F7 = 90;
   SHIFT_F8 = 91;        SHIFT_F9 = 92;        SHIFT_F10 = 93;
   CTRL_F1 = 94;         CTRL_F2 = 95;         CTRL_F3 = 96;
   CTRL_F4 = 97;         CTRL_F5 = 98;         CTRL_F6 = 99;
   CTRL_F7 = 100;        CTRL_F8 = 101;        CTRL_F9 = 102;
   CTRL_F10 = 103;       ALT_F1 = 104;         ALT_F2 = 105;
   ALT_F3 = 106;         ALT_F4 = 107;         ALT_F5 = 108;
   ALT_F6 = 109;         ALT_F7 = 110;         ALT_F8 = 111;
   ALT_F9 = 112;         ALT_F10 = 113;        ALT_Q = 16;
   ALT_W = 17;           ALT_E = 18;           ALT_R = 19;
   ALT_T = 20;           ALT_Y = 21;           ALT_U = 22;
   ALT_I = 23;           ALT_O = 24;           ALT_P = 25;
   ALT_A = 30;           ALT_S = 31;           ALT_D = 32;
   ALT_F = 33;           ALT_G = 34;           ALT_H = 35;
   ALT_J = 36;           ALT_K = 37;           ALT_L = 38;
   ALT_Z = 44;           ALT_X = 45;           ALT_C = 46;
   ALT_V = 47;           ALT_B = 48;           ALT_N = 49;
   ALT_M = 50;           CTRL_PRTSC = 114;     ALT_1 = 120;
   ALT_2 = 121;          ALT_3 = 122;          ALT_4 = 123;
   ALT_5 = 124;          ALT_6 = 125;          ALT_7 = 126;
   ALT_8 = 127;          ALT_9 = 128;          ALT_0 = 129;
   ALT_MINUS = 130;      ALT_EQUAL = 131;      ARROW_HOME = 71;
   ARROW_UP = 72;        ARROW_PGUP = 73;      ARROW_LEFT = 75;
   ARROW_RIGHT = 77;     ARROW_END = 79;       ARROW_DOWN = 80;
   ARROW_PGDN = 81;      CTRL_HOME = 119;      CTRL_END = 117;
   ENTER = 13;           ESCAPE = 27;          TAB = 9;


var tasker : byte;

{ Procedures }

(* File I/O *)
procedure openFile(var f : file; fname : string; recSize : word);
procedure closeFile(var f : file);
procedure makeFile(var f : file;fname : string; recSize : word);
procedure openTextFile(var f : text;fname : string);
procedure closeTextFile(var f : text);
procedure makeTextFile(var f : text;fname : string);
procedure readF(var f : file; offset : longInt; var buf; recSize : word);
procedure writeF(var f : file; offset : longInt; var buf; recSize : word);
procedure readTfLn(var f : text; var s : string);
procedure writeTfLn(var f : text; var s : string);
procedure readTf(var f : text; var c : char);
procedure writeTf(var f : text; var c : char);

(* Error Handling *)
function checkError(code : byte; kill : boolean) : boolean;

(* I/O *)
procedure pipe(str : string);
procedure pipeLn(str : string);
procedure percentBar(cur, max : word; len, x, y : byte;hi,lo : string );
function yesNo(str, yes, no : string; x, y : byte; default : boolean) : boolean;
procedure colorToAttr(var attr : byte; fg , bg : byte);
procedure attrToColor(attr : byte; var fg, bg : byte);
procedure nl;
procedure cls;
procedure waitRetrace;                                           (* Taken from Beyond The Horizon 4 *)
procedure HideCursor;                                            (* Taken from Beyond The Horizon 4 *)
procedure ShowCursor;                                            (* Taken from Beyond The Horizon 4 *)
procedure cDelay(ms : word );                                    (* Taken from Beyond The Horizon 4 *)
procedure GoXY(x,y : byte);                                      (* Taken from S.W.A.G. *)
function getX : byte;
function getY : byte;

(* Effects *)
procedure HighBackground(On : boolean);                          (* Taken from Impulse BBS Software *)
procedure get_color(var pal : paltype);                          (* Taken from Beyond The Horizon 4 *)
procedure set_intensity(var pal : paltype; intensity : byte);    (* Taken from Beyond The Horizon 4 *)
procedure set_to_color(var pal : paltype;r,g,b,h: integer);      (* Taken from Beyond The Horizon 4 *)
procedure fade_out(var pal : paltype;t : integer);               (* Taken from Beyond The Horizon 4 *)
procedure fade_in(var pal : paltype; t : integer);               (* Taken from Beyond The Horizon 4 *)
procedure flash_in(var pal : paltype;r,b,g: byte;t : integer);   (* Taken from Beyond The Horizon 4 *)
procedure flash_out(var pal : paltype;r,g,b: byte;t : integer);  (* Taken from Beyond The Horizon 4 *)
procedure setFont(var font : TFont);
procedure resetFont;

(* Misc *)
function numToStr(num : longInt) : string;
function strToByte(str : string) : byte;
function xyToOffset(x , y : byte) : word;
procedure quit(s : string; code : byte);
function upString(str : string) : string;
function GetToken(aString, SepChar: String; TokenNum: Byte):String;     (* Taken from S.W.A.G. *)
function NumToken(aString, SepChar: String):Byte;                       (* Taken from S.W.A.G. *)
function stringRest(aString,sepChar : string;start , stop : byte) : string;
Function FindTasker : Byte;                                      (* thanks to skaboy *)
Procedure TimeSlice;                                             (* thanks to skaboy *)

implementation

procedure openFile(var f : file; fname : string; recSize : word);
begin
   assign(f,fname);
   {$I-} reset(f,recSize); {$I+}
   checkError(ioResult,TRUE);
end;

procedure closeFile(var f : file);
begin
   {$I-} close(f); {$I+}
   checkError(ioResult,TRUE);
end;

procedure makeFile(var f : file;fname : string; recSize : word);
begin
   assign(f,fname);
   {$I-} rewrite(f,recSize); {$I+}
   checkError(ioResult,TRUE);
end;

procedure openTextFile(var f : text;fname : string);
begin
   assign(f,fname);
   {$I-} reset(f); {$I+}
   checkError(ioResult,TRUE);
end;

procedure closeTextFile(var f : text);
begin
   {$I-} close(f); {$I+}
   checkError(ioResult,TRUE);
end;

procedure makeTextFile( var f : text;fname : string);
begin
   assign(f,fname);
   {$I-} rewrite(f); {$I+}
   checkError(ioResult,TRUE);
end;

procedure readF(var f : file; offSet : longInt; var buf; recSize : word);
begin
   {$I-} seek(f,offSet); {$I+}
   if not(checkError(ioResult,TRUE)) then begin
      {$I-} blockRead(f,buf,recSize); {$I+}
      checkError(ioResult,TRUE);
   end;
end;

procedure writeF(var f : file; offset : longInt; var buf; recSize : word);
begin
   {$I-} seek(f,offSet); {$I+}
   if not(checkError(ioResult,TRUE)) then begin
      {$I-} blockWrite(f,buf,recSize); {$I+}
      checkError(ioResult,TRUE);
   end;
end;

procedure readTfLn(var f : text; var s : string);
begin
   {$I-} readLn(f,s); {$I+}
   checkError(ioResult,TRUE);
end;

procedure writeTfLn(var f : text; var s : string);
begin
   {$I-} writeLn(f,s); {$I+}
   checkError(ioResult,TRUE);
end;

procedure readTf(var f : text; var c : char);
begin
   {$I-} read(f,c); {$I+}
   checkError(ioResult,TRUE);
end;

procedure writeTf(var f : text; var c : char);
begin
   {$I-} write(f,c); {$I+}
   checkError(ioResult,TRUE);
end;

function checkError(code : byte; kill : boolean) : boolean;
begin
   if code <> 0 then begin
      pipeLn('|12Exiting with error code|08:|15 '+numToStr(code));
      if kill then halt(code);
      checkError := true;
   end
   else checkError:= false;
end;

procedure pipe(str : string);
var
   one, two : char;
   oldAttr,
   cnt : byte;
   tmp : string[2];
   xPoint,yPoint : byte;
begin
   if (pos('|',str) = 0) then begin
      write(str);
      exit;
   end;
   randomize;
   cnt := 1;
   oldAttr := textAttr;
   while (cnt <= length(str)) do begin
      if (str[cnt] = '|') then begin
         inc(cnt);
         one := upCase(str[cnt]);
         inc(cnt);
         two := upCase(str[cnt]);
         case one of
            '0' : begin
               case two of
                  '0'..'9' : textAttr := ord(two) AND $0F;
                  else write('|0'+two);
               end;
            end;
            '1' : begin
               case two of
                  '0'..'5' : textAttr := 10+(ord(two) AND $0F);
                  else write('|1'+two);
               end;
            end;
            'B' : begin
               case two of
                  '0'..'9' : textAttr := textAttr + (ord(two) AND $0F) shl 4;
                  'A'..'F': textAttr := textAttr + (ord(two) - 55) shl 4;
                  else write('|B'+two);
               end;
            end;
            'C' : begin
               case two of
                  'L' : cls;
                  else write('|L'+two);
               end;
            end;
            'N' : begin
               case two of
                  'L' : nl;
                  else write('|N'+two);
               end;
            end;
            'R' : begin
               case two of
                  'B' : textAttr := textAttr + random(15) shl 4;
                  'C' : textAttr := random(255);
                  'F' : textAttr := random(15);
                  else write('|R'+two);
               end;
            end;
            'X' : begin
               case two of
                  'Y' : begin
                     tmp := str[cnt+1] + str[cnt+2];
                     inc(cnt,2);
                     xpoint := strToByte(tmp);
                     tmp := str[cnt+1] + str[cnt+2];
                     inc(cnt,2);
                     ypoint := strToByte(tmp);
                     if xpoint = 0 then xpoint := getX;
                     if ypoint = 0 then ypoint := getY;
                     goToXy(xpoint,ypoint);
                  end;
                  else write('|X'+two);
               end;
            end;
            else write('|'+one+two);
         end;
      end
      else write(str[cnt]);
      inc(cnt);
   end;
   textAttr := oldAttr;
end;

procedure pipeLn(str : string);
begin
   pipe(str);
   nl;
end;

procedure percentBar(cur, max : word; len, x, y : byte;hi,lo : string );
var
   percent : word;
   count : byte;
begin
   goXY(x,y);
   if cur > max then cur := max;
   percent := round((cur/max) * len);
   count := 1;
   while (count <= percent) do begin
      pipe(hi);
      inc(count);
   end;
   while (count <=len) do begin
      pipe(lo);
      inc(count);
   end;
end;

function yesNo(str, yes, no : string; x, y : byte; default : boolean) : boolean;
var
   key : char;
   stop : boolean;
begin
   stop := false;
   repeat
      goXY(x,y);
      if (default) then pipe(str+yes)
      else pipe(str+no);
      repeat
         if doSlice then timeSlice;
      until keyPressed;
{      while not(keyPressed) do if doSlice then timeSlice;}
      if (keyPressed) then key := readkey;
      case key of
         'y','Y' : begin
            default := true;
            stop := true;
         end;
         'n','N' : begin
            default := false;
            stop := true;
         end;
         chr(ARROW_LEFT),
         chr(ARROW_RIGHT),
         chr(ARROW_UP),
         chr(ARROW_DOWN) :
            default := not(default);
         chr(ENTER) :
            stop := true;
      end;
   until (stop);
   yesNo := default;
end;


procedure colorToAttr(var attr : byte; fg , bg : byte); assembler;
asm
        mov     al, 15
        mul     bg
        add     al, fg

        les     di, dword ptr attr
        mov     es:[di], al
end;

procedure attrToColor(attr : byte; var fg, bg : byte); assembler;
asm

        mov     al, attr
        and     al, 15
        les     di, dword ptr fg
        mov     es:[di], al
        mov     al, attr
        shr     al, 4
        les     di, dword ptr bg
        mov     es:[di], al
end;

procedure nl;
begin
   writeLn;
end;

(* Clears the screen, then moves the cursor to the upper left hand corner *)

procedure cls; assembler;
Asm

(* point es:di at the 80x25 color screen *)
         cld

         mov    di, 0B800h
         mov    es, di
         mov    di, 0

(* Fill the screen with 0's, effectivley clearing it *)

        xor     ax, ax
        mov     cx, 2000
        rep     stosw

(* call the dos interrupts to position the cursor at the upper left
   hand corner *)

        xor     dx, dx
        mov     ah, 2
        mov     bh, 0
        int     10h
end;


(* Taken from Beyond The Horizon 4 *)
Procedure WaitRetrace; assembler;
asm
        mov     dx,3DAh
@l1:    in      al,dx
        and     al,08h
        jnz     @l1
@l2:    in      al,dx
        and     al,08h
        jz      @l2
end;

(* Taken from Beyond The Horizon 4 *)
procedure HideCursor; Assembler;
asm
        mov     ah,1
        mov     ch,20h
        int     10h
end;

(* Taken from Beyond The Horizon 4 *)
procedure ShowCursor; Assembler;
asm
        mov     ah,1
        mov     cx,506h
        int     10h
end;

(* Taken from Beyond The Horizon 4 *)
procedure cDelay(ms : Word); Assembler;
asm
        mov     ax, 1000;
        mul     ms;
        mov     cx, dx;
        mov     dx, ax;
        mov     ah, 86h;
        int     15h;
end;

(* Taken from S.W.A.G. *)
procedure GoXY(x,y : byte); assembler;
asm
        mov     dh,y
        dec     dh
        mov     dl,x
        dec     dl
        mov     ah,2
        mov     bh, 0
        int     10h
end;

function getX : byte; assembler;
asm
        mov     ah, 3
        mov     bh, 0
        int     10h
        mov     al, dl
        inc     al
end;

function getY : byte; assembler;
asm
        mov     ah, 3
        mov     bh, 0
        int     10h
        mov     al, dh
        inc     al
end;

(* Taken from Impulse BBS Software *)
procedure HighBackground(On : boolean); assembler;
Asm
        mov     ax, 1003h
        xor     bh, bh
        mov     bl, on
        int     10h
end;

(* Taken from Beyond The Horizon 4 *)
procedure get_color(var pal : paltype);
var
   count : registers;
begin
   port[$3C7] := $00;
   count.cx := 0;
   repeat
      pal[count.cx].r := port[$3C9];
      pal[count.cx].g := port[$3C9];
      pal[count.cx].b := port[$3C9];
      inc(count.cx);
   until count.cx > 255;
end;

(* Taken from Beyond The Horizon 4 *)
procedure set_intensity(var pal : paltype; intensity : byte);
var
   count : registers;
begin
   port[$3C8] := $00;
   count.cx := 0;
   repeat
      port[$3C9] := (pal[count.cx].r*intensity) div 63;
      port[$3C9] := (pal[count.cx].g*intensity) div 63;
      port[$3C9] := (pal[count.cx].b*intensity) div 63;
      inc(count.cx);
   until count.cx > 255;
end;

(* Taken from Beyond The Horizon 4 *)
procedure set_to_color(var pal : paltype;r,g,b,h: integer);
var
   count : registers;
begin
   port[$3C8] := $00;
   count.cx := 0;
   h := h div 63;
   repeat
      port[$3C9] := pal[count.cx].r + (r-pal[count.cx].r)*h;
      port[$3C9] := pal[count.cx].g + (g-pal[count.cx].g)*h;
      port[$3C9] := pal[count.cx].b + (b-pal[count.cx].b)*h;
      inc(count.cx);
   until count.cx > 255;
end;

(* Taken from Beyond The Horizon 4 *)
procedure fade_out(var pal : paltype;t : integer);
var
   count : registers;
begin
   count.cx := 63;
   repeat
      waitretrace;
      set_intensity(pal,count.cx);
      cDelay(t);
      dec(count.cx);
   until count.cx = 0;
end;

procedure fade_in(var pal : paltype; t : integer);  {fades from black to pal}
var
   count : registers;
begin
   count.cx := 0;
   repeat
      waitretrace;
      set_intensity(pal,count.cx);
      cDelay(t);
      inc(count.cx);
   until count.cx > 63;
end;

(* Taken from Beyond The Horizon 4 *)
procedure flash_in(var pal : paltype;r,b,g: byte;t : integer);
var
   count : registers;
begin
   count.cx := 0;
   repeat
      waitretrace;
      set_to_color(pal,r,b,g,count.cx);
      cDelay(t);
      inc(count.cx);
   until count.cx > 63;
end;

(* Taken from Beyond The Horizon 4 *)
procedure flash_out(var pal : paltype;r,g,b: byte;t : integer);
var
   count : registers;
begin
   count.cx := 64;
   repeat
      waitretrace;
      set_to_color(pal,r,g,b,count.cx);
      cDelay(t);
      dec(count.cx);
   until count.cx = 0;
end;

procedure setFont(var font : TFont); assembler;
asm
        mov     bx, 4096
        les     bp, font
        mov     ax, 4368
        mov     cx, 256
        xor     dx, dx
        int     16h
end;
{var regs : registers;
begin
   regs.bx:=(16*256);      {0x1000;  16 scanline font}
{   regs.es:=seg(font);     {segment of the font data}
{   regs.bp:=ofs(font);     {offset of the font data}
{   regs.ax:=((17*256)+16); {0x1110;  int 10h subfunction}
{   regs.cx:=256;           {256 characters}
{   regs.dx:=0;             {start with char #0}
{   Intr(16, Regs);         {load actual data $10}
{end;}

Procedure resetFont; assembler;
asm
        mov     ah, 3;
        int     10h;
end;

function numToStr(num : longInt) : string;
var
   s : string[11];
begin
   str(num,s);
   numToStr := s;
end;

function strToByte(str : string) : byte;
var
   b : byte;
   i : integer;
begin
   val(str,b,i);
   strToByte := b;
end;

function xyToOffset(x , y : byte) : word; assembler;
asm
        mov     ax, 160
        dec     y
        mul     y
        dec     x
        add     ax, word ptr x
        add     ax, word ptr x
end;
procedure quit(s : string; code : byte);
begin
   pipeLn(s);
   pipeLn(zLogoColor + ' |07' + zVer + ' - ' + zDate + '|08(|15' + numToStr(code) + '|08)');
   halt(code);
end;

function upString( str : string ) : string; ASSEMBLER;
asm
        PUSH    DS
        CLD
        LDS     SI, str
        xor     ax, ax
        LODSB
        XCHG    AX, CX
        LES     DI, @Result
        MOV     BYTE PTR ES:[DI], CL
        JCXZ    @@3
        INC     DI

@@1:    LODSB
        CMP     AL, 'a'
        JB      @@2
        CMP     AL, 'z'
        JA      @@2
        XOR     AL, $20

@@2:    STOSB
        LOOP    @@1

@@3:    POP     DS
END;

(* Taken from S.W.A.G. *)
function GetToken(aString, SepChar: String; TokenNum: Byte):String;
var
   Token     : String;
   TNum      : Byte;
   TEnd      : Byte;
begin
   TNum   := 1;
   TEnd   := length(aString);
   while ((TNum <= TokenNum) and (TEnd <> 0)) do begin
      TEnd := Pos(SepChar,aString);
      if TEnd <> 0 then begin
         Token := Copy(aString,1,TEnd-1);
         Delete(aString,1,TEnd);
         Inc(TNum);
      end
      else Token := aString;
      if TNum >= TokenNum then GetToken := Token
      else GetToken := '';
   end;
end;

(* Taken from S.W.A.G. *)
function NumToken(aString, SepChar: String):Byte;
var
   RChar     : Char;
   TNum      : Byte;
   TEnd      : Byte;

begin
   if SepChar = '#' then RChar := '*'
   else RChar := '#';
   TNum   := 0;
   TEnd   := length(aString);
   while TEnd <> 0 do begin
      Inc(TNum);
      TEnd := Pos(SepChar,aString);
      if TEnd <> 0 then aString[TEnd] := RChar;
   end;
   NumToken := TNum;
end;

function stringRest(aString, sepChar : string;start , stop : byte) : string;
var s : string;
    i : byte;
begin
   s := '';
   i := start;
   while (i <= stop) do begin
      s := s + getToken(aString,sepChar,i);
      if not(i = stop) then s := s + sepChar;
      inc(i);
   end;
   stringRest := s;
end;

(* Taken from skaboy *)
Function FindTasker : Byte; Assembler;
Asm
        MOV     AX, $160A
        INT     $2F
        CMP     AX, $00
        JE      @SETWIN
        MOV     AX, $3001
        INT     $21
        CMP     AL, $14
        JE      @SETOS2
        MOV     AX, $2B01
        MOV     CX, $4445
        MOV     DX, $5351
        INT     $21
        CMP     AL, $FF
        JNE     @SETDVX
        MOV     AX, $7A00
        INT     $2F
        CMP     AL, $FF
        JE      @SETNOV
        MOV     TASKER, 0
        JMP     @EXIT
@SETOS2:
        MOV     TASKER, 2
        JMP     @EXIT
@SETWIN:
        MOV     TASKER, 3
        JMP     @EXIT
@SETDVX:
        MOV     TASKER, 1
        JMP     @EXIT
@SETNOV:
        MOV     TASKER, 4
@EXIT:
        MOV     AL, TASKER
End;


(* Take from skaboy *)
Procedure TimeSlice; Assembler;
Asm
        CMP     TASKER, 0
        JE      @GIVEDOS
        CMP     TASKER, 1
        JE      @GIVEDVX
        CMP     TASKER, 2
        JE      @GOS2WIN
        CMP     TASKER, 3
        JE      @GOS2WIN
        MOV     BX,$000A
        INT     $7A
        JMP     @DONE
@GIVEDOS:
        INT     $28
        JMP     @DONE
@GIVEDVX:
        MOV     AX, $1000
        INT     $15
        JMP     @DONE
@GOS2WIN:
        MOV     AX, $1680
        INT     $2F
@DONE:
End;

end.
