unit ebfncs;

interface

uses types, zBuild,crt;

procedure startEb;

var hdr : magHeader;
    menuCount : byte;
    menus : array[1..MAXMENUS] of ^menuHeader;
    item : itemHeader;
    datFile : file;
    pal     : palType;
    faded : boolean;
    dfName : string[20];
    saveCount : byte;

implementation

procedure writeBinArticle(start,stop : longint);
var outFile : file;
    fbuf : array[1..80] of word;
    cnt : word;

begin
   if length(dfname) = 12 then makeFile(outFile,copy(dfname,1,length(dfname)-5)+numToStr(saveCount)+'.bin',1)
   else makeFile(outFile,copy(dfname,1,length(dfname)-4)+numToStr(saveCount)+'.bin',1);
   seek(datFile,start);
   stop := (stop - start) div 160;
   cnt := 1;
   repeat
      blockRead(datFile,fbuf,160);
      blockWrite(outFile,fbuf,160);
      inc(cnt);
   until cnt > stop;
   closeFile(outFile);
   inc(saveCount);
end;

procedure writeTextArticle(start,stop : longint);
var outFile : text;
    cnt : word;
    junk,
    b : array[1..160] of byte;
    c2 : byte;
begin

   if length(dfname) = 12 then makeTextFile(outFile,copy(dfname,1,length(dfname)-5)+numToStr(saveCount)+'.txt')
   else makeTextFile(outFile,copy(dfname,1,length(dfname)-4)+numToStr(saveCount)+'.txt');
   seek(datFile,start);
   stop := (stop-start) div 160;
   cnt := 1;
   repeat
      blockRead(datFile,b,160);
      c2 := 1;
      repeat
         write(outFile, chr(b[c2]));
         inc(c2, 2);
      until (c2 > 160);
      writeLn(outFile);
      inc(cnt);
   until cnt > stop;
   closeTextFile(outFile);
   inc(saveCount);
end;


procedure drawHeader(num : byte);
begin
   if (hdr.header.stop-hdr.header.start <> 0) then begin
      readF(datFile,hdr.header.start,mem[$B800:0],hdr.header.stop-hdr.header.start);
      goxy(hdr.header.authorX,hdr.header.authorY);
      pipe(menus[menuCount]^.articles[num]^.author);
      goxy(hdr.header.titleX,hdr.header.titleY);
      pipe(menus[menuCount]^.articles[num]^.title);
   end;
end;

procedure drawmenu;
begin
   cls;
   readF(datFile,menus[menuCount]^.start,mem[$B800:0],menus[menuCount]^.stop-menus[menuCount]^.start);
   if (faded) then begin
      fade_in(pal,hdr.system.fadedelay);
      faded := false;
   end;
end;

procedure doArticle(num:byte;start,stop : longint; showheader,autoscroll,fade: boolean);
var key : char;
    max : word;
    line : word;
    current : word;
    onScreen : byte;
    show     : word;
    go,
    changed : boolean;
    first : byte;
begin
   max := ((stop - start) div 160);
   current := 1;
   key := ' ';
   go := true;
   changed := true;
   cls;
   if showheader then begin
      drawHeader(num);
      onScreen := 25 - hdr.header.line;
      show := onScreen * 160;
      first := hdr.header.line;
   end
   else begin
      onScreen := 25;
      show := onScreen * 160;
      first := 1;
   end;
   line := onScreen;

{   if stop - start <= show then begin
      readF(datFile,start,buf,stop-start);
      showBuf(buf,1,1,stop-start);
      go := false;
      if (faded) then begin
         fade_in(pal,hdr.system.fadedelay);
         faded := false;
      end;
      repeat
         key := readkey;
         if key = chr(0) then key := readkey;
      until (key = chr(escape)) OR (key = chr(enter));
   end;}

   if autoScroll then begin
      if (faded) then begin
         fade_in(pal,hdr.system.fadedelay);
         faded := false;
      end;
      if stop-start < show then begin
         readF(datFile,start,mem[$B800:xyToOffset(1,first)],stop-start);
      end
      else begin
         while (current <= max+1-onScreen) and go do begin
            readF(datFile,start+((current-1)*160),mem[$B800:xyToOffset(1,first)],show);
            if (showheader) AND (hdr.header.stop-hdr.header.start <> 0) then
               percentbar(line,max,hdr.header.percentlen,
                  hdr.header.percentx,hdr.header.percentY,hdr.header.percenthi,hdr.header.percentlo);
            cDelay(hdr.system.scrolldelay);
            waitRetrace;
            inc(current);
            inc(line);
            if keypressed then go := false;
         end;
         if line > max then begin
            dec(line);
            dec(current);
         end;
         if (not go) then begin
            go := true;
            while not(keyPressed) do if (hdr.system.doSlice) then timeSlice;
            if (keyPressed) then key := readkey;
            case key of
               chr(0) : key := readkey;
               chr(enter),
               chr(escape) : go := false;
            end;
         end;
      end;
      changed := false;
   end;

   while go do begin
      if changed then begin
         if (showheader) AND (hdr.header.stop-hdr.header.start <> 0) then
            percentbar(line,max,hdr.header.percentlen,
            hdr.header.percentx,hdr.header.percentY,hdr.header.percenthi,hdr.header.percentlo);
         if stop-start < show then begin
            readF(datFile,start,mem[$B800:xyToOffset(1,first)],stop-start);
         end
         else begin
           readF(datFile,start+((current-1)*160),mem[$B800:xyToOffset(1,first)],show);
         end;
         waitRetrace;
         if (faded) then begin
            fade_in(pal,hdr.system.fadedelay);
            faded := false;
         end;
         changed := false;
      end;

      while not(keyPressed) do if (hdr.system.doSlice) then timeSlice;
      if (keyPressed) then key := readkey;
      case key of
         chr(enter),
         chr(escape) : go := false;
         'b','B' : writeBinArticle(start,stop);
         't','T' : writeTextArticle(start,stop);
{         chr(tab) : begin
            if allowheader then begin
               cls;
               changed := true;
               if (showheader) then begin
                  showHeader := false;
                  line := line + (25-onScreen);
                  onScreen := 25;
                  show := onScreen * 160;
                  first := 1;
                  if stop - start <= show then begin
                     readF(datFile,start,buf,stop-start);
                     showBuf(buf,1,1,stop-start);
                     go := false;
                  end;
               end
               else begin
                  drawHeader(num);
                  showHeader := true;
                  onScreen := 25 - hdr.header.line;
                  line := line - hdr.header.line;
                  show := onScreen * 160;
                  first := hdr.header.line;
               end;
{               if stop - start <= show then begin
                  readF(datFile,start,buf,stop-start);
                  showBuf(buf,1,first,stop-start);
               end;}
{            end;
         end;}
         chr(0) : begin
            key := readkey;
            case key of
               chr(arrow_down) : begin
                  if (line < max) then begin
                     inc(current);
                     inc(line);
                     changed := true;
                  end;
               end;
               chr(arrow_up) : begin
                  if (line > onScreen) then begin
                     dec(current);
                     dec(line);
                     changed := true;
                  end;
               end;
               chr(arrow_home) : begin
                  if (line > onScreen) then begin
                     line := onScreen;
                     current := 1;
                     changed := true;
                  end;
               end;
               chr(arrow_end) : begin
                  if (line < max) then begin
                     current := max-onScreen+1;
                     line := max;
                     changed := true;
                  end;
               end;
               chr(arrow_pgup) : begin
                  if (line > onScreen) then begin
                     if (line-onScreen <= onScreen) then begin
                        dec(current,line-onScreen);
                        dec(line,line-onscreen);
                     end
                     else begin
                        dec(line,onScreen);
                        dec(current,onScreen);
                     end;
                     changed := true;
                  end;
               end;
               chr(arrow_pgdn) : begin
                  if (line < max) then begin
                     if (max-line < onScreen) then begin
                        inc(current,max-line);
                        inc(line,max-line);
                     end
                     else begin
                        inc(current,onScreen);
                        inc(line,onScreen);
                     end;
                     changed := true;
                  end;
               end;
            end;
         end;
      end;
   end;
   if (fade) then begin
      fade_out(pal,hdr.system.fadedelay);
      faded := true;
   end;
   cls;
end;

procedure lightbars;
var i : byte;
    current : byte;
    changed ,
    go      : boolean;
    key     : char;
begin
   current := 1;
   go := true;
   changed := true;
   drawMenu;
   while (go) do begin
      if changed then begin
         for i := 1 to menus[menuCount]^.count do begin
            goxy(menus[menuCount]^.articles[i]^.x,menus[menuCount]^.articles[i]^.y);
            pipe(menus[menuCount]^.articles[i]^.lo);
         end;
         goxy(menus[menuCount]^.articles[current]^.x,menus[menuCount]^.articles[current]^.y);
         pipe(menus[menuCount]^.articles[current]^.hi);
         changed := false;
      end;
      while not(keyPressed) do if (hdr.system.doSlice) then timeSlice;
      if (keyPressed) then key := readkey;
      case key of
         chr(escape) : begin
            if menus[menuCount]^.fallback = menus[menuCount]^.id then go := false
            else begin
               menuCount := menus[menuCount]^.fallback;
               current := 1;
               changed := true;
               drawMenu;
            end;
         end;
         chr(enter) : begin
            if menus[menuCount]^.fade then begin
               fade_out(pal,hdr.system.fadedelay);
               faded := true;
            end;
            case menus[menuCount]^.articles[current]^.action of
               0 : begin
                  changed := true;
                  doArticle(current,menus[menuCount]^.articles[current]^.start,menus[menuCount]^.articles[current]^.stop,
                     menus[menuCount]^.articles[current]^.showheader,menus[menuCount]^.articles[current]^.autoScroll,
                     menus[menuCount]^.articles[current]^.fade);
                  drawMenu;
               end;
               1 : begin
                  menuCount := menus[menuCount]^.articles[current]^.start;
                  current := 1;
                  changed := true;
                  drawMenu;
               end;
               2 : begin
                  menuCount := menus[menuCount]^.fallback;
                  current := 1;
                  changed := true;
                  drawMenu;
               end;
               3 : go := false;
               4 : hdr.system.cycle := not hdr.system.cycle;
               5 : hdr.system.doSlice := not hdr.system.doSlice;
               6 : begin
                  hdr.system.hiColor := not hdr.system.hiColor;
                  highBackGround(hdr.system.hiCOlor);
               end;
               7 : begin
                  hdr.system.doCursor := not hdr.system.doCursor;
                  if hdr.system.doCursor then showCursor
                  else hideCursor;
               end;
            end;
         end;
         'B','b' : if menus[menuCount]^.articles[current]^.action = 0 then
                      writeBinArticle(menus[menuCount]^.articles[current]^.start,menus[menuCount]^.articles[current]^.stop);
         'T','t' : if menus[menuCount]^.articles[current]^.action = 0 then
                      writeTextArticle(menus[menuCount]^.articles[current]^.start,menus[menuCount]^.articles[current]^.stop);
         chr(0) : begin
            key := readkey;
            case key of
               chr(arrow_down),
               chr(arrow_right) : begin
                  if current < menus[menuCount]^.count then begin
                     inc(current);
                     changed := true;
                  end
                  else if (hdr.system.cycle) then begin
                     current := 1;
                     changed := true;
                  end;
               end;
               chr(arrow_up),
               chr(arrow_left) : begin
                  if current > 1 then begin
                     dec(current);
                     changed := true;
                  end
                  else if (hdr.system.cycle) then begin
                     current := menus[menuCount]^.count;
                     changed := true;
                  end;
               end;
               chr(arrow_home) : begin
                  if current <> 1 then begin
                     current := 1;
                     changed := true;
                  end;
               end;
               chr(arrow_end) : begin
                  if current <> menus[menuCount]^.count then begin
                     current := menus[menuCount]^.count;
                     changed := true;
                  end;
               end;
            end;
         end;
      end;
   end;
end;

procedure cleanup;
var i,
    n : byte;
begin
   for i := 1 to menuCount do begin
      for n := 1 to menus[i]^.count do dispose(menus[i]^.articles[n]);
      dispose(menus[i]);
   end;
end;

procedure readdata;
var i,s : byte;
begin
   get_color(pal);
   faded := false;
   openFile(datFile,dfname,1);
   readF(datFile,1,hdr,sizeOf(magHeader));
   for i := 1 to hdr.menus do begin
      new(menus[i]);
      readF(datFile,filePos(datFile),menus[i]^,sizeOf(menuHeader));
      for s := 1 to menus[i]^.count do begin
         new(menus[i]^.articles[s]);
         readF(datFile,filePos(datFile),menus[i]^.articles[s]^,sizeOf(itemHeader));
      end;
   end;
end;

procedure exitMag;
begin
   cls;
   if not(hdr.exitheader.start - hdr.exitheader.stop = 0) then
   doArticle(0,hdr.exitheader.start,hdr.exitheader.stop,hdr.exitheader.showheader,hdr.exitheader.autoscroll,
             hdr.exitheader.fade);
   if (faded) then begin
      fade_in(pal,hdr.system.fadedelay);
      faded := false;
   end;
   cleanup;
   closeFile(datFile);
   if not hdr.system.doCursor then showCursor;
   highBackGround(false);
end;

procedure cmdline;
var f : file;
begin
   openFile(f,paramStr(0),1);
   readf(f,fileSize(f)-sizeOf(dfname),dfname,sizeOf(dfName));
   closeFile(f);
end;

procedure startEB;
begin
   saveCount := 1;
   menuCount := 1;
   cmdLine;
   readData;
   if hdr.system.doSlice then begin
      doSlice := true;
      tasker := findTasker;
   end
   else doSlice := false;
   cls;
   highBackGround(hdr.system.hiColor);
   if not hdr.system.doCursor then hideCursor;
   if not(hdr.introheader.start - hdr.introheader.stop = 0) then
      doArticle(0,hdr.introheader.start,hdr.introheader.stop,hdr.introheader.showheader,hdr.introheader.autoscroll,
                hdr.introheader.fade);
   lightbars;
   exitMag;
end;
end.