void flash_cursor();
void flash_net_cursor();


#define K_UP    1111
#define K_DOWN  1112
#define K_RIGHT 1113
#define K_LEFT  1114

#define K_PGUP 1
#define K_PGDN 2

#define K_HOME 3
#define K_END 4

#define K_F1 1210
#define K_F2 1211
#define K_F3 1212
#define K_F4 1213
#define K_F5 1214
#define K_F6 1215
#define K_F7 1216
#define K_F8 1217
#define K_F9 1218
#define K_F10 1219
#define K_F11 1220
#define K_F12 1221

#define K_ALT_F1 2749
#define K_ALT_F2 2750
#define K_ALT_F3 2751
#define K_ALT_F4 2752
#define K_ALT_F5 2753
#define K_ALT_F6 2754
#define K_ALT_F7 2755
#define K_ALT_F8 2756
#define K_ALT_F9 2757
#define K_ALT_F10 2758
#define K_ALT_F11 2923
#define K_ALT_F12 2739

#define K_ALT_A 201
#define K_ALT_B 202
#define K_ALT_C 203
#define K_ALT_D 204
#define K_ALT_E 205
#define K_ALT_F 206
#define K_ALT_G 207
#define K_ALT_H 208
#define K_ALT_I 209
#define K_ALT_J 210
#define K_ALT_K 211
#define K_ALT_L 212
#define K_ALT_M 213
#define K_ALT_N 214
#define K_ALT_O 215
#define K_ALT_P 216
#define K_ALT_Q 217
#define K_ALT_R 218
#define K_ALT_S 219
#define K_ALT_T 220
#define K_ALT_U 221
#define K_ALT_V 222
#define K_ALT_W 223
#define K_ALT_X 224
#define K_ALT_Y 225
#define K_ALT_Z 226

#define K_ALT_LEFT 99991  
#define K_ALT_RIGHT 99992

#define K_ALT_MINUS 2813
#define K_ALT_PLUS 2819

#define K_ALT_GMINUS 9945
#define K_ALT_GPLUS 9943

#define K_INSERT 331
#define K_DC 330
#define K_BACKSPACE 263

#define K_ST_UP 397
#define K_ST_DOWN 401
#define K_ST_LEFT 371
#define K_ST_RIGHT 372

#define K_QUICKCOLOR 2797
#define K_TAB 9
#define K_SH_TAB 99994
#define K_ESC 27


char *gdrver="linux";
int f;
int VtNum = -1;
int VtFd = -1;
int VcsFd = -1;
int flash=1;
struct stat stb;

void curmove(int y,int x)
{
    int blah;

        lseek(f,2,0);
        write(f,&x,1);
        write(f,&y,1);

    lseek(f,4+2*(x+y*scrn.cols),0);
}


void cmove(int y,int x)
{
    int blah;

    if(flash==0){
        lseek(f,2,0);
        write(f,&x,1);
        write(f,&y,1);
    }
    lseek(f,4+2*(x+y*scrn.cols),0);
}

void cls()
{
    int i;
    int b=32,c=7;

    lseek(f,2,0);
    write(f,0,1);
    write(f,0,1);

    lseek(f,4,0);
    for(i=0;i<160*bild[curpg].screenheight;i++){
        write(f,&b,1);
        write(f,&c,1);
    }
    cmove(0,0);
}

void myprintc(int c)
{
    write(f,&c,1);
    write(f,&actcol,1);
}

void init_oszeug()
{
    char ttyname[20];
    char vcsname[20];
    char c;
    struct termios buf;


    if (fstat(0, &stb) != 0) {
        perror("stat");
        exit(1);
    }

    /* thanks to fte ;) */
    VtNum = MINOR(stb.st_rdev);
    sprintf(vcsname, "/dev/vcsa%d", VtNum);
    if ((f = open(vcsname, O_RDWR)) == -1) {
        perror("open");
//          die("failed to open /dev/vcsa*");
        exit(1);
    }

    read(f,&scrn,4);

    lseek(f,4,0);


    tcgetattr(0,&save_termios);
    buf=save_termios;
    buf.c_lflag &= ~(ECHO | ICANON | IEXTEN);
    buf.c_iflag &= ~(BRKINT | ICRNL | INPCK | ISTRIP | IXON);
    buf.c_cflag &= ~(CSIZE | PARENB);
    buf.c_cflag |= CS8;
    buf.c_cflag &= ~(OPOST);
    buf.c_cc[VMIN]=1;
    buf.c_cc[VTIME]=0;
    tcsetattr(0,TCSAFLUSH, &buf);
    fcntl(0,F_SETFL,O_NONBLOCK);

}

int ggetch(int flasch,int updatestuff)
{
    char c, cn;
    int i,in;
    char buffer[80];
    char temp[80];
    int sendback=0,a=0,bytesread=0, bufpos=0;

    
    while(sendback==0){
        c=getchar();

        if(flash==1){
            if(flasch==1){
                a=a+4;
                if(a>64)a=4;
                flash_cursor(a,1);
                if(netz.connected==1){
                    flash_net_cursor(a,1);
                }
            }
        }

        if(netz.connected==1){
            cn=0;
	    in=0;
	    bufpos=0;
            bytesread=read(netz.fd,&cn,1);
            if(bytesread>0){
                /*for(in=0;in<5;in++){
                    
                    buffer[bufpos]=cn;
                    bufpos++;
                    while((bytesread=read(netz.fd,&cn,1))<1);
                }*/
		buffer[bufpos]=cn;
		bufpos++;
		bytesread=0;
		while(bytesread<4){
			in=read(netz.fd,&cn,1);
			if(in>0){
				bytesread=bytesread+in;
				buffer[bufpos]=cn;
				bufpos++;
			}
		}
		
                if(buffer[0] == 'c'){
                    if(updatestuff==1)flash_net_cursor(0,0);
                    netz.xpos=buffer[1];
                    netz.ypos=buffer[2];
                }
                if(buffer[0] == 'o'){
                    if(buffer[1] == 'd')delete_colm(buffer[2],1);
                    if(buffer[1] == 'i')insert_colm(buffer[2],1);
                        if(updatestuff==1)update_ansi();
                }
                if(buffer[0] == 'l'){  /* line [i]nsert [d]elete */
                    if(buffer[1]=='i')insert_line(buffer[2],1);
                    if(buffer[1]=='d')delete_line(buffer[2],1);
                    if(updatestuff==1)update_ansi();
                }

                if(buffer[0] == 'n'){
                    initnew();
                    update_ansi();
                    show_statusbar();
                }

                if(buffer[0] == 'y'){
                    initnew();
                    bild[curpg].lastline=buffer[1];
                    resize();
                    syncronize(bild[curpg].lastline,1);
                    show_statusbar();
                    update_ansi();
                    curctrl();
                 }
                
                if(buffer[0] == 'i'){
                    netz.insert=buffer[1];
                }

                if(buffer[0] == 'b'){ /* backspace */
                    
                    buffer[1]=netz.xpos;
                    buffer[2]=netz.ypos;
                    
                    delete_char(1);
                    update_line(netz.ypos,1);
                }
                if(buffer[0] == 's'){
                    /* 1 xpos 2 ypos 3 char 4 color */
                    if(netz.insert==1){
                        insert_char(1);
                    }
                        bild[curpg].data_char[buffer[1]+(buffer[2])*scrn.cols]=buffer[3];
                        bild[curpg].data_col[buffer[1]+(buffer[2])*scrn.cols]=buffer[4];

                        netz.xpos=buffer[1];
                        netz.xpos++;
                        netz.ypos=buffer[2];

                        if(updatestuff==1)update_line(buffer[2],1);
                }

                bufpos=0;
            }
            
            if(bytesread==0){
                printf("verbindung weg\n");
                sleep(1);
                ende();
            }
          
        }

        usleep(0.1);
        
        if(c>0){
            sendback=c;
            if(c==9)sendback=K_TAB;
            if(c==127)sendback=K_BACKSPACE;
        }

        if(c==27){
            c=getchar();
            if(c<1)sendback=27;
            if(c=='o')sendback=K_ALT_O;
            if(c=='e')sendback=K_ALT_E;
            if(c=='b')sendback=K_ALT_B;
            if(c=='s')sendback=K_ALT_S;
            if(c=='c')sendback=K_ALT_C;
            if(c=='l')sendback=K_ALT_L;
            if(c=='p')sendback=K_ALT_P;
            if(c=='n')sendback=K_ALT_N;
            if(c=='q')sendback=K_ALT_Q;
            if(c=='i')sendback=K_ALT_I;
            if(c=='m')sendback=K_ALT_M;
            if(c=='u')sendback=K_ALT_U;
            if(c=='y')sendback=K_ALT_Y;
            if(c=='a')sendback=K_ALT_A;
            if(c=='x')sendback=K_ALT_X;
            if(c=='w')sendback=K_ALT_W;

            if(c=='d')sendback=K_ALT_D; /* DEL ME !!!!! */
            
            if(c==91){
                c=getchar();
                if(c==66)sendback=K_DOWN;
                if(c==65)sendback=K_UP;
                if(c==67)sendback=K_RIGHT;
                if(c==68)sendback=K_LEFT;
		
		if(c==49){
			c=getchar();
			if(c==55)sendback=K_F6;
			if(c==56)sendback=K_F7;
			if(c==57)sendback=K_F8;
			if(c==126)sendback=K_HOME;
			if(c!=126)c=getchar();
			
		}
		if(c==50){
			c=getchar();
			if(c==48)sendback=K_F9;
			if(c==49)sendback=K_F10;
			if(c==51)sendback=K_F11;
                        if(c==52)sendback=K_F12;

			if(c==126)sendback=K_INSERT;
			if(c!=126)c=getchar();
		}
		if(c==91){
			c=getchar();
			if(c==65)sendback=K_F1;
			if(c==66)sendback=K_F2;
			if(c==67)sendback=K_F3;
			if(c==68)sendback=K_F4;
			if(c==69)sendback=K_F5;
		}

                if(c==51){
                    sendback=K_DC;
                    c=getchar();
                }
                if(c==52){
                    sendback=K_END;
                    c=getchar();
                }
                if(c==54){
                    sendback=K_PGDN;
                    c=getchar();
                }
                if(c==53){
                    sendback=K_PGUP;
                    c=getchar();
                }
            }
        }
    }

    if(flash==1){
        if(flasch==1)flash_cursor(0,0);
    }
    if(netz.connected)flash_net_cursor(0,0);

    return(sendback);
}

void endoszeug()
{
    tcsetattr(0,TCSAFLUSH,&save_termios);
    close(f);
}

int testfile(char *name)
{
    int tested=0;
    struct stat bla;
    char pfad[555];

    sprintf(pfad,"%s/%s",pathname,name);
    
    stat(pfad, &bla);
    if(S_ISDIR(bla.st_mode)) tested=1;
    if(S_ISREG(bla.st_mode)) tested=0;

    /* 0 file 1 dir 2 scheisse */
    return(tested);
}
