<?php

require_once("class.ansiconv.php");
require_once("class.sauce.php");

/**
* class ansi
*
* some kind of wrapper to get sauce information and to resize ansi images
*
* @author Stefan Kesseler <poti@kaoz.org>
* @package blockshow
*
*/
class ansi {

    /**
    * ansi::$filename
    *
    * stores ansfile
    *
    */
    var $filename;

    /**
    * ansi::$sauce
    *
    * stores sauce object for later use
    *
    * @see ansi::getSauce()
    *
    */
    var $sauce;

    /**
    * ansi::ansi()
    *
    * checks file for existance, initializes some variables
    *
    * @param string $filname filename of the ansifile to work with
    *
    */
    function ansi($filename) {
        if (file_exists($filename)) {
           $this->filename = $filename;
           $this->sauce = false;
           return true;
        }
        else
        {
           $this = false;
           return false;
        }
    }

    /**
    * ansi::getSauce()
    *
    * reads in sauce information
    *
    * @return array sauce information, false if no sauce available
    *
    */
    function getSauce() {
        if ($this->sauce === false) {
            $this->sauce = new sauce($this->filename);
        }
        return $this->sauce->data;
    }

    /**
    * ansi::convert()
    *
    * converts ansi to png
    *
    * @param bool $size640 true for 640 width file, false for 80 pixel width
    * @param string $outfile filename of resulting png, blank for direct output
    */
    function convert($size640=true,$outfile="") {
        $ansiconv = new ansiconv($this->filename,$size640,$outfile);
        $ansiconv->output();
    }

}

?>
