Unit AF_ISWRI;    { Writer/Editor }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
                         Years of writing experience : [...]
                        Number of articles published : [....]
       How long does it take you to write a document : [......................]
        How often can you produce documents for ACiD : [......................]
         What is your favorite text editing software : [......................]

What style(s) of writing do you prefer (editorial, p.r., technical, etc.)
[.............................................................................]
[.............................................................................]

What type of articles or documents would you like to produce under ACiD :
[.............................................................................]
[.............................................................................]
[.............................................................................]

Additional Comments :
[.............................................................................]
[.............................................................................]
[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotArticles: PictureIOOBJ;
                Time       : LateralIOOBJ;
                HowOften   : LateralIOOBJ;
                Software   : LateralIOOBJ;
                Style1     : LateralIOOBJ;
                Style2     : LateralIOOBJ;
                ArtType1   : LateralIOOBJ;
                ArtType2   : LateralIOOBJ;
                ArtType3   : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
              END;
VAR   FOrm         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_WRIT.OBJ}
PROCEDURE APP_WRIT; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_WRIT, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotArticles);
     AddItem(Form^.Time);
     AddItem(Form^.HowOften);
     AddItem(Form^.Software);
     AddItem(Form^.Style1);
     AddItem(Form^.Style2);
     AddItem(Form^.ArtType1);
     AddItem(Form^.ArtType2);
     AddItem(Form^.ArtType3);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_WRIT^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH FORM^ DO BEGIN
    Writeln(Out, '  ,-------------------------------.');
    Writeln(Out, ',-'' Writer/Editor Application    `-----------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years of writing experience : ', Years.GetValue);
    Writeln(Out, 'Number of articles produced : ', TotArticles.GetValue);
    Writeln(Out, 'How much time does it take to write a document?   : ', Time.GetValue);
    Writeln(Out, 'How often can you produce documents for ACiD?     : ', HowOften.GetValue);
    Writeln(Out, 'What is yoru favorite text editing software?      : ', Software.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What style(s) of writing do you prefer (editorial, P.R., technical, etc.)?');
    Writeln(Out, Style1.GetValue);
    Writeln(Out, Style2.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What type of articles or documents would you like to produce under ACiD :');
    Writeln(Out, ArtType1.GetValue);
    Writeln(Out, ArtType2.GetValue);
    Writeln(Out, ArtType3.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH FORM^ DO BEGIN
     Years.Done;
     TotArticles.Done;
     Time.Done;
     HowOften.Done;
     Software.Done;
     Style1.Done;
     Style2.Done;
     ArtType1.Done;
     ArtType2.Done;
     ArtType3.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotArticles.Init(57, 6, '####');
     TotArticles.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     HowOften.Init(57, 8, 22, 50);
     HowOften.SetPadChar('.');

     Software.Init(57, 9, 22, 50);
     Software.SetPadChar('.');

     Style1.Init(2, 12, 77, 77);
     Style1.SetPadChar('.');

     Style2.Init(2, 13, 77, 77);
     Style2.SetPadChar('.');

     ArtType1.Init(2, 16, 77, 77);
     ArtType1.SetPadChar('.');

     ArtType2.Init(2, 17, 77, 77);
     ArtType2.SetPadChar('.');

     ArtType3.Init(2, 18, 77, 77);
     ArtType3.SetPadChar('.');

     Comments1.Init(2, 21, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 22, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 23, 77, 77);
     Comments3.SetPadChar('.');
  END;
END.
