UNIT SUPPORT;           { Support functions used by several of the AppGen units }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

PROCEDURE SlideUp  (ScreenPtr : Pointer;
                    X,Y : WORD; PipedTxt : String); { (optional) Write this text also before sliding, empty string for none }
PROCEDURE SlideDown(ScreenPtr : Pointer;
                    X,Y : WORD; PipedTxt : String); { (optional) Write this text also before sliding, empty string for none }

PROCEDURE SlideForm (ScreenPtr : Pointer; Page, NumPages, Direction: Integer);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES CRTVGA,
     TotFAST,
     TotStr;


PROCEDURE SlideUp (ScreenPtr : Pointer;
                   X,Y : WORD; PipedTxt : String); { (optional) Write this text also before sliding, empty string for none }
VAR Split : INTEGER;
    Slider: INTEGER;
BEGIN
  Screen.CursOff;
  { When sliding UP,                 }
  {    Copy VideoPage1 to VideoPage2 }
  {    Load <Screen> into VideoPage1 }
  Move(VGA_Memory[0], VGA_Memory[4000], 4000);  { P1 -> P2 }
  VGA_Split(2000,400);                          { Split at 400, now showing Page2 }
  Move(ScreenPtr^, VGA_Memory[0], 4000);        { And load new screen in P1 }

  { Load optional text (into P1) }
  WriteAT_Piped(X, Y, PipedTxt);

  { And slide up }
  Split:=400;
  Slider:=28;
  REPEAT
    IF (Split>0) THEN
       VGA_Split(2000,Split);
    Dec(Split,Slider);
    IF (Slider>1) THEN
       Dec(Slider);
  UNTIL Split<=0;

  VGA_Split(0,0);       { Disable split }
END;


PROCEDURE SlideDown (ScreenPtr : Pointer;
                     X,Y : WORD; PipedTxt : String); { (optional) Write this text also before sliding, empty string for none }
VAR Split : INTEGER;
    Slider: INTEGER;
BEGIN
  Screen.CursOff;
  { When sliding Down,               }
  {    Load <Screen> into VideoPage2 }
  {    Slide                         }
  {    Copy VideoPage2 to VideoPage1 }
  {    Disable splitscreen           }
  Move(ScreenPtr^, VGA_Memory[4000], 4000);  { And load new screen in P2 }

  { Load optional text (into P2, -> Y+25) }
  WriteAT_Piped(X, Y+25, PipedTxt);

  { And slide up }
  Split:=1;
  Slider:=1;
  REPEAT
    VGA_Split(2000,Split);
    Inc(Split,Slider);
    Inc(Slider);
  UNTIL Split>=400;

  Move(VGA_Memory[4000], VGA_Memory[0], 4000);  { P2 -> P1 }

  VGA_Split(0,0);       { Disable split }
END;

PROCEDURE SlideForm (ScreenPtr : Pointer; Page, NumPages, Direction: Integer);
VAR St  : String;
    X   : Integer;
BEGIN
  St:='';
  X:=79;

  IF (Page=NumPages) THEN BEGIN
    St := St+'|08[|07F10 to save application|08]';
    Dec(X,25);
  END;

  St := St+'|08[|07PgUp/PgDn to advance pages - page '+IntToStr(Page)+' of '+IntToStr(NumPages)+'|08]';
  Dec(X,42);

  IF Direction=1 THEN
     SlideDown(ScreenPtr, X, 25, St)
  ELSE
     SlideUp(ScreenPtr, X, 25, St);
END;

BEGIN
END.