#!/bin/sh
# 
# This shell script tests the various configuration modes for 
# the wrapper.  
#
# $Id: test_run.sh,v 2.0 1997/06/16 04:37:37 jzbiciak Exp $
#

[ ! -z "$UID" ]  && [ $UID -eq 0 ]  && echo "Do not run as root." && exit 0;
[ ! -z "$EUID" ] && [ $EUID -eq 0 ] && echo "Do not run as root." && exit 0;

rm -f passthru0 passthru1 .varset .ctrl1 .ctrl4 .user_info

USER=`whoami`
LOGNAME=`whoami`
export USER LOGNAME

echo "USER=$USER ; LOGNAME=$LOGNAME" > .user_info

unset `set | cut -f1 -d=` 2> /dev/null
export TEST0 TEST1 TEST2 TEST3 TEST4 TEST5 TEST6 TEST7

echo _A | tr _ '\001' > .ctrl1
echo ____A | tr _ '\001' > .ctrl4

echo "Testing environment-variable functionality..."
echo ""

for I in 0 1 2 3 4 5 6 7 8 9 ; do

  echo "Munging TEST$I..."

  echo "--------------------------------" >> passthru1
  echo "--------------------------------" >> passthru0

  rm -f .varset; echo "#!/bin/sh" > .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo unset TEST$J >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I unset" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I unset" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

  rm -f .varset; echo "#!/bin/sh" > .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo TEST$J=AAAAAAAA >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I short" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I short" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

  rm -f .varset; echo "#!/bin/sh" > .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo TEST$J=AAAAAAAAA >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I medium" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I medium" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

  rm -f .varset; echo "#!/bin/sh" > .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo TEST$J=AAAAAAAAAAAAAAAAA >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I long" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I long" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

  rm -f .varset; echo "#!/bin/sh" > .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo TEST$J='`cat .ctrl1`' >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I remap 1" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I remap 1" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

  rm -f .varset
  for J in 0 1 2 3 4 5 6 7 ; do
    if [ $I -eq $J ] ; then echo TEST$J='`cat .ctrl4`' >> .varset; fi
    if [ $I -ne $J ] ; then echo TEST$J=X >> .varset; fi
  done 
  . .varset

  echo "" >> passthru1
  echo "test $I remap 4" >> passthru1
  ./test1a >> passthru1
  echo "exit code: $?" >> passthru1

  echo "" >> passthru0
  echo "test $I remap 4" >> passthru0
  ./test2a >> passthru0
  echo "exit code: $?" >> passthru0

done
rm -f .varset

unset TEST0 TEST1 TEST2 TEST3 TEST4 TEST5 TEST6 TEST7

echo "--------------------------------" >> passthru1
echo "--------------------------------" >> passthru0

. .user_info

echo "Setting USER=$USER, LOGNAME=$LOGNAME"
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru1
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru0

export USER LOGNAME
./test1a >> passthru1
./test2a >> passthru0

echo "" >> passthru1
echo "" >> passthru0

USER="*garbage"
echo "Setting USER=$USER, LOGNAME=$LOGNAME"
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru1
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru0

export USER LOGNAME
./test1a >> passthru1
./test2a >> passthru0

echo "" >> passthru1
echo "" >> passthru0

. .user_info

LOGNAME="*garbage"
echo "Setting USER=$USER, LOGNAME=$LOGNAME"
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru1
echo "Setting USER=$USER, LOGNAME=$LOGNAME" >> passthru0

export USER LOGNAME
./test1a >> passthru1
./test2a >> passthru0

echo "" >> passthru1
echo "" >> passthru0

. .user_info

LOGNAME="_goober_"
for I in 0 1 2 3 4 5 6 7 8 9 A 
do 
	LOGNAME="$LOGNAME$LOGNAME"; 
done
echo "Setting USER=$USER, LOGNAME=(16K chars)"
echo "Setting USER=$USER, LOGNAME=(16K chars)" >> passthru1
echo "Setting USER=$USER, LOGNAME=(16K chars)" >> passthru0

export USER LOGNAME
./test1a >> passthru1
./test2a >> passthru0

echo "" >> passthru1
echo "" >> passthru0

. .user_info

echo "Reset user info."


echo ""
echo "Testing commandline argument functionality..."
echo ""

./test_drvr test_wrap_1 passthru1
./test_drvr test_wrap_2 passthru1

rm -f .varset .ctrl1 .ctrl4 .user_info
echo "Done.  Output is in passthru0 and passthru1"
