/* Simple test program which reports argv[]/envp[] of wrapped program. */
/* Dumps argv/envp contents along w/ length information.               */
/*                                                                     */
/* -- J. Zbiciak                                                       */

static char rcsid[]="$Id: test_clnt.c,v 2.0 1997/06/16 04:37:37 jzbiciak Exp $";

#include <stdio.h>
#include <string.h>

int main(int argc, char *argv[], char *envp[])
{
	int i;
	char *s;

	s=rcsid; /* to keep gcc -Wall from complaining. */

#ifdef NAME
	printf("Client name: '" NAME "'\n\n");
#endif

	printf("Command-line arguments:\n");

	for (i=0;i<argc;i++)
	{
		printf("argv[%2d]: len=%3d, '%s'\n",
			i,strlen(argv[i]),argv[i]);
	}
	
	if (!envp) 
		return 0;

	printf("\nEnvironment:\n");
	for (i=0;envp[i];i++)
	{
		printf("envp[%2d]: len=%3d, '%s'\n",
			i,strlen(envp[i]),envp[i]);
	}

	return 0;
}
