/****
 * socdefs.h
 *  - Contains global variables for Socket Demon
 ****/
#ifndef _SOCDEFS_H_
#define _SOCDEFS_H_

#define SOCDEMON_PORT        6003             /* Port the server attaches to */
#define SOCDEMON_PAUSE       3                /* Number of seconds from when */
                                              /* you start until you get     */
                                              /* your prompt back.. used to  */
                                              /* sync the parent with child  */
#define SOCDEMON_DATE        "Apr. 15, 1994"  /* Release date                */
#define SOCDEMON_VER         "1.3"            /* version                     */
#define SOCDEMON_NAME        "Socket Demon"   /* The name of the program.    */
#define SOCDEMON_PROMPT      "demon# "        /* The prompt                  */
#define SOCDEMON_MAX_BACKLOG 5                /* Maximum allowable length of */
                                              /* listen queue on the internet*/
                                              /* port.                       */
#define HELLO_MSG_LEN        80               /* string length of hello msg  */
#define MAX_INPUT_LEN        80               /* maximum length of input str */
#define MAX_OUTPUT_LEN       80               /* max length of output string */
/* undefine or nil out the following to not use a password on the port       */
/* to change it, use the program 'genpw' included in the distribution        */
#define SOCDEMON_PASSWORD    "K-sbFcsV8D3Fw"           /* This is 'demon' */
/* undefine the following if don't want the -log and -command commandline */
/* options activated.. will save a bit of program size                    */
#define LOG_TO_DEATH
#define PROG_SPEC_LEN 80

#define CANT_MAKE_SOCKET     255
#define CANT_SHUTDOWN_SOCKET 254
#define CANT_CLOSE_SOCKET    253
#define CANT_BIND_SOCKET     252
#define LISTEN_FAILED        251
#define ACCEPT_FAILED        250
#define SOCKET_WRITE_FAILED  249
#define BAD_PARAMETERS       248
#define SOCKET_INPUT_ERROR   247
#define CANT_OPEN_LOG_FILE   246

typedef enum {
   false,
   true
} boolean;

extern char *program_name[PROG_SPEC_LEN];
extern boolean silent_mode;
extern boolean debug_mode;
extern int port_to_use;

#endif /* _SOCDEFS_H_ */
