/****
 * soclog.c
 *  - This file contains routines for logging functions.
 ****/
#include <stdio.h>
#include "soclog.h"

#ifdef LOG_TO_DEATH

boolean     log_to_file;
boolean     command_log;
char        log_file[PROG_SPEC_LEN];
char        cmd_log_file[PROG_SPEC_LEN];
dotted_quad client_dotted_q;
char        dotted_4_str[20];
char        log_string[MAX_OUTPUT_LEN];

/****
 * log_stuff()
 *   - This routine will log basic actions (like connects,
 *     bad passwords, disconnects, and kills) to a user
 *     specified file, or the default (argv[0].log), or
 *     none at all if the -l command line options is *NOT*
 *     specified.
 *   - Note that the log file is opened, written to, and closed
 *     right away, this is because sometimes things will get
 *     prematurely killed etc. etc. so we might as well close
 *     and flush all the files we use when we're done..
 ****/
void log_stuff (log_type)
t_log_type log_type;
{
 FILE *log_file_handle;
 long *date_stamp;
 char date_string[30];

   if (log_to_file == false) {
      return;
   }

   if ((log_file_handle = fopen(log_file,"a")) == NULL) {
      /* ah well, can't open, let's spit out an error message */
      /* and then return...                                   */
      soc_fprintf(stderr,"ERROR(%d): Unable to open log file \"%s\".\n",
                  CANT_OPEN_LOG_FILE, log_file);
      return;
   }

   /* date stamp the file */
   time(&date_stamp);
   strcpy(date_string,ctime(&date_stamp));
   date_string[strlen(date_string)-1] = 0;
   fprintf(log_file_handle,"%s: ",date_string);

   switch (log_type) {
    case accepting_connection:
      fprintf(log_file_handle,"Connection received from %s\n",
              dotted_4_str);
      break;
    case bad_password:
      fprintf(log_file_handle,"Invalid password (%s) from %s.\n",
              log_string, dotted_4_str);
      break;
    case connection_closed:
      fprintf(log_file_handle,"Disconnecting from %s\n", dotted_4_str);
      break;
    case killed_by_command:
      fprintf(log_file_handle,"Killed from %s\n", dotted_4_str);
      break;
   }
   fclose(log_file_handle);
}

/****
 * log_command()
 *   - logs and date stamps every command that is entered by the
 *     user..
 ****/
void log_command(command_string)
char *command_string;
{
 FILE *log_file_handle;
 long *date_stamp;
 char date_string[30];

   if (command_log == false) {
      return;
   }

   if ((log_file_handle = fopen(cmd_log_file,"a")) == NULL) {
      soc_fprintf(stderr,"ERROR(%d): Unable to open command log file \"%s\".\n",
                  CANT_OPEN_LOG_FILE, log_file);
      return;
   }

   /* date stamp the file */
   time(&date_stamp);
   strcpy(date_string,ctime(&date_stamp));
   date_string[strlen(date_string)-1] = 0;
   fprintf(log_file_handle,"%s-%s cmd: %s\n", date_string,
           dotted_4_str, command_string);
   fclose(log_file_handle);
}


#endif /* LOG_TO_DEATH */
