#ifndef _rip_h
#define _rip_h

#include <linux/ip.h>
#include <linux/udp.h>

#define RIP_VERSION	1

enum {
	RIP_REQUEST = 1,
	RIP_RESPONSE = 2,
	RIP_TRACEON = 3,
	RIP_TRACEOFF = 4,
	RIP_RESERVED = 5
};

struct rippayload {
	__u16	family;
	__u16	res2;
	__u32	address;
	__u32	res3;
	__u32	res4;
	__u32	metric;
};

struct riphdr {
	__u8			comm;
	__u8			version;
	__u16			res1;
	struct rippayload	payload;
};

struct ripdgramhdr {
	struct iphdr	ip;
	struct udphdr	udp;
	struct riphdr	rip;
};

#endif
