#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <getopt.h>

#include "rip.h"
#include "resolve.h"

#define DEFAULT_TIMEOUT		2


int main(int argc, char *argv[])
{
	int n, ch, timeout = DEFAULT_TIMEOUT, s, totlen;
	struct sockaddr_in to;
	char buf[sizeof(struct ripdgramhdr) + (sizeof(struct rippayload) << 9) - sizeof(struct rippayload)];
	struct ripdgramhdr *ripdgram = (struct ripdgramhdr *)buf;
	struct riphdr *rip = &ripdgram->rip;
	struct udphdr *udp = &ripdgram->udp;
	struct iphdr *ip = &ripdgram->ip;
	struct rippayload *payload;
	char hostname[MAXHOSTNAMELEN], *tosend;
	int spoof = 0;
	ulong host;

	while ((ch = getopt(argc, argv, "t:s:")) != EOF)
		switch ((char)ch) {
		case 't':
			timeout = atoi(optarg);
			break;
		case 's':
			ip->saddr = resolve(optarg);
			spoof = 1;
			break;
		}

	argv += optind;
	argc -= optind;

	if (argc < 4 || (argc - 1)%3) {
		printf(
			"usage: rip "
			"[-t timeout] "
			"[-s host] "
			"host family address metric [family address metric ...]"
			"\n"
		);
		exit(1);
	}

	host = resolve(*argv++);

	if (!spoof) {
		s = socket(AF_INET, SOCK_DGRAM, 0);
		if (s < 0) {
			perror("socket");
			exit(1);
		}

		tosend = (char *)&ripdgram->rip;
		totlen = sizeof(struct riphdr);
	} else {
		s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
		if (s < 0) {
			perror("socket");
			exit(1);
		}

		ip->daddr = host;

		udp->source = htons(IPPORT_ROUTESERVER);
		udp->dest = htons(IPPORT_ROUTESERVER);
		udp->len = htons(sizeof(struct udphdr) + sizeof(struct riphdr));

		ip->ihl = (sizeof(struct iphdr) >> 2);
		ip->version = 4;
		ip->tos = 0;	
		ip->tot_len = htons(sizeof(ripdgram));
		ip->id = htons(1);
		ip->frag_off = 0;
		ip->ttl = 64;
		ip->protocol = IPPROTO_UDP;

		tosend = (char *)ripdgram;
		totlen = sizeof(struct ripdgramhdr);
	}

	rip->comm = RIP_RESPONSE;
	rip->version = RIP_VERSION;
	rip->res1 = 0;

	payload = &rip->payload;

	while (1) {
		payload->family = htons(atoi(*argv++));
		payload->res2 = 0;
		payload->address = resolve(*argv++);
		payload->res3 = 0;
		payload->res4 = 0;
		payload->metric = htonl(atol(*argv++));

		if (!*argv)
			break;

		totlen += sizeof(struct rippayload);
		++payload;
	};

	to.sin_family = AF_INET;
	to.sin_port = htons(IPPORT_ROUTESERVER);
	to.sin_addr.s_addr = host;

	n = sendto(s, tosend, totlen, 0, (struct sockaddr *)&to, sizeof(to));
	if (n != totlen) {
		perror("sendto");
		exit(1);
	}

	return close(s);
}
