#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <setjmp.h>
#include <signal.h>
#include <getopt.h>

#include "resolve.h"
#include "rip.h"

#define DEFAULT_TIMEOUT		2
#define PORT			5000
#define RIP_BUF			1024


int main(int argc, char *argv[])
{
	struct sockaddr_in to, from;
	int s, n, ch, timeout = DEFAULT_TIMEOUT, opt_h = 0;
	char hostname[MAXHOSTNAMELEN], buf[RIP_BUF];
	struct hostent *hp;
	struct riphdr rip, *response = (struct riphdr *)buf;
	struct in_addr addr;
	struct rippayload *payload;

	while ((ch = getopt(argc, argv, "t:h")) != EOF)
		switch ((char)ch) {
		case 't':
			timeout = atoi(optarg);
			break;
		case 'h':
			opt_h = 1;
			break;
		}

	argv += optind;
	argc -= optind;

	if (argc != 1) {
		printf(
			"usage: ripquery "
			"[-h] "
			"[-t timeout] "
			"host "
			"\n"
		);
		exit(1);
	}

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}

	if (gethostname(hostname, MAXHOSTNAMELEN) < 0) {
		perror("gethostname");
		exit(1);
	}

	hp = gethostbyname(hostname);
	if (!hp) {
		perror("gethostbyname");
		exit(1);
	}

	from.sin_family = AF_INET;
	from.sin_port = htons(PORT);
	from.sin_addr.s_addr = *(__u32 *)hp->h_addr;

	if (bind(s, (struct sockaddr *)&from, sizeof(from)) < 0) {
		perror("bind");
		exit(1);
	}

	to.sin_family = AF_INET;
	to.sin_port = htons(IPPORT_ROUTESERVER);
	to.sin_addr.s_addr = resolve(argv[0]);

	if (connect(s, (struct sockaddr *)&to, sizeof(to)) < 0) {
		perror("socket");
		exit(1);
	}

	rip.comm = RIP_REQUEST;
	rip.version = RIP_VERSION;
	rip.res1 = 0;
	rip.payload.family = 0;
	rip.payload.res2 = 0;
	rip.payload.address = 0;
	rip.payload.res3 = 0;
	rip.payload.res4 = 0;
	rip.payload.metric = htonl(16);

	alarm(timeout);

	n = send(s, &rip, sizeof(rip), 0);
	if (n != sizeof(rip)) {
		perror("send");
		exit(1);
	}

	n = recv(s, response, RIP_BUF, 0);

	alarm(0);

	if (!opt_h)
		printf("%-8s%-16s%-8s\n", "Metric", "Address", "Family");

	payload = &response->payload;
	while (n > 0) {
		addr.s_addr = payload->address;
		printf("%-8i%-16s%-8i\n", ntohs(payload->family), inet_ntoa(addr), ntohl(payload->metric));

		++payload;
		n -= 20;
	}

	return close(s);
}
